/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.paymentreports.ValidFrequencyBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.util.GlobalVariables;

public class FrequencyBaseCodeValuesFinder
extends KeyValuesBase {
    private String frequencyCode;
    private KeyValuesService keyValuesService;

    public FrequencyBaseCodeValuesFinder() {
    }

    public FrequencyBaseCodeValuesFinder(String frequencyCode) {
        this.frequencyCode = frequencyCode;
    }

    public List<KeyValue> getKeyValues() {
        if (GlobalVariables.getUserSession().retrieveObject("awfreqbase" + this.getFrequencyCode()) != null) {
            return (List)GlobalVariables.getUserSession().retrieveObject("awfreqbase" + this.getFrequencyCode());
        }
        Collection validFrequencyBaseCodes = this.getKeyValuesService().findAll(ValidFrequencyBase.class);
        return this.getKeyValues(this.getUniqueRelevantFrequencyBaseCodes(validFrequencyBaseCodes));
    }

    public String getFrequencyCode() {
        return this.frequencyCode;
    }

    public void setFrequencyCode(String frequencyCode) {
        this.frequencyCode = frequencyCode;
    }

    protected KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = (KeyValuesService)KraServiceLocator.getService("keyValuesService");
        }
        return this.keyValuesService;
    }

    protected Set<String> getUniqueRelevantFrequencyBaseCodes(Collection<ValidFrequencyBase> validFrequencyBaseCodes) {
        HashSet<String> uniqueRelevantFrequencyBaseCodes = new HashSet<String>();
        for (ValidFrequencyBase validFrequencyBase : validFrequencyBaseCodes) {
            if (!StringUtils.equalsIgnoreCase((String)validFrequencyBase.getFrequencyCode(), (String)this.getFrequencyCode())) continue;
            uniqueRelevantFrequencyBaseCodes.add(validFrequencyBase.getFrequencyBaseCode());
        }
        return uniqueRelevantFrequencyBaseCodes;
    }

    protected List<KeyValue> getKeyValues(Set<String> uniqueValidFrequencyBases) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        ValidFrequencyBase validFrequencyBase = new ValidFrequencyBase();
        for (String frequencyBaseCode : uniqueValidFrequencyBases) {
            validFrequencyBase.setFrequencyBaseCode(frequencyBaseCode);
            validFrequencyBase.refreshReferenceObject("frequencyBase");
            if (!validFrequencyBase.getFrequencyBase().isActive()) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(validFrequencyBase.getFrequencyBaseCode(), validFrequencyBase.getFrequencyBase().getDescription()));
        }
        Collections.sort(keyValues, new FrequenceBaseComparator());
        keyValues.add(0, (KeyValue)new ConcreteKeyValue("", "select"));
        GlobalVariables.getUserSession().addObject("awfreqbase" + this.getFrequencyCode(), keyValues);
        return keyValues;
    }

    class FrequenceBaseComparator
    implements Comparator {
        FrequenceBaseComparator() {
        }

        public int compare(Object kv1, Object kv2) {
            try {
                String desc1 = ((KeyValue)kv1).getValue();
                String desc2 = ((KeyValue)kv2).getValue();
                if (desc1 == null) {
                    desc1 = "";
                }
                if (desc2 == null) {
                    desc2 = "";
                }
                return desc1.compareTo(desc2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

