/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.ValidBasisMethodPayment;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardPaymentAndInvoicesService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;

public class ValidMethodOfPaymentValuesFinder
extends KeyValuesBase {
    private String basisOfPaymentCode;
    private KeyValuesService keyValuesService;
    private AwardPaymentAndInvoicesService awardPaymentAndInvoicesService;

    public ValidMethodOfPaymentValuesFinder() {
    }

    public ValidMethodOfPaymentValuesFinder(String basisOfPaymentCode) {
        this.basisOfPaymentCode = basisOfPaymentCode;
    }

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyLabels = new ArrayList<KeyValue>();
        keyLabels.add((KeyValue)new ConcreteKeyValue("", "select"));
        if (StringUtils.isNotBlank((String)this.basisOfPaymentCode)) {
            for (ValidBasisMethodPayment basisMethodPayment : this.getAwardPaymentAndInvoicesService().getValidBasisMethodPaymentByBasisCode(this.basisOfPaymentCode)) {
                basisMethodPayment.refresh();
                keyLabels.add((KeyValue)new ConcreteKeyValue(basisMethodPayment.getMethodOfPaymentCode(), basisMethodPayment.getMethodOfPayment().getDescription()));
            }
        }
        return keyLabels;
    }

    private AwardPaymentAndInvoicesService getAwardPaymentAndInvoicesService() {
        if (this.awardPaymentAndInvoicesService == null) {
            this.awardPaymentAndInvoicesService = KraServiceLocator.getService(AwardPaymentAndInvoicesService.class);
        }
        return this.awardPaymentAndInvoicesService;
    }

    protected KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = (KeyValuesService)KraServiceLocator.getService("keyValuesService");
        }
        return this.keyValuesService;
    }

    public String getBasisOfPaymentCode() {
        return this.basisOfPaymentCode;
    }

    public void setBasisOfPaymentCode(String basisOfPaymentCode) {
        this.basisOfPaymentCode = basisOfPaymentCode;
    }
}

