/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.notesandattachments.attachments;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachment;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardAttachmentFormBean
implements Serializable {
    private static final long serialVersionUID = 4184903707661244083L;
    private final AwardForm form;
    private AwardAttachment newAttachment;

    public AwardAttachmentFormBean(AwardForm form) {
        this.form = form;
    }

    public AwardAttachment getNewAttachment() {
        if (this.newAttachment == null) {
            this.initAttachment();
        }
        return this.newAttachment;
    }

    private void initAttachment() {
        this.setNewAttachment(new AwardAttachment(this.getAward()));
    }

    public void setNewAttachment(AwardAttachment newAttachment) {
        this.newAttachment = newAttachment;
    }

    public AwardForm getForm() {
        return this.form;
    }

    public Award getAward() {
        if (this.form.getAwardDocument() == null) {
            throw new IllegalArgumentException("the document is null");
        }
        if (this.form.getAwardDocument().getAward() == null) {
            throw new IllegalArgumentException("the award is null");
        }
        return this.form.getAwardDocument().getAward();
    }

    void processSave() {
        this.refreshAttachmentReferences(this.getAward().getAwardAttachments());
        this.syncNewFiles(this.getAward().getAwardAttachments());
    }

    public void addNewAwardAttachment() {
        this.refreshAttachmentReferences(Collections.singletonList(this.getNewAttachment()));
        this.syncNewFiles(Collections.singletonList(this.getNewAttachment()));
        this.assignDocumentId(Collections.singletonList(this.getNewAttachment()), this.createTypeToMaxDocNumber(this.getAward().getAwardAttachments()));
        this.newAttachment.setAwardId(this.getAward().getAwardId());
        this.getAward().addAttachment(this.newAttachment);
        this.getBusinessObjectService().save((PersistableBusinessObject)this.newAttachment);
        this.initNewAttachment();
    }

    public AwardAttachment retrieveExistingAttachment(int attachmentNumber) {
        if (!AwardAttachmentFormBean.validIndexForList(attachmentNumber, this.getAward().getAwardAttachments())) {
            return null;
        }
        return this.getAward().getAwardAttachments().get(attachmentNumber);
    }

    private static boolean validIndexForList(int index, List<?> forList) {
        return forList != null && index >= 0 && index <= forList.size() - 1;
    }

    private void initNewAttachment() {
        this.setNewAttachment(new AwardAttachment(this.getAward()));
    }

    private Map<String, Integer> createTypeToMaxDocNumber(List<AwardAttachment> attachments) {
        HashMap<String, Integer> typeToDocNumber = new HashMap<String, Integer>();
        for (AwardAttachment attachment : attachments) {
            Integer curMax = (Integer)typeToDocNumber.get(attachment.getTypeCode());
            if (curMax != null && curMax >= attachment.getDocumentId()) continue;
            typeToDocNumber.put(attachment.getTypeCode(), attachment.getDocumentId());
        }
        return typeToDocNumber;
    }

    private void assignDocumentId(List<AwardAttachment> attachments, Map<String, Integer> typeToDocNumber) {
        for (AwardAttachment attachment : attachments) {
            if (!attachment.isNew()) continue;
            Integer nextDocNumber = AwardAttachmentFormBean.createNextDocNumber(typeToDocNumber.get(attachment.getTypeCode()));
            attachment.setDocumentId(nextDocNumber);
        }
    }

    private static Integer createNextDocNumber(Integer docNumber) {
        return docNumber == null ? NumberUtils.INTEGER_ONE : Integer.valueOf(docNumber + 1);
    }

    private void refreshAttachmentReferences(List<AwardAttachment> attachments) {
        assert (attachments != null) : "the attachments was null";
        for (AwardAttachment attachment : attachments) {
            attachment.refreshReferenceObject("type");
        }
    }

    private void syncNewFiles(List<AwardAttachment> attachments) {
        assert (attachments != null) : "the attachments was null";
        for (AwardAttachment attachment : attachments) {
            if (!AwardAttachmentFormBean.doesNewFileExist(attachment)) continue;
            AttachmentFile newFile = AttachmentFile.createFromFormFile(attachment.getNewFile());
            if (attachment.getFile() != null) {
                newFile.setSequenceNumber(attachment.getFile().getSequenceNumber());
            }
            attachment.setFile(newFile);
        }
    }

    private static boolean doesNewFileExist(AwardAttachment attachment) {
        return attachment.getNewFile() != null && StringUtils.isNotBlank((String)attachment.getNewFile().getFileName());
    }

    private BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }
}

