/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.notification;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.notification.AwardNotificationRenderer;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;

public class AwardReportTrackingNotificationRenderer
extends AwardNotificationRenderer {
    private static final long serialVersionUID = -2035058699415467934L;
    private static final String START_REPEAT_SECTION = "{BEGIN_REPEAT_SECTION}";
    private static final String END_REPEAT_SECTION = "{END_REPEAT_SECTION}";
    private List<ReportTracking> reports;

    public AwardReportTrackingNotificationRenderer() {
    }

    public AwardReportTrackingNotificationRenderer(List<ReportTracking> reports) {
        this.reports = reports;
    }

    protected Map<String, String> getReportReplacementParameters(ReportTracking report) {
        Map<String, String> result = this.getAwardReplacementParameters(report.getAward());
        SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy");
        if (report.getReport() == null) {
            report.refreshReferenceObject("report");
        }
        result.put("{REPORT_TYPE}", report.getReport().getDescription());
        result.put("{REPORT_DUE_DATE}", dateFormatter.format(report.getDueDate()));
        result.put(START_REPEAT_SECTION, "");
        result.put(END_REPEAT_SECTION, "");
        return result;
    }

    @Override
    public String render(String text) {
        int startIndex = StringUtils.indexOf((String)text, (String)START_REPEAT_SECTION);
        int endIndex = StringUtils.indexOf((String)text, (String)END_REPEAT_SECTION) + END_REPEAT_SECTION.length();
        String startStr = text.substring(0, startIndex);
        String repeatedStr = text.substring(startIndex, endIndex);
        String endStr = text.substring(endIndex);
        StringBuffer buffer = new StringBuffer();
        buffer.append(startStr);
        for (ReportTracking report : this.reports) {
            buffer.append(this.render(repeatedStr, this.getReportReplacementParameters(report)));
        }
        buffer.append(endStr);
        return buffer.toString();
    }

    public List<ReportTracking> getReports() {
        return this.reports;
    }

    public void setReports(List<ReportTracking> reports) {
        this.reports = reports;
    }
}

