/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.paymentreports.awardreports.AddAwardReportTermRecipientRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipientRule;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipientRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.MultipleSponsorContactsException;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardReportTermRecipientRuleImpl
extends ResearchDocumentRuleBase
implements AwardReportTermRecipientRule {
    private static final String AWARD_REPORT_TERM_RECIPIENT_CONTACT_ID_PROPERTY = "contactId";
    private static final String AWARD_REPORT_TERM_RECIPIENT_RELODEX_ID_PROPERTY = "rolodexId";
    private static final String CONTACT_ERROR_PARM = "Contact Type (Contact)";
    private static final String ORGANIZATION_ERROR_PARM = "Name/Organization (Organization)";

    @Override
    public boolean processAwardReportTermRecipientBusinessRules(AwardReportTermRecipientRuleEvent event) {
        return this.processCommonValidations(event);
    }

    @Override
    public boolean processAddAwardReportTermRecipientBusinessRules(AddAwardReportTermRecipientRuleEvent event) {
        AwardReportTermRecipient awardReportTermRecipientItemForValidation = event.getAwardReportTermRecipientItemForValidation();
        return this.areRequiredFieldsComplete(awardReportTermRecipientItemForValidation) && this.processCommonValidations(event) && this.validateContactAndOrganizationAreBothNotSelected(awardReportTermRecipientItemForValidation);
    }

    private boolean processCommonValidations(AwardReportTermRecipientRuleEvent event) {
        AwardReportTermRecipient awardReportTermRecipientItem = event.getAwardReportTermRecipientItemForValidation();
        List<AwardReportTermRecipient> items = event.getParentAwardReportTerm().getAwardReportTermRecipients();
        return this.isUnique(items, awardReportTermRecipientItem);
    }

    protected boolean isUnique(List<AwardReportTermRecipient> awardReportTermRecipientItems, AwardReportTermRecipient awardReportTermRecipientItem) {
        boolean duplicateFound = false;
        ArrayList<String> contactRecipients = new ArrayList<String>();
        ArrayList<String> rolodexRecipients = new ArrayList<String>();
        ArrayList<String> rolodexRecipientsWithNullContactId = new ArrayList<String>();
        for (AwardReportTermRecipient listItem : awardReportTermRecipientItems) {
            if (listItem == null) continue;
            if (listItem.getContactId() == null && listItem.getRolodex() != null && !rolodexRecipientsWithNullContactId.contains(listItem.getRolodexId())) {
                rolodexRecipientsWithNullContactId.add(listItem.getRolodexId().toString());
            }
            if (!(duplicateFound = listItem.getContactId() != null ? this.checkStringInList(listItem.getContactId().toString(), contactRecipients) : this.checkStringInList(listItem.getRolodexId().toString(), rolodexRecipients))) continue;
            break;
        }
        if (!duplicateFound && awardReportTermRecipientItem != null) {
            Integer rolodexId;
            if (awardReportTermRecipientItem.getContactId() != null && !contactRecipients.isEmpty()) {
                duplicateFound = this.checkStringInList(awardReportTermRecipientItem.getContactId().toString(), contactRecipients);
                if (!duplicateFound && (rolodexId = this.getRolodexIdFromContactId(awardReportTermRecipientItem.getContactId())) != null) {
                    duplicateFound = this.checkStringInList(rolodexId.toString(), rolodexRecipientsWithNullContactId);
                }
            } else if (awardReportTermRecipientItem.getRolodexId() != null) {
                duplicateFound = this.checkStringInList(awardReportTermRecipientItem.getRolodexId().toString(), rolodexRecipients);
            } else if (awardReportTermRecipientItem.getContactId() != null && (rolodexId = this.getRolodexIdFromContactId(awardReportTermRecipientItem.getContactId())) != null) {
                duplicateFound = this.checkStringInList(rolodexId.toString(), rolodexRecipients);
            }
        }
        if (duplicateFound && !this.hasDuplicateErrorBeenReported()) {
            this.reportError("AwardReportTermRecipient", "error.awardReportTermRecipientItem.notunique", new String[0]);
        }
        return !duplicateFound;
    }

    private boolean checkStringInList(String receipient, ArrayList<String> recipientList) {
        boolean exists = false;
        if (recipientList.contains(receipient)) {
            exists = true;
        } else {
            recipientList.add(receipient);
        }
        return exists;
    }

    boolean areRequiredFieldsComplete(AwardReportTermRecipient awardReportTermRecipientItem) {
        boolean itemValid;
        boolean bl = itemValid = awardReportTermRecipientItem.getContactId() != null || awardReportTermRecipientItem.getRolodexId() != null;
        if (!itemValid) {
            this.reportError(AWARD_REPORT_TERM_RECIPIENT_RELODEX_ID_PROPERTY, "error.organizasion.required", new String[0]);
        }
        return itemValid;
    }

    boolean validateContactAndOrganizationAreBothNotSelected(AwardReportTermRecipient awardReportTermRecipientItemForValidation) {
        boolean itemValid;
        boolean bl = itemValid = awardReportTermRecipientItemForValidation.getContactId() == null || awardReportTermRecipientItemForValidation.getRolodexId() == null;
        if (!itemValid) {
            this.reportError(AWARD_REPORT_TERM_RECIPIENT_CONTACT_ID_PROPERTY, "error.both.sponsor.and.rolodex.are.selected", CONTACT_ERROR_PARM, ORGANIZATION_ERROR_PARM);
        }
        return itemValid;
    }

    private boolean hasDuplicateErrorBeenReported() {
        return GlobalVariables.getMessageMap().containsMessageKey("error.awardReportTermRecipientItem.notunique");
    }

    private Integer getRolodexIdFromContactId(Long contactId) {
        Collection<AwardSponsorContact> awardSponsorContacts = this.getSponsorContactsUsingKeyValuesService(contactId);
        Integer rolodexId = null;
        if (awardSponsorContacts.size() > 1) {
            throw new MultipleSponsorContactsException(awardSponsorContacts.size());
        }
        for (AwardSponsorContact awardSponsorContact : awardSponsorContacts) {
            rolodexId = awardSponsorContact.getRolodexId();
        }
        return rolodexId;
    }

    private Collection<AwardSponsorContact> getSponsorContactsUsingKeyValuesService(Long contactId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("awardContactId", contactId);
        return this.getKeyValuesService().findMatching(AwardSponsorContact.class, map);
    }

    protected KeyValuesService getKeyValuesService() {
        return KraServiceLocator.getService(KeyValuesService.class);
    }
}

