/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.lookup.keyvalue.FrequencyBaseCodeValuesFinder;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.awardreports.AddAwardReportTermRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRule;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.GenericAwardReportTerm;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardReportTermRuleImpl
extends ResearchDocumentRuleBase
implements AwardReportTermRule {
    private static final String AWARD_REPORT_TERM_REPORT_CODE_PROPERTY = "reportCode";
    private static final String AWARD_REPORT_TERM_FREQUENCY_CODE_PROPERTY = "frequencyCode";
    private static final String AWARD_REPORT_TERM_FREQUENCY_BASE_CODE_PROPERTY = "frequencyBaseCode";
    private static final String AWARD_REPORT_TERM_DISTRIBUTION_PROPERTY = "ospDistributionCode";
    private static final String AWARD_REPORT_TERM_DUE_DATE_PROPERTY = "dueDate";
    private static final String REPORT_CODE_ERROR_PARM = "Type (Type)";
    private static final String FREQUENCY_CODE_ERROR_PARM = "Frequency (Frequency)";
    private static final String FREQUENCY_BASE_CODE_ERROR_PARM = "Frequency Base (Frequency Base)";
    private static final String DISTRIBUTION_ERROR_PARM = "OSP File Copy  (OSP File Copy )";
    private static final String DUE_DATE_ERROR_PARM = "Due Date (Due Date)";
    private static final String EMPTY_CODE = "-1";
    private static final String FINAL_REPORT_DESCRIPTION = "Final (Final Report)";

    @Override
    public boolean processAwardReportTermBusinessRules(AwardReportTermRuleEvent event) {
        boolean validFields = true;
        String fieldStarter = "document.awardList[0].awardReportTermItems[";
        String fieldEnder = "].";
        int counter = 0;
        for (AwardReportTerm awardReportTermItem : event.getAward().getAwardReportTermItems()) {
            validFields = this.validateRequiredFields(awardReportTermItem, fieldStarter + counter + fieldEnder) && this.isUnique(event.getAward().getAwardReportTermItems(), awardReportTermItem) && validFields;
            ++counter;
        }
        return validFields;
    }

    @Override
    public boolean processAddAwardReportTermBusinessRules(AddAwardReportTermRuleEvent event) {
        AwardReportTerm awardReportTermItem = event.getAwardReportTermItemForValidation();
        List<AwardReportTerm> items = event.getAward().getAwardReportTermItems();
        return this.validatePI(event.getAward()) && this.validateRequiredFields(event.getAwardReportTermItemForValidation(), "") && this.isUnique(items, awardReportTermItem);
    }

    private boolean validatePI(Award award) {
        boolean retVal = true;
        if (award.getPrincipalInvestigator() == null) {
            this.reportWarning(AWARD_REPORT_TERM_REPORT_CODE_PROPERTY, "error.awardReportTermItem.noPI", "");
        }
        return retVal;
    }

    protected boolean isUnique(List<? extends GenericAwardReportTerm> awardReportTermItems, GenericAwardReportTerm awardReportTermItem) {
        GenericAwardReportTerm listItem;
        boolean duplicateFound = false;
        Iterator<? extends GenericAwardReportTerm> i$ = awardReportTermItems.iterator();
        while (i$.hasNext() && !(duplicateFound = awardReportTermItem != (listItem = i$.next()) && listItem.equalsInitialFields(awardReportTermItem))) {
        }
        if (duplicateFound && !GlobalVariables.getMessageMap().containsMessageKey("error.awardReportTermItem.notunique")) {
            this.reportError("awardReportTerm", "error.awardReportTermItem.notunique", new String[0]);
        }
        return !duplicateFound;
    }

    protected boolean validateRequiredFields(GenericAwardReportTerm awardReportTermItem, String fieldPrePend) {
        FrequencyBaseCodeValuesFinder finder;
        boolean retVal = true;
        if (StringUtils.isBlank((String)awardReportTermItem.getReportCode())) {
            retVal = false;
            this.reportError(fieldPrePend + AWARD_REPORT_TERM_REPORT_CODE_PROPERTY, "error.required", REPORT_CODE_ERROR_PARM);
        }
        if (StringUtils.isBlank((String)awardReportTermItem.getFrequencyCode()) && !StringUtils.isBlank((String)awardReportTermItem.getOspDistributionCode())) {
            retVal = false;
            this.reportError(fieldPrePend + AWARD_REPORT_TERM_FREQUENCY_CODE_PROPERTY, "error.awardReportTermItem.frequencyRequired", new String[0]);
        }
        if (StringUtils.isBlank((String)awardReportTermItem.getFrequencyBaseCode()) && (finder = new FrequencyBaseCodeValuesFinder(awardReportTermItem.getFrequencyCode())).getKeyValues().size() > 1) {
            retVal = false;
            this.reportError(fieldPrePend + AWARD_REPORT_TERM_FREQUENCY_BASE_CODE_PROPERTY, "error.required", FREQUENCY_BASE_CODE_ERROR_PARM);
        }
        if (StringUtils.isBlank((String)awardReportTermItem.getOspDistributionCode()) && this.isFinalReport(awardReportTermItem.getReportCode()) && StringUtils.isNotBlank((String)awardReportTermItem.getFrequencyCode())) {
            this.reportError(fieldPrePend + AWARD_REPORT_TERM_DISTRIBUTION_PROPERTY, "error.awardReportTermItem.ospRequired", new String[0]);
            retVal = false;
        }
        return retVal;
    }

    private boolean isFinalReport(String reportCode) {
        boolean retVal = false;
        if (StringUtils.isNotBlank((String)reportCode)) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("REPORT_CODE", reportCode);
            Report report = (Report)((Object)this.getBusinessObjectService().findMatching(Report.class, fieldValues).iterator().next());
            retVal = report.getFinalReportFlag();
        }
        return retVal;
    }

    public boolean processAwardReportTermBusinessRules(GenericAwardReportTerm awardReportTerm, List<? extends GenericAwardReportTerm> existingItems) {
        return this.validateRequiredFields(awardReportTerm, "") && this.isUnique(existingItems, awardReportTerm);
    }
}

