/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.Distribution;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.FrequencyBase;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.paymentreports.ReportRegenerationType;
import org.kuali.kra.award.paymentreports.ReportStatus;
import org.kuali.kra.bo.Contactable;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ReportTracking
extends KraPersistableBusinessObjectBase
implements Comparable<ReportTracking> {
    private static final long serialVersionUID = -7660491024739306314L;
    private Long awardReportTermId;
    private String awardNumber;
    private String piPersonId;
    private Integer piRolodexId;
    private String piName;
    private String leadUnitNumber;
    private String reportClassCode;
    private String reportCode;
    private String frequencyCode;
    private String frequencyBaseCode;
    private String ospDistributionCode;
    private String statusCode;
    private Date baseDate;
    private Date dueDate;
    private Integer overdue;
    private Date activityDate;
    private String comments;
    private String preparerId;
    private String preparerName;
    private String sponsorCode;
    private String sponsorAwardNumber;
    private String title;
    private String lastUpdateUser;
    private Timestamp lastUpdateDate;
    private ReportClass reportClass;
    private Report report;
    private Frequency frequency;
    private FrequencyBase frequencyBase;
    private ReportStatus reportStatus;
    private Distribution distribution;
    private Unit leadUnit;
    private Sponsor sponsor;
    private transient KcPerson piPerson;
    private transient Rolodex piRolodex;
    private transient KcPerson preparer;
    private transient int itemCount;
    private transient KcPersonService kcPersonService;
    private transient Award award;
    private transient BusinessObjectService businessObjectService;
    private boolean multiEditSelected;

    public Long getAwardReportTermId() {
        return this.awardReportTermId;
    }

    public void setAwardReportTermId(Long awardReportTermId) {
        this.awardReportTermId = awardReportTermId;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public String getPiName() {
        return this.piName;
    }

    public void setPiName(String piName) {
        this.piName = piName;
    }

    public String getLeadUnitNumber() {
        return this.leadUnitNumber;
    }

    public void setLeadUnitNumber(String leadUnitNumber) {
        this.leadUnitNumber = leadUnitNumber;
    }

    public String getReportClassCode() {
        return this.reportClassCode;
    }

    public void setReportClassCode(String reportClassCode) {
        this.reportClassCode = reportClassCode;
    }

    public String getReportCode() {
        return this.reportCode;
    }

    public void setReportCode(String reportCode) {
        this.reportCode = reportCode;
    }

    public String getFrequencyCode() {
        return this.frequencyCode;
    }

    public void setFrequencyCode(String frequencyCode) {
        this.frequencyCode = frequencyCode;
    }

    public String getFrequencyBaseCode() {
        return this.frequencyBaseCode;
    }

    public void setFrequencyBaseCode(String frequencyBaseCode) {
        this.frequencyBaseCode = frequencyBaseCode;
    }

    public Date getBaseDate() {
        return this.baseDate;
    }

    public void setBaseDate(Date baseDate) {
        this.baseDate = baseDate;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getOspDistributionCode() {
        return this.ospDistributionCode;
    }

    public void setOspDistributionCode(String ospDistributionCode) {
        this.ospDistributionCode = ospDistributionCode;
    }

    public Integer getOverdue() {
        return this.overdue;
    }

    public void setOverdue(Integer overdue) {
        this.overdue = overdue;
    }

    public Date getActivityDate() {
        return this.activityDate;
    }

    public void setActivityDate(Date activityDate) {
        this.activityDate = activityDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getPreparerId() {
        return this.preparerId;
    }

    public void setPreparerId(String preparerId) {
        this.preparerId = preparerId;
    }

    public String getSponsorCode() {
        return this.sponsorCode;
    }

    public void setSponsorCode(String sponsorCode) {
        this.sponsorCode = sponsorCode;
    }

    public String getSponsorAwardNumber() {
        return this.sponsorAwardNumber;
    }

    public void setSponsorAwardNumber(String sponsorAwardNumber) {
        this.sponsorAwardNumber = sponsorAwardNumber;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

    public Timestamp getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Timestamp lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public ReportClass getReportClass() {
        return this.reportClass;
    }

    public void setReportClass(ReportClass reportClass) {
        this.reportClass = reportClass;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Frequency frequency) {
        this.frequency = frequency;
    }

    public FrequencyBase getFrequencyBase() {
        return this.frequencyBase;
    }

    public void setFrequencyBase(FrequencyBase frequencyBase) {
        this.frequencyBase = frequencyBase;
    }

    public ReportStatus getReportStatus() {
        return this.reportStatus;
    }

    public void setReportStatus(ReportStatus reportStatus) {
        this.reportStatus = reportStatus;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
    }

    public Sponsor getSponsor() {
        return this.sponsor;
    }

    public void setSponsor(Sponsor sponsor) {
        this.sponsor = sponsor;
    }

    @Override
    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public String getPiPersonId() {
        return this.piPersonId;
    }

    public void setPiPersonId(String piPersonId) {
        this.piPersonId = piPersonId;
    }

    public Integer getPiRolodexId() {
        return this.piRolodexId;
    }

    public void setPiRolodexId(Integer piRolodexId) {
        this.piRolodexId = piRolodexId;
    }

    public String getPreparerName() {
        return this.preparerName;
    }

    public void setPreparerName(String preparerName) {
        this.preparerName = preparerName;
    }

    public KcPerson getPiPerson() {
        if (this.piPerson == null && StringUtils.isNotBlank((String)this.getPiPersonId())) {
            this.piPerson = this.getKcPersonService().getKcPersonByPersonId(this.getPiPersonId());
        }
        return this.piPerson;
    }

    public Rolodex getPiRolodex() {
        if (this.piRolodex == null && this.getPiRolodexId() != null) {
            this.piRolodex = (NonOrganizationalRolodex)this.getBusinessObjectService().findBySinglePrimaryKey(NonOrganizationalRolodex.class, (Object)this.getPiRolodexId());
        }
        return this.piRolodex;
    }

    public Contactable getPrimaryInvestigator() {
        if (this.getPiPerson() != null) {
            return this.getPiPerson();
        }
        if (this.getPiRolodex() != null) {
            return this.getPiRolodex();
        }
        return null;
    }

    public KcPerson getPreparer() {
        if (this.preparer == null && StringUtils.isNotBlank((String)this.getPreparerId())) {
            this.preparer = this.getKcPersonService().getKcPersonByPersonId(this.getPreparerId());
        }
        return this.preparer;
    }

    public String getPreparerFullname() {
        return this.getPreparer() != null ? this.getPreparer().getFullName() : "";
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setPreparer(KcPerson preparer) {
        this.preparer = preparer;
        if (preparer != null) {
            this.preparerId = preparer.getPersonId();
            this.preparerName = preparer.getFullName();
        } else {
            this.preparerId = null;
            this.preparerName = null;
        }
    }

    public Unit getLeadUnit() {
        return this.leadUnit;
    }

    public void setLeadUnit(Unit leadUnit) {
        this.leadUnit = leadUnit;
    }

    public boolean getMultiEditSelected() {
        return this.multiEditSelected;
    }

    public void setMultiEditSelected(boolean multiEditSelected) {
        this.multiEditSelected = multiEditSelected;
    }

    @Override
    public int compareTo(ReportTracking o) {
        return o == null || o.getDueDate() == null || this.getDueDate() == null ? 0 : this.getDueDate().compareTo(o.getDueDate());
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public boolean hasBeenUpdated(ReportTracking dbReportTracking) {
        boolean retVal = false;
        if (dbReportTracking != null) {
            if (!StringUtils.equalsIgnoreCase((String)this.getPreparerId(), (String)dbReportTracking.getPreparerId())) {
                retVal = true;
            } else if (!StringUtils.equalsIgnoreCase((String)this.getStatusCode(), (String)dbReportTracking.getStatusCode())) {
                retVal = true;
            } else if (!StringUtils.equalsIgnoreCase((String)this.getComments(), (String)dbReportTracking.getComments())) {
                retVal = true;
            } else if (!this.dateEquals(this.activityDate, dbReportTracking.activityDate)) {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean dateEquals(Date date1, Date date2) {
        boolean retVal = false;
        if (date1 == null && date2 == null) {
            retVal = true;
        } else if (date1 != null && date2 != null && date1.equals(date2)) {
            return true;
        }
        return retVal;
    }

    public boolean getDisplayDeleteButton() {
        boolean retVal = false;
        if (StringUtils.equals((String)"1", (String)this.getStatusCode()) && this.getFrequencyBase() != null && StringUtils.equals((String)ReportRegenerationType.ADDONLY.getDescription(), (String)this.getFrequencyBase().getReportRegenerationType().getDescription())) {
            retVal = true;
        }
        return retVal;
    }

    public Award getAward() {
        return this.award;
    }

    public void setAward(Award award) {
        this.award = award;
    }
}

