/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import noNamespace.AwardReportingRequirementDocument;
import noNamespace.ReportingRequirement;
import noNamespace.ReportingRequirementDetail;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingDao;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.xmlstream.XmlStream;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ReportTrackingXmlStream
implements XmlStream {
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private static final Log LOG = LogFactory.getLog(ReportTrackingXmlStream.class);

    @Override
    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        ReportTracking reporTracking = (ReportTracking)printableBusinessObject;
        AwardReportingRequirementDocument awardReportRequirementDoc = AwardReportingRequirementDocument.Factory.newInstance();
        try {
            awardReportRequirementDoc.setAwardReportingRequirement(this.getAwardReporting(reporTracking, reportParameters));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        LinkedHashMap xmlObjectList = new LinkedHashMap();
        HashMap<String, XmlObject> map = new HashMap<String, XmlObject>();
        map.put("AwardReportTracking", (XmlObject)awardReportRequirementDoc);
        return map;
    }

    public AwardReportingRequirementDocument.AwardReportingRequirement getAwardReporting(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> htData) throws Exception {
        ReportTracking reportTracking = (ReportTracking)printableBusinessObject;
        AwardReportingRequirementDocument.AwardReportingRequirement awardReporting = AwardReportingRequirementDocument.AwardReportingRequirement.Factory.newInstance();
        HashMap<String, String> searchValues = new HashMap<String, String>();
        if (reportTracking.getPiName() != null) {
            searchValues.put("piName", reportTracking.getPiName());
        }
        if (reportTracking.getFrequencyBaseCode() != null) {
            searchValues.put("frequencyBaseCode", reportTracking.getFrequencyBaseCode());
        }
        if (reportTracking.getFrequencyCode() != null) {
            searchValues.put("frequencyCode", reportTracking.getFrequencyCode());
        }
        if (reportTracking.getReportClassCode() != null) {
            searchValues.put("reportClassCode", reportTracking.getReportClassCode());
        }
        if (reportTracking.getReportCode() != null) {
            searchValues.put("reportCode", reportTracking.getReportCode());
        }
        if (reportTracking.getBaseDate() != null) {
            searchValues.put("baseDate", this.getDateTimeService().toDateString((Date)reportTracking.getBaseDate()));
        }
        if (reportTracking.getSponsorCode() != null) {
            searchValues.put("sponsorCode", reportTracking.getSponsorCode());
        }
        if (reportTracking.getOverdue() != null) {
            searchValues.put("overdue", reportTracking.getOverdue().toString());
        }
        if (reportTracking.getPreparerName() != null) {
            searchValues.put("preparerName", reportTracking.getPreparerName());
        }
        if (reportTracking.getActivityDate() != null) {
            searchValues.put("activityDate", this.getDateTimeService().toDateString((Date)reportTracking.getActivityDate()));
        }
        if (reportTracking.getLeadUnitNumber() != null) {
            searchValues.put("leadUnitNumber", reportTracking.getLeadUnitNumber());
        }
        if (reportTracking.getDueDate() != null) {
            searchValues.put("dueDate", this.getDateTimeService().toDateString((Date)reportTracking.getDueDate()));
        }
        if (reportTracking.getComments() != null) {
            searchValues.put("comments", reportTracking.getComments());
        }
        ArrayList<String> detailFields = new ArrayList<String>();
        detailFields.add("awardNumber");
        detailFields.add("leadUnitNumber");
        List<ReportTracking> detailResults = KraServiceLocator.getService(ReportTrackingDao.class).getDetailResults(searchValues, detailFields);
        this.setReportingRequirements(awardReporting, reportTracking, detailResults);
        return awardReporting;
    }

    private void setReportingRequirements(AwardReportingRequirementDocument.AwardReportingRequirement awardReporting, ReportTracking reportTracking, List<ReportTracking> detailResults) {
        ArrayList<ReportingRequirement> reportReqList = new ArrayList<ReportingRequirement>();
        ReportingRequirement reportingRequirement = ReportingRequirement.Factory.newInstance();
        reportingRequirement.setPrincipleInvestigatorName(reportTracking.getPiName());
        reportingRequirement.setReportClass(reportTracking.getReportClass().getDescription());
        reportingRequirement.setFrequency(reportTracking.getFrequency().getDescription());
        reportingRequirement.setFrequencyBase(reportTracking.getFrequencyBase().getDescription());
        if (reportTracking.getBaseDate() != null) {
            reportingRequirement.setBaseDate(reportTracking.getBaseDate().toString());
        }
        reportingRequirement.setCopyOSP(reportTracking.getOspDistributionCode());
        this.setReportingRequirementsDetail(awardReporting, reportingRequirement, detailResults);
        reportReqList.add(reportingRequirement);
        awardReporting.setReportingReqsArray(reportReqList.toArray(new ReportingRequirement[0]));
    }

    private void setReportingRequirementsDetail(AwardReportingRequirementDocument.AwardReportingRequirement awardReporting, ReportingRequirement reportingRequirement, List<ReportTracking> detailResults) {
        ArrayList<ReportingRequirementDetail> reportReqDetailList = new ArrayList<ReportingRequirementDetail>();
        for (ReportTracking reportTracking : detailResults) {
            ReportingRequirementDetail reportReqDetails = ReportingRequirementDetail.Factory.newInstance();
            reportReqDetails.setAwardNo(reportTracking.getAwardNumber());
            if (reportTracking.getLeadUnit() != null) {
                reportReqDetails.setUnitNo(reportTracking.getLeadUnit().getUnitNumber());
                reportReqDetails.setUnitName(reportTracking.getLeadUnit().getUnitName());
            }
            reportReqDetails.setStatus(reportTracking.getStatusCode());
            if (reportTracking.getDueDate() != null) {
                reportReqDetails.setDueDate(reportTracking.getDueDate().toString());
            }
            reportReqDetails.setCopies(reportTracking.getItemCount());
            if (reportTracking.getOverdue() != null) {
                reportReqDetails.setOverdueNo(reportTracking.getOverdue().intValue());
            }
            if (reportTracking.getActivityDate() != null) {
                reportTracking.getActivityDate().toString();
            }
            if (reportTracking.getComments() != null) {
                reportReqDetails.setComments(reportTracking.getComments());
            }
            if (reportTracking.getPreparerName() != null) {
                reportReqDetails.setPersonName(reportTracking.getPreparerName());
            }
            reportReqDetailList.add(reportReqDetails);
        }
        if (!reportReqDetailList.isEmpty()) {
            reportingRequirement.setReportingReqDetailsArray(reportReqDetailList.toArray(new ReportingRequirementDetail[0]));
        }
    }

    @Override
    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Override
    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    @Override
    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

