/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.notification.AwardNotificationContext;
import org.kuali.kra.award.notification.AwardReportTrackingNotificationRenderer;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotification;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationDetails;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationService;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationTask;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.SentReportNotification;
import org.kuali.kra.common.notification.bo.NotificationType;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.ken.api.notification.NotificationRecipient;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ReportTrackingNotificationServiceImpl
implements ReportTrackingNotificationService {
    private static final Log LOG = LogFactory.getLog(ReportTrackingNotificationServiceImpl.class);
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private AwardService awardService;
    private KcNotificationService notificationService;
    private List<ReportTrackingNotification> notifications = new ArrayList<ReportTrackingNotification>();
    protected static final int ZERO = 0;

    @Override
    public List<ReportTrackingNotificationDetails> runReportTrackingNotifications() {
        ArrayList<ReportTrackingNotificationDetails> resultDetails = new ArrayList<ReportTrackingNotificationDetails>();
        AwardReportTrackingNotificationRenderer renderer = new AwardReportTrackingNotificationRenderer();
        for (ReportTrackingNotification notification : this.notifications) {
            ReportTrackingNotificationDetails details = new ReportTrackingNotificationDetails();
            details.setActionCode(notification.getActionCode());
            details.setNotificationName(notification.getName());
            resultDetails.add(details);
            try {
                NotificationType notificationType = this.notificationService.getNotificationType("1", notification.getActionCode());
                if (notificationType == null || !notificationType.isActive() || notificationType.getNotificationTypeRecipients() == null || notificationType.getNotificationTypeRecipients().isEmpty()) continue;
                details.setNotificationActive(true);
                details.setNotificationRecipients(notificationType.getNotificationTypeRecipients().size());
                int recordsFound = 0;
                int recordsMatched = 0;
                int notificationsSent = 0;
                Calendar checkFor = Calendar.getInstance();
                Calendar until = null;
                if (notification.isOverdue()) {
                    checkFor.add(5, (notification.getDays() + notification.getScope()) * -1);
                } else {
                    checkFor.add(5, notification.getDays() - notification.getScope());
                }
                until = (Calendar)checkFor.clone();
                until.add(5, notification.getScope());
                this.clearTimeFields(checkFor);
                this.clearTimeFields(until);
                HashMap<Award, ArrayList<ReportTracking>> matchedReports = new HashMap<Award, ArrayList<ReportTracking>>();
                TreeMap recipients = new TreeMap(new Comparator<NotificationRecipient.Builder>(){

                    @Override
                    public int compare(NotificationRecipient.Builder o1, NotificationRecipient.Builder o2) {
                        return o1.getRecipientId().compareTo(o2.getRecipientId());
                    }
                });
                for (ReportTrackingNotificationTask task : notification.getTasks()) {
                    List reports = (List)this.businessObjectService.findMatching(ReportTracking.class, task.getReportTrackingValueMap());
                    recordsFound += reports.size();
                    for (ReportTracking reportTracking : reports) {
                        if (reportTracking.getDueDate() == null || !this.doDatesMatch(reportTracking.getDueDate(), checkFor, until) || this.hasSentNotification(reportTracking, notification)) continue;
                        ++recordsMatched;
                        Award curAward = this.awardService.getActiveOrNewestAward(reportTracking.getAwardNumber());
                        reportTracking.setAward(curAward);
                        ArrayList<ReportTracking> curReports = (ArrayList<ReportTracking>)matchedReports.get(curAward);
                        if (curReports == null) {
                            curReports = new ArrayList<ReportTracking>();
                            matchedReports.put(curAward, curReports);
                        }
                        curReports.add(reportTracking);
                    }
                    for (Award award : matchedReports.keySet()) {
                        Set<NotificationRecipient.Builder> recips = this.notificationService.getNotificationRecipients(new AwardNotificationContext(award, notification.getActionCode(), notification.getName()));
                        for (NotificationRecipient.Builder recip : recips) {
                            ArrayList curReports = (ArrayList)recipients.get(recip);
                            if (curReports == null) {
                                curReports = new ArrayList();
                                recipients.put(recip, curReports);
                            }
                            curReports.addAll((Collection)matchedReports.get(award));
                        }
                    }
                    for (Map.Entry entry : recipients.entrySet()) {
                        renderer.setReports((List)entry.getValue());
                        String message = renderer.render(notificationType.getMessage());
                        this.notificationService.sendNotification(notification.getName(), notificationType.getSubject(), message, Collections.singleton(entry.getKey()));
                        ++notificationsSent;
                    }
                    ArrayList<SentReportNotification> sentReports = new ArrayList<SentReportNotification>();
                    for (Map.Entry entry : matchedReports.entrySet()) {
                        for (ReportTracking report : (List)entry.getValue()) {
                            sentReports.add(new SentReportNotification(notification.getActionCode(), report));
                        }
                    }
                    this.businessObjectService.save(sentReports);
                }
                details.setTrackingRecordsFound(recordsFound);
                details.setTrackingRecordsMatched(recordsMatched);
                details.setNotificationsSent(notificationsSent);
            }
            catch (Exception e) {
                LOG.error((Object)("Error sending report tracking notifications for " + notification.getActionCode()), (Throwable)e);
                details.setErrorMessage(e.getMessage());
            }
        }
        return resultDetails;
    }

    protected boolean doDatesMatch(Date date1, Calendar from, Calendar until) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        this.clearTimeFields(cal1);
        return cal1.after(from) && (cal1.equals(until) || cal1.before(until));
    }

    protected boolean hasSentNotification(ReportTracking report, ReportTrackingNotification notification) {
        List allSent = (List)this.getBusinessObjectService().findAll(SentReportNotification.class);
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (report.getAwardReportTermId() != null) {
            values.put("awardReportTermId", report.getAwardReportTermId());
        }
        values.put("awardNumber", report.getAwardNumber());
        values.put("dueDate", report.getDueDate());
        values.put("actionCode", notification.getActionCode());
        List notifications = (List)this.getBusinessObjectService().findMatching(SentReportNotification.class, values);
        return notifications != null && !notifications.isEmpty();
    }

    protected void clearTimeFields(Calendar date) {
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    protected KcNotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public List<ReportTrackingNotification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<ReportTrackingNotification> notifications) {
        this.notifications = notifications;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }
}

