/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.paymentschedule;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.paymentschedule.AddAwardPaymentScheduleRuleEvent;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardScheduleGenerationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;

public class PaymentScheduleBean
implements Serializable {
    private static final long serialVersionUID = -5513993757805685581L;
    private AwardPaymentSchedule newAwardPaymentSchedule;
    private transient KualiRuleService ruleService;
    private AwardForm form;

    public PaymentScheduleBean(AwardForm form) {
        this.form = form;
        this.init();
    }

    public boolean addPaymentScheduleItem() {
        AddAwardPaymentScheduleRuleEvent event = this.generateAddEvent();
        boolean success = this.getRuleService().applyRules((KualiDocumentEvent)event);
        if (success) {
            this.getAward().add(this.getNewAwardPaymentSchedule());
            this.init();
        }
        return success;
    }

    public void deletePaymentScheduleItem(int deletedItemIndex) {
        List<AwardPaymentSchedule> items = this.getAward().getPaymentScheduleItems();
        if (deletedItemIndex >= 0 && deletedItemIndex < items.size()) {
            items.remove(deletedItemIndex);
        }
    }

    public void generatePaymentSchedules() throws ParseException {
        List<Object> dates = new ArrayList();
        dates = this.getAwardScheduleGenerationService().generateSchedules(this.getAward(), this.getAward().getAwardReportTermItems(), false);
        for (Date date : dates) {
            this.newAwardPaymentSchedule = new AwardPaymentSchedule();
            java.sql.Date sqldate = new java.sql.Date(date.getTime());
            this.newAwardPaymentSchedule.setDueDate(sqldate);
            this.newAwardPaymentSchedule.setAmount(KualiDecimal.ZERO);
            this.getAward().add(this.newAwardPaymentSchedule);
        }
        this.init();
    }

    public Award getAward() {
        return this.form.getAwardDocument().getAward();
    }

    public AwardDocument getAwardDocument() {
        return this.form.getAwardDocument();
    }

    public Object getData() {
        return this.getNewAwardPaymentSchedule();
    }

    public void init() {
        this.newAwardPaymentSchedule = new AwardPaymentSchedule();
    }

    protected KualiRuleService getRuleService() {
        if (this.ruleService == null) {
            this.ruleService = KraServiceLocator.getService(KualiRuleService.class);
        }
        return this.ruleService;
    }

    protected void setRuleService(KualiRuleService ruleService) {
        this.ruleService = ruleService;
    }

    AddAwardPaymentScheduleRuleEvent generateAddEvent() {
        AddAwardPaymentScheduleRuleEvent event = new AddAwardPaymentScheduleRuleEvent("paymentScheduleBean.newAwardPaymentSchedule", this.getAwardDocument(), this.getAward(), this.getNewAwardPaymentSchedule());
        return event;
    }

    public AwardPaymentSchedule getNewAwardPaymentSchedule() {
        return this.newAwardPaymentSchedule;
    }

    public void setNewAwardPaymentSchedule(AwardPaymentSchedule newAwardPaymentSchedule) {
        this.newAwardPaymentSchedule = newAwardPaymentSchedule;
    }

    protected AwardScheduleGenerationService getAwardScheduleGenerationService() {
        return KraServiceLocator.getService(AwardScheduleGenerationService.class);
    }
}

