/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.foreigntravel;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.SpecialApprovalBean;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AddAwardApprovedForeignTravelRuleEvent;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.ApprovedForeignTravelerValuesFinder;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravelRuleImpl;
import org.kuali.kra.bo.Contactable;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.core.api.util.KeyValue;

public class ApprovedForeignTravelBean
extends SpecialApprovalBean {
    private static final long serialVersionUID = 8787570417382374201L;
    private AwardApprovedForeignTravel newApprovedForeignTravel;
    private transient KcPersonService kcPersonService;

    public ApprovedForeignTravelBean(AwardForm form) {
        super(form);
        this.init();
    }

    public boolean addApprovedForeignTravel() {
        AddAwardApprovedForeignTravelRuleEvent event = this.generateAddEvent();
        boolean success = new AwardApprovedForeignTravelRuleImpl().processAddAwardApprovedForeignTravelBusinessRules(event);
        if (success) {
            this.getAward().add(this.getNewApprovedForeignTravel());
            this.init();
        }
        return success;
    }

    public void deleteApprovedForeignTravelTrip(int deletedTripIndex) {
        this.removeCollectionItem(this.getAward().getApprovedForeignTravelTrips(), deletedTripIndex);
    }

    public Object getData() {
        return this.getNewApprovedForeignTravel();
    }

    public AwardApprovedForeignTravel getNewApprovedForeignTravel() {
        return this.newApprovedForeignTravel;
    }

    public String getSelectedTravelerId() {
        return this.newApprovedForeignTravel.getContactId().toString();
    }

    public void init() {
        this.newApprovedForeignTravel = new AwardApprovedForeignTravel();
    }

    public void refreshTravelers() {
        this.refreshTraveler(this.newApprovedForeignTravel);
        for (AwardApprovedForeignTravel trip : this.getAward().getApprovedForeignTravelTrips()) {
            this.refreshTraveler(trip);
        }
    }

    private void refreshTraveler(AwardApprovedForeignTravel trip) {
        String travelerId = trip.getPersonId();
        if (travelerId != null) {
            trip.setPersonTraveler(this.getKcPersonService().getKcPersonByPersonId(travelerId));
        }
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setNewAwardApprovedForeignTravel(AwardApprovedForeignTravel newAwardApprovedForeignTravel) {
        this.newApprovedForeignTravel = newAwardApprovedForeignTravel;
    }

    AddAwardApprovedForeignTravelRuleEvent generateAddEvent() {
        AddAwardApprovedForeignTravelRuleEvent event = new AddAwardApprovedForeignTravelRuleEvent("newAwardApprovedForeignTravel", this.getAwardDocument(), this.getAward(), this.getNewApprovedForeignTravel());
        return event;
    }

    public List<KeyValue> getKnownTravelers() {
        return new ApprovedForeignTravelerValuesFinder().getKeyValues();
    }

    public void setSelectedTravelerId(String travelerId) {
        if (StringUtils.isEmpty((String)travelerId)) {
            return;
        }
        boolean foundKeyPerson = false;
        for (AwardPerson pp : this.getAward().getProjectPersons()) {
            if (!pp.getContact().getIdentifier().toString().equals(travelerId)) continue;
            if (pp.isEmployee()) {
                this.newApprovedForeignTravel.setPersonTraveler(pp.getPerson());
                this.newApprovedForeignTravel.setPersonId(pp.getPersonId());
            } else {
                this.newApprovedForeignTravel.setRolodexTraveler(pp.getRolodex());
                this.newApprovedForeignTravel.setRolodexId(pp.getRolodexId());
            }
            foundKeyPerson = true;
            break;
        }
        if (!foundKeyPerson) {
            for (AwardApprovedForeignTravel aft : this.getAward().getApprovedForeignTravelTrips()) {
                Contactable traveler = aft.getTraveler();
                if (!traveler.getIdentifier().equals(travelerId)) continue;
                if (traveler instanceof KcPerson) {
                    KcPerson person = (KcPerson)traveler;
                    this.newApprovedForeignTravel.setPersonTraveler(person);
                    this.newApprovedForeignTravel.setPersonId(person.getPersonId());
                    break;
                }
                NonOrganizationalRolodex rolodex = (NonOrganizationalRolodex)traveler;
                this.newApprovedForeignTravel.setRolodexTraveler(rolodex);
                this.newApprovedForeignTravel.setRolodexId(rolodex.getRolodexId());
                break;
            }
        }
    }
}

