/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.foreigntravel;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.bo.Contactable;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

public class ApprovedForeignTravelerValuesFinder
extends KeyValuesBase {
    public List<KeyValue> getKeyValues() {
        Contactable contact;
        Award award = this.getAward();
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        TreeSet<String> listNames = new TreeSet<String>();
        for (AwardPerson person : award.getProjectPersons()) {
            contact = person.getContact();
            this.addEligibleTravelerToList(list, listNames, contact);
        }
        for (AwardApprovedForeignTravel trip : award.getApprovedForeignTravelTrips()) {
            contact = trip.getTraveler();
            this.addEligibleTravelerToList(list, listNames, contact);
        }
        return list;
    }

    protected Award getAward() {
        return ((AwardForm)KNSGlobalVariables.getKualiForm()).getAwardDocument().getAward();
    }

    private void addEligibleTravelerToList(List<KeyValue> list, Set<String> listNames, Contactable contact) {
        String fullName;
        if (contact != null && !listNames.contains(fullName = contact.getFullName())) {
            list.add((KeyValue)new ConcreteKeyValue(contact.getIdentifier().toString(), fullName));
            listNames.add(fullName);
        }
    }
}

