/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.rule;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.InvInstructionsIndicatorConstants;
import org.kuali.kra.award.home.ValidBasisMethodPayment;
import org.kuali.kra.award.rule.AwardCommentsRule;
import org.kuali.kra.award.rule.event.AwardCommentsRuleEvent;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.ServiceHelper;

public class AwardCommentsRuleImpl
extends ResearchDocumentRuleBase
implements AwardCommentsRule {
    private static final Integer MAX_COMMENT_LENGTH = 5000;
    private static String[] VALID_BASIS_METHOD_PAYMENT_FINDER_FIELDS = new String[]{"basisOfPaymentCode", "methodOfPaymentCode"};

    @Override
    public boolean processAwardCommentsBusinessRules(AwardCommentsRuleEvent awardCommentsRuleEvent) {
        boolean valid = true;
        valid &= this.checkAwardComment(awardCommentsRuleEvent, "18", "awardPreAwardSponsorAuthorizationComment.comments");
        valid &= this.checkAwardComment(awardCommentsRuleEvent, "19", "awardPreAwardInstitutionalAuthorizationComment.comments");
        valid &= this.checkAwardComment(awardCommentsRuleEvent, "9", "awardCostShareComment.comments");
        valid &= this.checkAwardComment(awardCommentsRuleEvent, "8", "awardFandaRateComment.comments");
        valid &= this.checkAwardComment(awardCommentsRuleEvent, "20", "awardBenefitsRateComment.comments");
        valid &= this.checkAwardComment(awardCommentsRuleEvent, "1", "awardPaymentAndInvoiceRequirementsComments.comments");
        return valid &= this.checkPaymentAndInvoiceCommentRule(awardCommentsRuleEvent, "awardPaymentAndInvoiceRequirementsComments.comments");
    }

    private boolean checkAwardComment(AwardCommentsRuleEvent awardCommentsRuleEvent, String commentTypeCode, String errorKey) {
        String commentString;
        boolean valid = true;
        AwardDocument awardDocument = (AwardDocument)awardCommentsRuleEvent.getDocument();
        Award award = awardDocument.getAward();
        AwardComment awardComment = award.findCommentOfSpecifiedType(commentTypeCode);
        if (awardComment != null && !this.isAwardCommentValid(commentString = awardComment.getComments())) {
            String fullErrorPath = awardCommentsRuleEvent.getErrorPathPrefix() + "." + errorKey;
            this.reportError(fullErrorPath, "error.maxLength", "Comment", MAX_COMMENT_LENGTH.toString());
            valid = false;
        }
        return valid;
    }

    private boolean checkPaymentAndInvoiceCommentRule(AwardCommentsRuleEvent awardCommentsRuleEvent, String errorKey) {
        boolean valid = true;
        AwardDocument awardDocument = (AwardDocument)awardCommentsRuleEvent.getDocument();
        Award award = awardDocument.getAward();
        AwardComment awardComment = award.findCommentOfSpecifiedType("1");
        Collection results = this.getBusinessObjectService().findMatching(ValidBasisMethodPayment.class, ServiceHelper.getInstance().buildCriteriaMap(VALID_BASIS_METHOD_PAYMENT_FINDER_FIELDS, new Object[]{award.getBasisOfPaymentCode(), award.getMethodOfPaymentCode()}));
        if (results.size() == 1) {
            ValidBasisMethodPayment vbpay = (ValidBasisMethodPayment)((Object)results.iterator().next());
            InvInstructionsIndicatorConstants indicator = vbpay.getInvInstructionsIndicatorConstant();
            if (indicator != null) {
                switch (indicator) {
                    case Blank: {
                        boolean bl = valid = awardComment == null || StringUtils.isEmpty((String)awardComment.getComments());
                        if (valid) break;
                        String fullErrorPath = awardCommentsRuleEvent.getErrorPathPrefix() + "." + errorKey;
                        this.reportError(fullErrorPath, "error.invalid.award.payment.invoice.comment.comment.not.allowed", new String[0]);
                        break;
                    }
                    case Mandatory: {
                        boolean bl = valid = awardComment != null && !StringUtils.isEmpty((String)awardComment.getComments());
                        if (valid) break;
                        String fullErrorPath = awardCommentsRuleEvent.getErrorPathPrefix() + "." + errorKey;
                        this.reportError(fullErrorPath, "error.invalid.award.payment.invoice.comment.required", new String[0]);
                    }
                }
            }
        } else if (results.size() > 1) {
            throw new IllegalStateException(String.format("Found more than one ValidBasisMethodPayment records for basisOfPayment=%s and methodOfPayment=%s", award.getBasisOfPaymentCode(), award.getMethodOfPaymentCode()));
        }
        return valid;
    }

    private boolean isAwardCommentValid(String comment) {
        return comment == null || comment.length() <= MAX_COMMENT_LENGTH;
    }
}

