/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.specialreview;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.common.specialreview.web.struts.form.SpecialReviewHelperBase;

public class SpecialReviewHelper
extends SpecialReviewHelperBase<AwardSpecialReview> {
    private static final long serialVersionUID = 6164616866447994314L;
    private static final String PROTOCOL_AWARD_LINKING_ENABLED_PARAMETER = "irb.protocol.award.linking.enabled";
    private static final String IACUC_PROTOCOL_AWARD_LINKING_ENABLED_PARAMETER = "iacuc.protocol.award.linking.enabled";
    private AwardForm form;

    public SpecialReviewHelper(AwardForm form) {
        this.form = form;
        this.setNewSpecialReview(new AwardSpecialReview());
        this.setLinkedProtocolNumbers(new ArrayList<String>());
    }

    public void syncProtocolFundingSourcesWithSpecialReviews() {
        String fundingSourceNumber = this.form.getAwardDocument().getAward().getAwardNumber();
        String fundingSourceTypeCode = "6";
        String fundingSourceName = this.form.getAwardDocument().getAward().getSponsorName();
        String fundingSourceTitle = this.form.getAwardDocument().getAward().getTitle();
        this.syncProtocolFundingSourcesWithSpecialReviews(fundingSourceNumber, fundingSourceTypeCode, fundingSourceName, fundingSourceTitle);
    }

    @Override
    protected boolean hasModifySpecialReviewPermission(String principalId) {
        return BooleanUtils.toBoolean((String)((String)this.form.getEditingMode().get("fullEntry")));
    }

    @Override
    protected boolean isIrbProtocolLinkingEnabledForModule() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", PROTOCOL_AWARD_LINKING_ENABLED_PARAMETER);
    }

    @Override
    protected boolean isIacucProtocolLinkingEnabledForModule() {
        return this.getParameterService().getParameterValueAsBoolean("KC-IACUC", "Document", IACUC_PROTOCOL_AWARD_LINKING_ENABLED_PARAMETER);
    }

    @Override
    protected List<AwardSpecialReview> getSpecialReviews() {
        return this.form.getAwardDocument().getAward().getSpecialReviews();
    }

    @Override
    public boolean isCanCreateIrbProtocol() {
        return false;
    }

    @Override
    public boolean isCanCreateIacucProtocol() {
        return false;
    }
}

