/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.version.service.impl;

import java.util.List;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.service.VersionHistoryService;

public class AwardVersionServiceImpl
implements AwardVersionService {
    private VersionHistoryService versionHistoryService;

    @Override
    public Award getWorkingAwardVersion(String awardNumber) {
        List<VersionHistory> versions = this.versionHistoryService.findVersionHistory(Award.class, awardNumber);
        VersionHistory activeVersion = this.getActiveVersionHistory(versions);
        VersionHistory pendingVersion = this.getPendingVersionHistory(versions);
        VersionHistory workingVersion = null;
        if (pendingVersion != null) {
            workingVersion = pendingVersion;
        } else if (activeVersion != null) {
            workingVersion = activeVersion;
        } else {
            return null;
        }
        this.versionHistoryService.loadSequenceOwner(Award.class, workingVersion);
        return (Award)workingVersion.getSequenceOwner();
    }

    @Override
    public Award getActiveAwardVersion(String awardNumber) {
        List<VersionHistory> versions = this.versionHistoryService.findVersionHistory(Award.class, awardNumber);
        VersionHistory result = this.getActiveVersionHistory(versions);
        return result == null ? null : (Award)result.getSequenceOwner();
    }

    @Override
    public Award getPendingAwardVersion(String awardNumber) {
        List<VersionHistory> versions = this.versionHistoryService.findVersionHistory(Award.class, awardNumber);
        VersionHistory result = this.getPendingVersionHistory(versions);
        return result == null ? null : (Award)result.getSequenceOwner();
    }

    private VersionHistory getPendingVersionHistory(List<VersionHistory> list) {
        VersionHistory returnVal = null;
        for (VersionHistory vh : list) {
            if (!vh.getStatus().equals((Object)VersionStatus.PENDING)) continue;
            returnVal = vh;
        }
        return returnVal;
    }

    private VersionHistory getActiveVersionHistory(List<VersionHistory> list) {
        VersionHistory returnVal = null;
        for (VersionHistory vh : list) {
            if (!vh.getStatus().equals((Object)VersionStatus.ACTIVE)) continue;
            returnVal = vh;
        }
        return returnVal;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }
}

