/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.commitments.AddAwardFandaRateEvent;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.commitments.AwardFandaRateRule;
import org.kuali.kra.award.commitments.AwardFandaRateSaveEvent;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.kra.award.web.struts.action.CostShareActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;

public class AwardCommitmentsAction
extends AwardAction {
    private static final String CONFIRM_DELETE_COST_SHARE = "confirmDeleteCostShare";
    private static final String CONFIRM_DELETE_COST_SHARE_KEY = "confirmDeleteCostShareKey";
    private CostShareActionHelper costShareActionHelper = new CostShareActionHelper();

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isValid = true;
        AwardForm awardForm = (AwardForm)form;
        List<AwardFandaRate> fandaRates = awardForm.getAwardDocument().getAward().getAwardFandaRate();
        if (awardForm.getAwardDocument().getAward().getAwardFandaRate() != null || !awardForm.getAwardDocument().getAward().getAwardFandaRate().isEmpty()) {
            awardForm.getAwardDocument().getAward().setIdcIndicator("Y");
        } else {
            awardForm.getAwardDocument().getAward().setIdcIndicator("N");
        }
        if (awardForm.getAwardDocument().getAward().getAwardCostShares() != null || !awardForm.getAwardDocument().getAward().getAwardCostShares().isEmpty()) {
            awardForm.getAwardDocument().getAward().setCostSharingIndicator("Y");
        } else {
            awardForm.getAwardDocument().getAward().setCostSharingIndicator("N");
        }
        for (int i = 0; i < fandaRates.size(); ++i) {
            if (this.getKualiRuleService().applyRules((KualiDocumentEvent)new AwardFandaRateSaveEvent("", awardForm.getAwardDocument(), i))) continue;
            isValid = false;
        }
        if (isValid) {
            return super.save(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addCostShare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.costShareActionHelper.addCostShare(((AwardForm)form).getCostShareFormHelper());
        return mapping.findForward("basic");
    }

    boolean addCostShareToAward(Award award, AwardCostShare awardCostShare) {
        return award.getAwardCostShares().add(awardCostShare);
    }

    public ActionForward deleteCostShare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int delCostShare = this.getLineToDelete(request);
        return this.confirm(this.buildDeleteCostShareConfirmationQuestion(mapping, form, request, response, delCostShare + 1), CONFIRM_DELETE_COST_SHARE, "");
    }

    boolean deleteCostShareFromAward(Award award, int lineToDelete) {
        award.getAwardCostShares().remove(lineToDelete);
        return true;
    }

    public ActionForward confirmDeleteCostShare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        int delCostShare = this.getLineToDelete(request);
        awardDocument.getAward().getAwardCostShares().remove(delCostShare);
        return mapping.findForward("basic");
    }

    public ActionForward recalculateCostShareTotal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildDeleteCostShareConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, int deleteCostShare) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_COST_SHARE_KEY, "document.question.deleteCostShare.text", Integer.toString(deleteCostShare));
    }

    public ActionForward addFandaRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardFandaRate newAwardFandaRate = awardForm.getNewAwardFandaRate();
        AwardFandaRateRule rule = new AwardFandaRateRule();
        if (rule.processAddFandaRateBusinessRules(new AddAwardFandaRateEvent("", awardForm.getAwardDocument(), newAwardFandaRate))) {
            this.addFandaRateToAward(awardForm.getAwardDocument().getAward(), newAwardFandaRate);
            awardForm.setNewAwardFandaRate(new AwardFandaRate());
        }
        return mapping.findForward("basic");
    }

    boolean addFandaRateToAward(Award award, AwardFandaRate awardFandaRate) {
        awardFandaRate.setAward(award);
        return award.getAwardFandaRate().add(awardFandaRate);
    }

    public ActionForward deleteFandaRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = (AwardDocument)awardForm.getDocument();
        this.deleteFandaRateFromAward(awardDocument.getAward(), this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    boolean deleteFandaRateFromAward(Award award, int lineToDelete) {
        award.getAwardFandaRate().remove(lineToDelete);
        return true;
    }

    public ActionForward recalculateFandARate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }
}

