/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.home.keywords.AwardScienceKeyword;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.web.struts.action.ApprovedSubawardActionHelper;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.common.specialreview.rule.event.SaveSpecialReviewLinkEvent;
import org.kuali.kra.common.specialreview.service.SpecialReviewService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KeywordsService;
import org.kuali.kra.service.VersioningService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardHomeAction
extends AwardAction {
    private static final String AWARD_VERSION_EDITPENDING_PROMPT_KEY = "message.award.version.editpending.prompt";
    private static final String DOC_HANDLER_URL_PATTERN = "%s/DocHandler.do?command=displayDocSearchView&docId=%s";
    private ApprovedSubawardActionHelper approvedSubawardActionHelper = new ApprovedSubawardActionHelper();
    private ParameterService parameterService;

    public ActionForward addFundingProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getFundingProposalBean().addFundingProposal();
        return mapping.findForward("basic");
    }

    public ActionForward addApprovedSubaward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.approvedSubawardActionHelper.addApprovedSubaward(((AwardForm)form).getApprovedSubawardFormHelper());
        return mapping.findForward("basic");
    }

    boolean addApprovedSubawardToAward(Award award, AwardApprovedSubaward awardApprovedSubaward) {
        return award.getAwardApprovedSubawards().add(awardApprovedSubaward);
    }

    public ActionForward deleteApprovedSubaward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        int delApprovedSubaward = this.getLineToDelete(request);
        awardDocument.getAward().getAwardApprovedSubawards().remove(delApprovedSubaward);
        return mapping.findForward("basic");
    }

    boolean deleteApprovedSubawardFromAward(Award award, int lineToDelete) {
        award.getAwardApprovedSubawards().remove(lineToDelete);
        return true;
    }

    public ActionForward open(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        String commandParam = request.getParameter("command");
        if (StringUtils.isNotBlank((String)commandParam) && commandParam.equals("initiate") && StringUtils.isNotBlank((String)request.getParameter("awardId"))) {
            Award award = this.findSelectedAward(request.getParameter("awardId"));
            this.initializeFormWithAward(awardForm, award);
        }
        return actionForward;
    }

    public ActionForward recalculateSubawardTotal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.approvedSubawardActionHelper.recalculateSubawardTotal(((AwardForm)form).getApprovedSubawardFormHelper());
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        String commandParam = request.getParameter("command");
        if (StringUtils.isNotBlank((String)commandParam) && commandParam.equals("initiate") && StringUtils.isNotBlank((String)request.getParameter("awardId"))) {
            Award award = this.findSelectedAward(request.getParameter("awardId"));
            this.initializeFormWithAward(awardForm, award);
        }
        if (StringUtils.isNotBlank((String)commandParam) && "redirectAwardHistoryFullViewForPopup".equals(commandParam)) {
            String awardDocumentNumber = request.getParameter("awardDocumentNumber");
            String awardNumber = request.getParameter("awardNumber");
            actionForward = this.redirectAwardHistoryFullViewForPopup(mapping, form, request, response, awardDocumentNumber, awardNumber);
        }
        return actionForward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        GlobalVariables.getUserSession().removeObject("linkedProposals");
        AwardForm awardMultiLookupForm = (AwardForm)form;
        String lookupResultsBOClassName = request.getParameter("lookupResultsBOClassName");
        String lookupResultsSequenceNumber = request.getParameter("lookupResultsSequenceNumber");
        awardMultiLookupForm.setLookupResultsBOClassName(lookupResultsBOClassName);
        awardMultiLookupForm.setLookupResultsSequenceNumber(lookupResultsSequenceNumber);
        Award awardDocument = awardMultiLookupForm.getAwardDocument().getAward();
        this.getKeywordService().addKeywords(awardDocument, awardMultiLookupForm);
        awardDocument.refreshReferenceObject("sponsor");
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        if (awardDocument.getAward().getAwardNumber().endsWith("-00000")) {
            awardDocument.getAward().getLastAwardAmountInfo().resetChangeValues();
        } else if (awardDocument.getAward().getAwardNumber().endsWith("-00001")) {
            if (this.isDirectIndirectViewEnabled()) {
                this.setTotalsOnAward(awardDocument.getAward());
            }
            Award oldAward = this.getAwardVersionService().getActiveAwardVersion(awardDocument.getAward().getAwardNumber());
            AwardAmountInfo aaiNew = awardDocument.getAward().getLastAwardAmountInfo();
            if (oldAward != null) {
                AwardAmountInfo aaiOld = oldAward.getLastAwardAmountInfo();
                aaiNew.setObligatedChange((KualiDecimal)aaiNew.getAmountObligatedToDate().subtract((AbstractKualiDecimal)aaiOld.getAmountObligatedToDate()));
                aaiNew.setObligatedChangeDirect((KualiDecimal)aaiNew.getObligatedTotalDirect().subtract((AbstractKualiDecimal)aaiOld.getObligatedTotalDirect()));
                aaiNew.setObligatedChangeIndirect((KualiDecimal)aaiNew.getObligatedTotalIndirect().subtract((AbstractKualiDecimal)aaiOld.getObligatedTotalIndirect()));
                aaiNew.setAnticipatedChange((KualiDecimal)aaiNew.getAnticipatedTotalAmount().subtract((AbstractKualiDecimal)aaiOld.getAnticipatedTotalAmount()));
                aaiNew.setAnticipatedChangeDirect((KualiDecimal)aaiNew.getAnticipatedTotalDirect().subtract((AbstractKualiDecimal)aaiOld.getAnticipatedTotalDirect()));
                aaiNew.setAnticipatedChangeIndirect((KualiDecimal)aaiNew.getAnticipatedTotalIndirect().subtract((AbstractKualiDecimal)aaiOld.getAnticipatedTotalIndirect()));
            } else {
                aaiNew.resetChangeValues();
            }
        }
        if (awardDocument.getAward().getAwardAmountInfos().get(0).getAnticipatedTotalAmount() == null) {
            awardDocument.getAward().getAwardAmountInfos().get(0).setAnticipatedTotalAmount(new KualiDecimal(0));
        }
        if (awardDocument.getAward().getAwardAmountInfos().get(0).getAmountObligatedToDate() == null) {
            awardDocument.getAward().getAwardAmountInfos().get(0).setAmountObligatedToDate(new KualiDecimal(0));
        }
        awardForm.getProjectPersonnelBean().updateLeadUnit();
        if (this.getReportTrackingService().shouldAlertReportTrackingDetailChange(awardForm.getAwardDocument().getAward())) {
            GlobalVariables.getMessageMap().putWarning("document.awardList[0].awardExecutionDate", "warning.reportTracking.updateFromDateChange", new String[]{""});
        }
        boolean isAwardProtocolLinkingEnabled = this.getParameterService().getParameterValueAsBoolean("KC-PROTOCOL", "Document", "irb.protocol.award.linking.enabled");
        List<AwardSpecialReview> specialReviews = awardDocument.getAward().getSpecialReviews();
        if (!isAwardProtocolLinkingEnabled || this.applyRules((KualiDocumentEvent)new SaveSpecialReviewLinkEvent<AwardSpecialReview>((Document)awardDocument, specialReviews))) {
            forward = super.save(mapping, form, request, response);
            awardDocument.getAward().refreshReferenceObject("sponsor");
            Award award = awardDocument.getAward();
            award.setSponsorNihMultiplePi(this.getSponsorService().isSponsorNihMultiplePi(award));
            this.persistSpecialReviewProtocolFundingSourceLink(award, isAwardProtocolLinkingEnabled);
        }
        return forward;
    }

    private void setTotalsOnAward(Award award) {
        AwardAmountInfo aai = award.getLastAwardAmountInfo();
        aai.setAmountObligatedToDate((KualiDecimal)aai.getObligatedTotalDirect().add((AbstractKualiDecimal)aai.getObligatedTotalIndirect()));
        aai.setAnticipatedTotalAmount((KualiDecimal)aai.getAnticipatedTotalDirect().add((AbstractKualiDecimal)aai.getAnticipatedTotalIndirect()));
    }

    private void persistSpecialReviewProtocolFundingSourceLink(Award award, boolean isAwardProtocolLinkingEnabled) {
        if (isAwardProtocolLinkingEnabled) {
            SpecialReviewService specialReviewService = KraServiceLocator.getService(SpecialReviewService.class);
            for (AwardSpecialReview specialReview : award.getSpecialReviews()) {
                if (!"1".equals(specialReview.getSpecialReviewTypeCode())) continue;
                String protocolNumber = specialReview.getProtocolNumber();
                String fundingSourceNumber = award.getAwardNumber();
                String fundingSourceTypeCode = "6";
                String fundingSourceName = award.getSponsorName();
                String fundingSourceTitle = award.getTitle();
                if (specialReviewService.isLinkedToProtocolFundingSource(protocolNumber, fundingSourceNumber, fundingSourceTypeCode)) continue;
                specialReviewService.addProtocolFundingSourceForSpecialReview(protocolNumber, fundingSourceNumber, fundingSourceTypeCode, fundingSourceName, fundingSourceTitle);
            }
        }
    }

    @Override
    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    @Override
    public boolean isDirectIndirectViewEnabled() {
        boolean returnValue = false;
        String directIndirectEnabledValue = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        if (directIndirectEnabledValue.equals("1")) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        this.checkAwardNumber(awardForm.getAwardDocument().getAward());
        return super.close(mapping, (ActionForm)awardForm, request, response);
    }

    @Override
    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName) && parameterName.indexOf(".performLookup") != -1 && parameterName.contains("InstitutionalProposal")) {
            GlobalVariables.getUserSession().addObject("linkedProposals", ((AwardForm)form).getLinkedProposals());
        }
        return super.performLookup(mapping, form, request, response);
    }

    protected KeywordsService getKeywordService() {
        return KraServiceLocator.getService(KeywordsService.class);
    }

    public ActionForward selectAllScienceKeyword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        List<AwardScienceKeyword> keywords = awardDocument.getAward().getKeywords();
        for (AwardScienceKeyword awardScienceKeyword : keywords) {
            awardScienceKeyword.setSelectKeyword(true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteSelectedScienceKeyword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        KeywordsService keywordsService = KraServiceLocator.getService(KeywordsService.class);
        keywordsService.deleteKeyword(awardDocument.getAward());
        return mapping.findForward("basic");
    }

    public ActionForward editOrVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        Award award = awardDocument.getAward();
        AwardDocument parentSyncAward = this.getAwardSyncService().getAwardLockingHierarchyForSync(awardDocument, GlobalVariables.getUserSession().getPrincipalId());
        if (parentSyncAward != null) {
            KNSGlobalVariables.getMessageList().add("error.award.awardhierarchy.sync.locked", new String[]{parentSyncAward.getDocumentNumber()});
            return mapping.findForward("basic");
        }
        if (this.getTimeAndMoneyExistenceService().validateTimeAndMoneyRule(award, awardForm.getAwardHierarchyBean().getRootNode().getAwardNumber())) {
            String question;
            VersionHistory foundPending = this.findPendingVersion(award);
            this.cleanUpUserSession();
            forward = foundPending != null ? ((question = request.getParameter("buttonClicked")) == null ? this.showPromptForEditingPendingVersion(mapping, form, request, response) : this.processPromptForEditingPendingVersionResponse(mapping, request, response, awardForm, foundPending)) : this.createAndSaveNewAwardVersion(response, awardForm, awardDocument, award);
        } else {
            this.getTimeAndMoneyExistenceService().addAwardVersionErrorMessage();
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    private ActionForward createAndSaveNewAwardVersion(HttpServletResponse response, AwardForm awardForm, AwardDocument awardDocument, Award award) throws Exception {
        awardForm.getAwardDocument().getAward().setNewVersion(true);
        AwardDocument newAwardDocument = this.getAwardService().createNewAwardVersion(awardForm.getAwardDocument());
        this.getDocumentService().saveDocument((Document)newAwardDocument);
        this.getAwardService().updateAwardSequenceStatus(newAwardDocument.getAward(), VersionStatus.PENDING);
        this.getVersionHistoryService().updateVersionHistory(newAwardDocument.getAward(), VersionStatus.PENDING, GlobalVariables.getUserSession().getPrincipalName());
        this.reinitializeAwardForm(awardForm, newAwardDocument);
        return new ActionForward(this.makeDocumentOpenUrl(newAwardDocument), true);
    }

    public ActionForward addAwardTransferringSponsor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getDetailsAndDatesFormHelper().addAwardTransferringSponsor();
        return mapping.findForward("basic");
    }

    public ActionForward deleteAwardTransferringSponsor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getDetailsAndDatesFormHelper().deleteAwardTransferringSponsor(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteAwardFundingProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).getFundingProposalBean().deleteAwardFundingProposal(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }

    protected VersioningService getVersioningService() {
        return KraServiceLocator.getService(VersioningService.class);
    }

    protected BudgetSummaryService getBudgetSummaryService() {
        return KraServiceLocator.getService(BudgetSummaryService.class);
    }

    protected Award findSelectedAward(String awardId) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("awardId", awardId);
        List awards = (List)this.getBusinessObjectService().findMatching(Award.class, fieldMap);
        return (Award)awards.get(0);
    }

    private void initializeFormWithAward(AwardForm awardForm, Award award) throws WorkflowException {
        this.reinitializeAwardForm(awardForm, this.findDocumentForAward(award));
    }

    private AwardDocument findDocumentForAward(Award award) throws WorkflowException {
        AwardDocument document = (AwardDocument)this.getDocumentService().getByDocumentHeaderId(award.getAwardDocument().getDocumentNumber());
        document.setAward(award);
        return document;
    }

    private void reinitializeAwardForm(AwardForm awardForm, AwardDocument document) throws WorkflowException {
        awardForm.populateHeaderFields(document.getDocumentHeader().getWorkflowDocument());
        awardForm.setDocument((Document)document);
        document.setDocumentSaveAfterAwardLookupEditOrVersion(true);
        awardForm.initialize();
    }

    private String makeDocumentOpenUrl(AwardDocument newAwardDocument) {
        String workflowUrl = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
        return String.format(DOC_HANDLER_URL_PATTERN, workflowUrl, newAwardDocument.getDocumentNumber());
    }

    private VersionHistory findPendingVersion(Award award) {
        List<VersionHistory> histories = this.getVersionHistoryService().loadVersionHistory(Award.class, award.getAwardNumber());
        VersionHistory foundPending = null;
        for (VersionHistory history : histories) {
            if (history.getStatus() != VersionStatus.PENDING || award.getSequenceNumber() >= history.getSequenceOwnerSequenceNumber()) continue;
            foundPending = history;
            break;
        }
        return foundPending;
    }

    private ActionForward showPromptForEditingPendingVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.performQuestionWithoutInput(mapping, form, request, response, "EDIT_OR_VERSION_QUESTION_ID", this.getResources(request).getMessage(AWARD_VERSION_EDITPENDING_PROMPT_KEY), "confirmationQuestion", "cancel", "");
    }

    private ActionForward processPromptForEditingPendingVersionResponse(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, AwardForm awardForm, VersionHistory foundPending) throws WorkflowException, IOException {
        ActionForward forward;
        String buttonClicked = request.getParameter("buttonClicked");
        if ("1".equals(buttonClicked)) {
            forward = mapping.findForward("basic");
        } else {
            this.initializeFormWithAward(awardForm, (Award)foundPending.getSequenceOwner());
            response.sendRedirect(this.makeDocumentOpenUrl(awardForm.getAwardDocument()));
            forward = null;
        }
        return forward;
    }

    public ActionForward applySponsorTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward result = this.fullSyncToAwardTemplate(mapping, form, request, response);
        awardForm.buildReportTrackingBeans();
        return result;
    }

    private ActionForward redirectAwardHistoryFullViewForPopup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String awardDocumentNumber, String awardNumber) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        response.sendRedirect("awardHistory.do?methodToCall=openWindow&awardDocumentNumber=" + awardDocumentNumber + "&awardNumber=" + awardNumber + "&docTypeName=" + awardForm.getDocTypeName());
        return null;
    }
}

