/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.sql.Date;
import org.kuali.kra.bo.AbstractInstituteRateKey;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.rates.AbstractBudgetRate;
import org.kuali.kra.budget.rates.RateClass;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

public abstract class AbstractInstituteRate
extends KraPersistableBusinessObjectBase
implements Comparable<AbstractInstituteRate>,
AbstractInstituteRateKey,
MutableInactivatable {
    private static final long serialVersionUID = -2136003574701633349L;
    private String fiscalYear;
    private Boolean onOffCampusFlag;
    private String rateClassCode;
    private String rateTypeCode;
    private Date startDate;
    private String unitNumber;
    private BudgetDecimal instituteRate;
    private BudgetDecimal externalApplicableRate;
    private RateClass rateClass;
    private RateType rateType;
    private Unit unit;
    private Boolean active = Boolean.TRUE;
    private boolean nonEditableRateFlag;

    public final boolean isActive() {
        return this.active;
    }

    public final void setActive(boolean active) {
        this.active = active;
    }

    public RateClass getRateClass() {
        return this.rateClass;
    }

    public void setRateClass(RateClass rateClass) {
        this.rateClass = rateClass;
    }

    public RateType getRateType() {
        return this.rateType;
    }

    public void setRateType(RateType rateType) {
        this.rateType = rateType;
    }

    public String getFiscalYear() {
        return this.fiscalYear;
    }

    public void setFiscalYear(String fiscalYear) {
        this.fiscalYear = fiscalYear;
    }

    @Override
    public Boolean getOnOffCampusFlag() {
        return this.onOffCampusFlag;
    }

    public void setOnOffCampusFlag(Boolean onOffCampusFlag) {
        this.onOffCampusFlag = onOffCampusFlag;
    }

    @Override
    public String getRateClassCode() {
        return this.rateClassCode;
    }

    public void setRateClassCode(String rateClassCode) {
        this.rateClassCode = rateClassCode;
    }

    @Override
    public String getRateTypeCode() {
        return this.rateTypeCode;
    }

    public void setRateTypeCode(String rateTypeCode) {
        this.rateTypeCode = rateTypeCode;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public BudgetDecimal getInstituteRate() {
        return this.instituteRate;
    }

    public void setInstituteRate(BudgetDecimal rate) {
        this.instituteRate = rate;
    }

    public String getRateClassType() {
        return this.rateClass.getRateClassType();
    }

    @Override
    public int compareTo(AbstractInstituteRate abstractInstituteRate) {
        int result = this.getRateType().getDescription().compareTo(abstractInstituteRate.getRateType().getDescription());
        result = result != 0 ? result : this.getFiscalYear().compareTo(abstractInstituteRate.getFiscalYear());
        result = result != 0 ? result : this.getOnOffCampusFlag().compareTo(abstractInstituteRate.getOnOffCampusFlag());
        return result;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public String getRateKeyAsString() {
        return this.getRateClassCode() + this.getRateTypeCode() + this.getLocationFlagAsString(this.getOnOffCampusFlag()) + this.getStartDate();
    }

    protected AbstractBudgetRate createBudgetRate() {
        throw new UnsupportedOperationException("Cannot create BudgetRate.");
    }

    private String getLocationFlagAsString(boolean campusFlag) {
        return campusFlag ? "N" : "F";
    }

    public boolean getNonEditableRateFlag() {
        return this.nonEditableRateFlag;
    }

    public void setNonEditableRateFlag(boolean flatRateCalculation) {
        this.nonEditableRateFlag = flatRateCalculation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active == null ? 0 : this.active.hashCode());
        result = 31 * result + (this.fiscalYear == null ? 0 : this.fiscalYear.hashCode());
        result = 31 * result + (this.instituteRate == null ? 0 : this.instituteRate.hashCode());
        result = 31 * result + (this.onOffCampusFlag == null ? 0 : this.onOffCampusFlag.hashCode());
        result = 31 * result + (this.rateClass == null ? 0 : ((Object)((Object)this.rateClass)).hashCode());
        result = 31 * result + (this.rateClassCode == null ? 0 : this.rateClassCode.hashCode());
        result = 31 * result + (this.rateType == null ? 0 : this.rateType.hashCode());
        result = 31 * result + (this.rateTypeCode == null ? 0 : this.rateTypeCode.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.unitNumber == null ? 0 : this.unitNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractInstituteRate other = (AbstractInstituteRate)obj;
        if (this.active == null ? other.active != null : !this.active.equals(other.active)) {
            return false;
        }
        if (this.fiscalYear == null ? other.fiscalYear != null : !this.fiscalYear.equals(other.fiscalYear)) {
            return false;
        }
        if (this.instituteRate == null ? other.instituteRate != null : !this.instituteRate.equals((Object)other.instituteRate)) {
            return false;
        }
        if (this.onOffCampusFlag == null ? other.onOffCampusFlag != null : !this.onOffCampusFlag.equals(other.onOffCampusFlag)) {
            return false;
        }
        if (this.rateClass == null ? other.rateClass != null : !((Object)((Object)this.rateClass)).equals((Object)other.rateClass)) {
            return false;
        }
        if (this.rateClassCode == null ? other.rateClassCode != null : !this.rateClassCode.equals(other.rateClassCode)) {
            return false;
        }
        if (this.rateType == null ? other.rateType != null : !this.rateType.equals(other.rateType)) {
            return false;
        }
        if (this.rateTypeCode == null ? other.rateTypeCode != null : !this.rateTypeCode.equals(other.rateTypeCode)) {
            return false;
        }
        if (this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals((Object)other.unit)) {
            return false;
        }
        return !(this.unitNumber == null ? other.unitNumber != null : !this.unitNumber.equals(other.unitNumber));
    }

    public BudgetDecimal getExternalApplicableRate() {
        return this.externalApplicableRate == null ? this.getInstituteRate() : this.externalApplicableRate;
    }

    public void setExternalApplicableRate(BudgetDecimal externalApplicableRate) {
        this.externalApplicableRate = externalApplicableRate;
    }
}

