/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.io.IOException;
import java.util.Arrays;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.SeparateAssociate;
import org.kuali.kra.bo.KcAttachment;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KcAttachmentService;

public class AttachmentFile
extends SeparateAssociate
implements KcAttachment {
    public static final int MAX_FILE_NAME_LENGTH = 150;
    public static final int MAX_FILE_TYPE_LENGTH = 250;
    private static final long serialVersionUID = 8999619585664343780L;
    private Long id;
    private String name;
    private String type;
    private byte[] data;

    public AttachmentFile() {
    }

    public AttachmentFile(String name, String type, byte[] data) {
        this.setName(name);
        this.setType(type);
        this.setData(data);
    }

    public static final AttachmentFile createFromFormFile(FormFile formFile) {
        if (formFile == null) {
            throw new IllegalArgumentException("the formFile is null");
        }
        String fName = AttachmentFile.removeFrontForLength(formFile.getFileName(), 150);
        String fType = AttachmentFile.removeFrontForLength(formFile.getContentType(), 250);
        try {
            return new AttachmentFile(fName, fType, formFile.getFileData());
        }
        catch (IOException e) {
            throw new CreateException(e);
        }
    }

    private static String removeFrontForLength(String aString, int aLength) {
        assert (aString != null) : "aString is null";
        assert (aLength > 0) : "aLength is negative: " + aLength;
        if (aString.length() > aLength) {
            StringBuilder tempString = new StringBuilder(aString);
            tempString.delete(0, tempString.length() - aLength);
            return tempString.toString();
        }
        return aString;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public byte[] getData() {
        return this.data == null ? null : (byte[])this.data.clone();
    }

    public void setData(byte[] data) {
        this.data = data == null ? null : (byte[])data.clone();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.getData());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttachmentFile other = (AttachmentFile)obj;
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return !(this.getType() == null ? other.getType() != null : !this.getType().equals(other.getType()));
    }

    @Override
    public String getIconPath() {
        return KraServiceLocator.getService(KcAttachmentService.class).getFileTypeIcon(this);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public static class CreateException
    extends RuntimeException {
        private static final long serialVersionUID = -230592614193518930L;

        public CreateException(Throwable t) {
            super(t);
        }
    }
}

