/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationCorrespondent;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.correspondence.CorrespondentType;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.service.BusinessObjectService;

public class OrganizationCorrespondentMaintainableImpl
extends KraMaintainableImpl
implements Maintainable {
    private static final long serialVersionUID = 7781035495216633332L;
    private static final String KIM_PERSON_LOOKUPABLE_REFRESH_CALLER = "kimPersonLookupable";
    private static final String ORGANIZATION_ID_INVALID_ERROR_KEY = "error.protocolLocation.organizationId.invalid";
    private static final String PRINCIPAL_ID_INVALID_ERROR_KEY = "error.invalid.unitAdministrator.principalId";
    private static final String CORRESPONDENT_TYPE_CODE_INVALID_ERROR_KEY = "error.invalid.organizationCorrespondent.correspondentType";

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        if (KIM_PERSON_LOOKUPABLE_REFRESH_CALLER.equals(refreshCaller)) {
            OrganizationCorrespondent organizationCorrespondent = (OrganizationCorrespondent)this.getBusinessObject();
            String principalId = (String)fieldValues.get("principalId");
            organizationCorrespondent.setPersonId(principalId);
        }
    }

    @Override
    public void prepareForSave() {
        OrganizationCorrespondent organizationCorrespondent = (OrganizationCorrespondent)this.businessObject;
        if (!this.isOrganizationIdValid(organizationCorrespondent.getOrganizationId())) {
            this.reportInvalidOrganizationId(organizationCorrespondent);
        }
        if (!this.isCorrespondentTypeCodeValid(organizationCorrespondent.getCorrespondentTypeCode())) {
            this.reportInvalidCorrespondentTypeCode(organizationCorrespondent);
        }
        if (!this.isValidPrincipalId(organizationCorrespondent.getPersonId())) {
            this.reportInvalidPrincipalId(organizationCorrespondent);
        }
        super.prepareForSave();
    }

    private void reportInvalidOrganizationId(OrganizationCorrespondent organizationCorrespondent) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.organizationId", ORGANIZATION_ID_INVALID_ERROR_KEY, new String[0]);
    }

    private void reportInvalidPrincipalId(OrganizationCorrespondent organizationCorrespondent) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.person.userName", PRINCIPAL_ID_INVALID_ERROR_KEY, new String[0]);
    }

    private void reportInvalidCorrespondentTypeCode(OrganizationCorrespondent organizationCorrespondent) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.correspondentTypeCode", CORRESPONDENT_TYPE_CODE_INVALID_ERROR_KEY, new String[0]);
    }

    private boolean isValidPrincipalId(String principalId) {
        boolean valid = true;
        KcPersonService personService = KraServiceLocator.getService(KcPersonService.class);
        if (StringUtils.isEmpty((String)principalId)) {
            valid = false;
        } else {
            KcPerson person = personService.getKcPersonByPersonId(principalId);
            if (person == null) {
                valid = false;
            }
        }
        return valid;
    }

    private boolean isOrganizationIdValid(String organizationId) {
        BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> validParams = new HashMap<String, String>();
        validParams.put("organizationId", organizationId);
        return !businessObjectService.findMatching(Organization.class, validParams).isEmpty();
    }

    private boolean isCorrespondentTypeCodeValid(Integer correspondentTypeCode) {
        BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> validParams = new HashMap<String, String>();
        validParams.put("correspondentTypeCode", correspondentTypeCode.toString());
        return !businessObjectService.findMatching(CorrespondentType.class, validParams).isEmpty();
    }
}

