/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class RolodexMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = -6436670290567992063L;
    public static final String ROLODEX_ID_SEQUENCE_NAME = "SEQ_ROLODEX_ID";
    public static final String AUTO_GEN_ROLODEX_ID_PARM = "AUTO_GENERATE_NON_EMPLOYEE_ID";
    public static final String SECTION_ID = "Edit Address Book";
    public static final String ROLODEX_ID_NAME = "rolodexId";
    public static final String ORGANIZATION = "organization";
    private static final String YES = "Y";
    private static final String NO = "N";
    private transient ParameterService parameterService;
    private transient SequenceAccessorService sequenceAccessorService;

    public void setGenerateDefaultValues(String docTypeName) {
        super.setGenerateDefaultValues(docTypeName);
        Rolodex rolodex = (Rolodex)this.getBusinessObject();
        if (this.isAutoGenerateCode()) {
            rolodex.setRolodexId(Integer.parseInt(this.getSequenceAccessorService().getNextAvailableSequenceNumber(ROLODEX_ID_SEQUENCE_NAME, Rolodex.class).toString()));
        }
    }

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        if (this.isAutoGenerateCode()) {
            this.disableRolodexId(sections);
        }
        return sections;
    }

    protected void disableRolodexId(List<Section> sections) {
        Rolodex rolodex = (Rolodex)this.getBusinessObject();
        for (Section section : sections) {
            if (!StringUtils.equals((String)section.getSectionId(), (String)SECTION_ID)) continue;
            for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (!StringUtils.equals((String)field.getPropertyName(), (String)ROLODEX_ID_NAME)) continue;
                    field.setReadOnly(true);
                }
            }
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        this.setGenerateDefaultValues(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
    }

    protected boolean isAutoGenerateCode() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", AUTO_GEN_ROLODEX_ID_PARM);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KraServiceLocator.getService(SequenceAccessorService.class);
        }
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        Rolodex rolodex = (Rolodex)this.getBusinessObject();
        if (rolodex != null) {
            if (rolodex.getIsSponsorAddress() != null && rolodex.getIsSponsorAddress().equalsIgnoreCase(YES)) {
                rolodex.setSponsorAddressFlag(true);
            } else if (rolodex.getIsSponsorAddress() != null && rolodex.getIsSponsorAddress().equalsIgnoreCase(NO)) {
                rolodex.setSponsorAddressFlag(false);
            }
        }
    }
}

