/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class SponsorMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = 3366318004175290243L;
    public static final String SPONSOR_CODE_SEQUENCE_NAME = "SEQ_SPONSOR_CODE";
    public static final String AUTO_GEN_SPONSOR_CODE_PARM = "AUTO_GENERATE_SPONSOR_CODE";
    public static final String SECTION_ID = "Edit Sponsor";
    public static final String SPONSOR_CODE_NAME = "sponsorCode";
    private transient ParameterService parameterService;
    private transient SequenceAccessorService sequenceAccessorService;

    public void setGenerateDefaultValues(String docTypeName) {
        super.setGenerateDefaultValues(docTypeName);
        Sponsor sponsor = (Sponsor)this.getBusinessObject();
        if (this.isAutoGenerateCode()) {
            sponsor.setSponsorCode(this.getSequenceAccessorService().getNextAvailableSequenceNumber(SPONSOR_CODE_SEQUENCE_NAME, Sponsor.class).toString());
        }
    }

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        if (this.isAutoGenerateCode()) {
            this.disableSponsorCode(sections);
        }
        return sections;
    }

    protected void disableSponsorCode(List<Section> sections) {
        for (Section section : sections) {
            if (!StringUtils.equals((String)section.getSectionId(), (String)SECTION_ID)) continue;
            for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (!StringUtils.equals((String)field.getPropertyName(), (String)SPONSOR_CODE_NAME)) continue;
                    field.setReadOnly(true);
                }
            }
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        this.setGenerateDefaultValues(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
    }

    protected boolean isAutoGenerateCode() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", AUTO_GEN_SPONSOR_CODE_PARM);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KraServiceLocator.getService(SequenceAccessorService.class);
        }
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

