/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

public class Unit
extends KraPersistableBusinessObjectBase
implements MutableInactivatable {
    private static final long serialVersionUID = 7170184898996866958L;
    private String unitNumber;
    private String parentUnitNumber;
    private String organizationId;
    private String unitName;
    private String code;
    private boolean active;
    private Unit parentUnit;
    private List<UnitAdministrator> unitAdministrators = new ArrayList<UnitAdministrator>();
    private Organization organization;

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public String getParentUnitNumber() {
        return this.parentUnitNumber;
    }

    public void setParentUnitNumber(String parentUnitNumber) {
        this.parentUnitNumber = parentUnitNumber;
    }

    public String getOrganizationId() {
        if (this.organizationId == null && this.getParentUnit() != null && this.getParentUnit().getUnitNumber() != null) {
            return this.getParentUnit().getOrganizationId();
        }
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Organization getOrganization() {
        if (this.organization == null && this.getParentUnit() != null && this.getParentUnit().getUnitNumber() != null) {
            return this.getParentUnit().getOrganization();
        }
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public Unit getParentUnit() {
        return this.parentUnit;
    }

    public void setParentUnit(Unit parentUnit) {
        this.parentUnit = parentUnit;
    }

    public List<UnitAdministrator> getUnitAdministrators() {
        if (this.unitAdministrators != null) {
            Collections.sort(this.unitAdministrators);
        }
        return this.unitAdministrators;
    }

    public void setUnitAdministrators(List<UnitAdministrator> unitAdministrators) {
        this.unitAdministrators = unitAdministrators;
    }

    public String getOrganizationIdForMaintenance() {
        return this.organizationId;
    }

    public void setOrganizationIdForMaintenance(String organizationIdForMaintenance) {
        this.organizationId = organizationIdForMaintenance;
    }

    public boolean isParentUnit(Unit parentCandidate) {
        if (this.getParentUnitNumber() != null) {
            if (this.getParentUnitNumber().equals(parentCandidate.getUnitNumber())) {
                return true;
            }
            return this.getParentUnit().isParentUnit(parentCandidate);
        }
        return false;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getUnitAdministrators());
        return managedLists;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.unitNumber == null ? 0 : this.unitNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Unit)) {
            return false;
        }
        Unit other = (Unit)((Object)obj);
        return !(this.unitNumber == null ? other.unitNumber != null : !this.unitNumber.equals(other.unitNumber));
    }
}

