/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitCorrespondent;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.correspondence.CorrespondentType;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.service.BusinessObjectService;

public class UnitCorrespondentMaintainableImpl
extends KraMaintainableImpl
implements Maintainable {
    private static final long serialVersionUID = -158475500509336068L;
    private static final String KIM_PERSON_LOOKUPABLE_REFRESH_CALLER = "kimPersonLookupable";
    private static final String UNIT_ID_INVALID_ERROR_KEY = "error.invalid.unitAdministrator.unitId";
    private static final String PRINCIPAL_ID_INVALID_ERROR_KEY = "error.invalid.unitAdministrator.principalId";
    private static final String CORRESPONDENT_TYPE_CODE_INVALID_ERROR_KEY = "error.invalid.unitCorrespondent.correspondentType";

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        if (KIM_PERSON_LOOKUPABLE_REFRESH_CALLER.equals(refreshCaller)) {
            UnitCorrespondent unitCorrespondent = (UnitCorrespondent)this.getBusinessObject();
            String principalId = (String)fieldValues.get("principalId");
            unitCorrespondent.setPersonId(principalId);
        }
    }

    @Override
    public void prepareForSave() {
        UnitCorrespondent unitCorrespondent = (UnitCorrespondent)this.businessObject;
        if (!this.isUnitIdValid(unitCorrespondent.getUnitNumber())) {
            this.reportInvalidUnitId(unitCorrespondent);
        }
        if (!this.isCorrespondentTypeCodeValid(unitCorrespondent.getCorrespondentTypeCode())) {
            this.reportInvalidCorrespondentTypeCode(unitCorrespondent);
        }
        if (!this.isValidPrincipalId(unitCorrespondent.getPersonId())) {
            this.reportInvalidPrincipalId(unitCorrespondent);
        }
        super.prepareForSave();
    }

    private void reportInvalidUnitId(UnitCorrespondent unitCorrespondent) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.unitNumber", UNIT_ID_INVALID_ERROR_KEY, new String[0]);
    }

    private void reportInvalidPrincipalId(UnitCorrespondent unitCorrespondent) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.person.userName", PRINCIPAL_ID_INVALID_ERROR_KEY, new String[0]);
    }

    private void reportInvalidCorrespondentTypeCode(UnitCorrespondent unitCorrespondent) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.correspondentTypeCode", CORRESPONDENT_TYPE_CODE_INVALID_ERROR_KEY, new String[0]);
    }

    private boolean isValidPrincipalId(String principalId) {
        boolean valid = true;
        KcPersonService personService = KraServiceLocator.getService(KcPersonService.class);
        if (StringUtils.isEmpty((String)principalId)) {
            valid = false;
        } else {
            KcPerson person = personService.getKcPersonByPersonId(principalId);
            if (person == null) {
                valid = false;
            }
        }
        return valid;
    }

    private boolean isUnitIdValid(String unitNumber) {
        BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> validParams = new HashMap<String, String>();
        validParams.put("unitNumber", unitNumber);
        return !businessObjectService.findMatching(Unit.class, validParams).isEmpty();
    }

    private boolean isCorrespondentTypeCodeValid(Integer correspondentTypeCode) {
        BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> validParams = new HashMap<String, String>();
        validParams.put("correspondentTypeCode", correspondentTypeCode.toString());
        return !businessObjectService.findMatching(CorrespondentType.class, validParams).isEmpty();
    }
}

