/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo.versioning;

import java.sql.Date;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.rice.krad.util.ObjectUtils;

public class VersionHistory
extends KraPersistableBusinessObjectBase {
    private static final long serialVersionUID = -4851728455206181532L;
    private Long versionHistoryId;
    private String sequenceOwnerClassName;
    private String sequenceOwnerVersionNameField;
    private String sequenceOwnerVersionNameValue;
    private Integer sequenceOwnerSequenceNumber;
    private String statusForOjb;
    private String userId;
    private Date versionDate;
    private transient VersionStatus status;
    private transient SequenceOwner<? extends SequenceOwner<?>> sequenceOwner;

    public VersionHistory() {
    }

    public VersionHistory(SequenceOwner<? extends SequenceOwner<?>> sequenceOwner, VersionStatus status, String userId, Date versionDate) {
        this.setSequenceOwner(sequenceOwner);
        if (sequenceOwner != null) {
            this.setSequenceOwnerSequenceNumber(sequenceOwner.getSequenceNumber());
            this.setSequenceOwnerClassName(sequenceOwner.getClass().getName());
            this.setSequenceOwnerVersionNameField(sequenceOwner.getVersionNameField());
            this.setSequenceOwnerVersionNameValue(ObjectUtils.getPropertyValue(sequenceOwner, (String)sequenceOwner.getVersionNameField()).toString());
        }
        this.setStatus(status);
        this.setUserId(userId);
        this.setVersionDate(versionDate);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sequenceOwnerClassName == null ? 0 : this.sequenceOwnerClassName.hashCode());
        result = 31 * result + (this.sequenceOwnerSequenceNumber == null ? 0 : this.sequenceOwnerSequenceNumber.hashCode());
        result = 31 * result + (this.sequenceOwnerVersionNameValue == null ? 0 : this.sequenceOwnerVersionNameValue.hashCode());
        result = 31 * result + (this.statusForOjb == null ? 0 : this.statusForOjb.hashCode());
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        result = 31 * result + (this.versionDate == null ? 0 : this.versionDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionHistory)) {
            return false;
        }
        VersionHistory other = (VersionHistory)((Object)obj);
        if (this.sequenceOwnerClassName == null ? other.sequenceOwnerClassName != null : !this.sequenceOwnerClassName.equals(other.sequenceOwnerClassName)) {
            return false;
        }
        if (this.sequenceOwnerSequenceNumber == null ? other.sequenceOwnerSequenceNumber != null : !this.sequenceOwnerSequenceNumber.equals(other.sequenceOwnerSequenceNumber)) {
            return false;
        }
        if (this.sequenceOwnerVersionNameValue == null ? other.sequenceOwnerVersionNameValue != null : !this.sequenceOwnerVersionNameValue.equals(other.sequenceOwnerVersionNameValue)) {
            return false;
        }
        if (this.statusForOjb == null ? other.statusForOjb != null : !this.statusForOjb.equals(other.statusForOjb)) {
            return false;
        }
        if (this.userId == null ? other.userId != null : !this.userId.equals(other.userId)) {
            return false;
        }
        return !(this.versionDate == null ? other.versionDate != null : !this.versionDate.equals(other.versionDate));
    }

    public SequenceOwner<? extends SequenceOwner<?>> getSequenceOwner() {
        if (this.sequenceOwner == null) {
            try {
                KraServiceLocator.getService(VersionHistoryService.class).loadSequenceOwner(Class.forName(this.getSequenceOwnerClassName()), this);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.sequenceOwner;
    }

    public String getSequenceOwnerClassName() {
        return this.sequenceOwnerClassName;
    }

    public Integer getSequenceOwnerSequenceNumber() {
        return this.sequenceOwnerSequenceNumber;
    }

    public String getSequenceOwnerVersionNameField() {
        return this.sequenceOwnerVersionNameField;
    }

    public String getSequenceOwnerVersionNameValue() {
        return this.sequenceOwnerVersionNameValue;
    }

    public VersionStatus getStatus() {
        if (this.status == null && this.statusForOjb != null) {
            this.status = VersionStatus.valueOf(this.statusForOjb);
        }
        return this.status;
    }

    public String getStatusForOjb() {
        if (this.statusForOjb != null) {
            this.status = VersionStatus.valueOf(this.statusForOjb);
        }
        return this.statusForOjb;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getVersionDate() {
        return this.versionDate;
    }

    public Long getVersionHistoryId() {
        return this.versionHistoryId;
    }

    public boolean isActiveVersion() {
        return this.status == VersionStatus.ACTIVE;
    }

    public void setSequenceOwner(SequenceOwner<? extends SequenceOwner<?>> sequenceOwner) {
        this.sequenceOwner = sequenceOwner;
    }

    public void setSequenceOwnerClassName(String className) {
        this.sequenceOwnerClassName = className;
    }

    public void setSequenceOwnerSequenceNumber(Integer sequenceNumber) {
        this.sequenceOwnerSequenceNumber = sequenceNumber;
    }

    public void setSequenceOwnerVersionNameField(String sequenceOwnerReferenceIdentifierFieldName) {
        this.sequenceOwnerVersionNameField = sequenceOwnerReferenceIdentifierFieldName;
    }

    public void setSequenceOwnerVersionNameValue(String sequenceOwnerVersionNameValue) {
        this.sequenceOwnerVersionNameValue = sequenceOwnerVersionNameValue;
    }

    public void setStatus(VersionStatus status) {
        if (status != null) {
            this.statusForOjb = status.name();
        }
        this.status = status;
    }

    public void setStatusForOjb(String statusForOjb) {
        this.statusForOjb = statusForOjb;
        this.status = statusForOjb != null ? VersionStatus.valueOf(statusForOjb) : null;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setVersionDate(Date versionDate) {
        this.versionDate = versionDate;
    }

    public void setVersionHistoryId(Long versionHistoryId) {
        this.versionHistoryId = versionHistoryId;
    }
}

