/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.calculator;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.commitments.FandaRateType;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.Boundary;
import org.kuali.kra.budget.calculator.BreakUpInterval;
import org.kuali.kra.budget.calculator.BreakupIntervalService;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateAndCost;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.calculator.SalaryCalculator;
import org.kuali.kra.budget.calculator.ValidCalcType;
import org.kuali.kra.budget.calculator.query.And;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.calculator.query.GreaterThan;
import org.kuali.kra.budget.calculator.query.LesserThan;
import org.kuali.kra.budget.calculator.query.NotEquals;
import org.kuali.kra.budget.calculator.query.Operator;
import org.kuali.kra.budget.calculator.query.Or;
import org.kuali.kra.budget.calculator.query.QueryEngine;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemBase;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.rates.AbstractBudgetRate;
import org.kuali.kra.budget.rates.BudgetLaRate;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.budget.rates.ValidCeRateType;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class AbstractBudgetCalculator {
    private static final String UNDER_REECOVERY_RATE_TYPE_CODE = "1";
    private static final Log LOG = LogFactory.getLog(AbstractBudgetCalculator.class);
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    protected Budget budget;
    protected BudgetLineItemBase budgetLineItem;
    private QueryList<BudgetLaRate> lineItemPropLaRates;
    private QueryList<BudgetRate> lineItemPropRates;
    private List<BreakUpInterval> breakupIntervals;
    private QueryList<ValidCeRateType> infltionValidCalcCeRates;
    private QueryList<BudgetRate> underrecoveryRates;
    private QueryList<BudgetRate> inflationRates;
    private BudgetCalculationService budgetCalcultionService;

    public AbstractBudgetCalculator(Budget budget, BudgetLineItemBase budgetLineItem) {
        this.budget = budget;
        this.budgetLineItem = budgetLineItem;
        this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        this.dateTimeService = CoreApiServiceLocator.getDateTimeService();
        this.budgetCalcultionService = KraServiceLocator.getService(BudgetCalculationService.class);
        this.breakupIntervals = new ArrayList<BreakUpInterval>();
    }

    public abstract void populateApplicableCosts(Boundary var1);

    public QueryList filterRates(List rates) {
        String activityTypeCode = this.budget.getBudgetDocument().getParentDocument().getBudgetParent().getActivityTypeCode();
        if (!rates.isEmpty() && rates.get(0) instanceof BudgetRate) {
            QueryList qList = this.filterRates(rates, this.budgetLineItem.getStartDate(), this.budgetLineItem.getEndDate(), activityTypeCode);
            if (qList.isEmpty() && !this.budget.getActivityTypeCode().equals(activityTypeCode)) {
                qList = this.filterRates(rates, this.budgetLineItem.getStartDate(), this.budgetLineItem.getEndDate(), this.budget.getActivityTypeCode());
            }
            return qList;
        }
        return this.filterRates(rates, this.budgetLineItem.getStartDate(), this.budgetLineItem.getEndDate(), null);
    }

    private QueryList filterRates(List rates, Date startDate, Date endDate, String activityTypeCode) {
        QueryList<BudgetRate> filteredRates;
        List lineItemCalcAmts = this.budgetLineItem.getBudgetCalculatedAmounts();
        QueryList qlRates = new QueryList(rates);
        QueryList budgetProposalRates = new QueryList();
        for (AbstractBudgetCalculatedAmount calAmtsBean : lineItemCalcAmts) {
            Equals equalsOnOff;
            String rateTypeCode;
            Equals equalsRT;
            String rateClassCode = calAmtsBean.getRateClassCode();
            Equals equalsRC = new Equals("rateClassCode", (Comparable)((Object)rateClassCode));
            And RCandRT = new And(equalsRC, equalsRT = new Equals("rateTypeCode", (Comparable)((Object)(rateTypeCode = calAmtsBean.getRateTypeCode()))));
            And RCRTandOnOff = new And(RCandRT, equalsOnOff = new Equals("onOffCampusFlag", this.budgetLineItem.getOnOffCampusFlag()));
            filteredRates = qlRates.filter(RCRTandOnOff);
            if (filteredRates == null || filteredRates.isEmpty()) continue;
            budgetProposalRates.addAll(qlRates.filter(RCRTandOnOff));
        }
        if (activityTypeCode != null) {
            if (this.infltionValidCalcCeRates != null && !this.infltionValidCalcCeRates.isEmpty()) {
                for (ValidCeRateType inflationValidceRate : this.infltionValidCalcCeRates) {
                    Equals eActType;
                    Equals equalsOnOff;
                    Equals equalsRT;
                    Equals equalsRC = new Equals("rateClassCode", (Comparable)((Object)inflationValidceRate.getRateClassCode()));
                    And RCandRT = new And(equalsRC, equalsRT = new Equals("rateTypeCode", (Comparable)((Object)inflationValidceRate.getRateTypeCode())));
                    And RCRTandOnOff = new And(RCandRT, equalsOnOff = new Equals("onOffCampusFlag", this.budgetLineItem.getOnOffCampusFlag()));
                    And RCRTandOnOffandActType = new And(RCRTandOnOff, eActType = new Equals("activityTypeCode", (Comparable)((Object)activityTypeCode)));
                    filteredRates = qlRates.filter(RCRTandOnOffandActType);
                    if (filteredRates == null || filteredRates.isEmpty()) continue;
                    this.setInflationRates(filteredRates);
                    budgetProposalRates.addAll(filteredRates);
                }
            }
            if (!this.isUndercoveryMatchesOverhead()) {
                Equals equalsRC = new Equals("rateClassCode", (Comparable)((Object)this.budget.getUrRateClassCode()));
                Equals equalsRT = new Equals("rateTypeCode", (Comparable)((Object)UNDER_REECOVERY_RATE_TYPE_CODE));
                Equals equalsOnOff = new Equals("onOffCampusFlag", this.budgetLineItem.getOnOffCampusFlag());
                And RCandRT = new And(equalsRC, equalsRT);
                And RCRTandOnOff = new And(RCandRT, equalsOnOff);
                budgetProposalRates.addAll(qlRates.filter(RCRTandOnOff));
            }
            Equals eActType = new Equals("activityTypeCode", (Comparable)((Object)activityTypeCode));
            budgetProposalRates = budgetProposalRates.filter(eActType);
        }
        if (budgetProposalRates != null && !budgetProposalRates.isEmpty()) {
            LesserThan lesserThan = new LesserThan("startDate", endDate);
            Equals equals = new Equals("startDate", endDate);
            Or or = new Or(lesserThan, equals);
            budgetProposalRates = budgetProposalRates.filter(or);
        }
        return budgetProposalRates;
    }

    private boolean isUndercoveryMatchesOverhead() {
        return this.budget.getOhRateClassCode().equals(this.budget.getUrRateClassCode());
    }

    public void calculate() {
        if (this.budget.getBudgetParent() instanceof DevelopmentProposal && ((DevelopmentProposal)this.budget.getBudgetParent()).isParent()) {
            this.budgetLineItem.setDirectCost(this.budgetLineItem.getLineItemCost());
            this.budgetLineItem.setTotalCostSharingAmount(this.budgetLineItem.getCostSharingAmount());
            this.budgetLineItem.setIndirectCost(BudgetDecimal.ZERO);
            if (this.budgetLineItem instanceof BudgetPersonnelDetails) {
                BudgetPersonnelDetails budgetPersonnelLineItem = (BudgetPersonnelDetails)this.budgetLineItem;
                SalaryCalculator salaryCalculator = new SalaryCalculator(this.budget, budgetPersonnelLineItem);
                salaryCalculator.calculate();
                budgetPersonnelLineItem.setLineItemCost(budgetPersonnelLineItem.getSalaryRequested());
            }
            QueryList calcAmts = new QueryList();
            calcAmts.addAll(this.budgetLineItem.getBudgetCalculatedAmounts());
            for (AbstractBudgetCalculatedAmount calcAmt : calcAmts) {
                calcAmt.refreshReferenceObject("rateClass");
                calcAmt.setRateClassType(calcAmt.getRateClass().getRateClassType());
            }
            NotEquals notEqualsOH = new NotEquals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
            Equals equalsOH = new Equals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
            String calculatedCostString = "calculatedCost";
            this.budgetLineItem.setDirectCost((BudgetDecimal)this.budgetLineItem.getDirectCost().add(calcAmts.sumObjects(calculatedCostString, notEqualsOH)));
            this.budgetLineItem.setIndirectCost((BudgetDecimal)this.budgetLineItem.getIndirectCost().add(calcAmts.sumObjects(calculatedCostString, equalsOH)));
            this.budgetLineItem.setTotalCostSharingAmount((BudgetDecimal)this.budgetLineItem.getTotalCostSharingAmount().add(calcAmts.sumObjects("calculatedCostSharing")));
            return;
        }
        this.budgetLineItem.setDirectCost(this.budgetLineItem.getLineItemCost());
        this.budgetLineItem.setTotalCostSharingAmount(this.budgetLineItem.getCostSharingAmount());
        this.budgetLineItem.setIndirectCost(BudgetDecimal.ZERO);
        this.budgetLineItem.setUnderrecoveryAmount(BudgetDecimal.ZERO);
        this.createAndCalculateBreakupIntervals();
        this.updateBudgetLineItemCalculatedAmounts();
        this.populateBudgetRateBaseList();
    }

    protected abstract void populateBudgetRateBaseList();

    protected void updateBudgetLineItemCalculatedAmounts() {
        List lineItemCalcAmts = this.budgetLineItem.getBudgetCalculatedAmounts();
        List<BreakUpInterval> cvLIBreakupIntervals = this.getBreakupIntervals();
        if (lineItemCalcAmts != null && lineItemCalcAmts.size() > 0 && cvLIBreakupIntervals != null && cvLIBreakupIntervals.size() > 0) {
            String rateClassCode = "0";
            String rateTypeCode = "0";
            BudgetDecimal totalCalculatedCost = BudgetDecimal.ZERO;
            BudgetDecimal totalCalculatedCostSharing = BudgetDecimal.ZERO;
            BudgetDecimal totalUnderRecovery = BudgetDecimal.ZERO;
            BudgetDecimal directCost = BudgetDecimal.ZERO;
            BudgetDecimal indirectCost = BudgetDecimal.ZERO;
            And RCandRT = null;
            QueryList<RateAndCost> cvCombinedAmtDetails = new QueryList<RateAndCost>();
            for (BreakUpInterval brkUpInterval : cvLIBreakupIntervals) {
                cvCombinedAmtDetails.addAll(brkUpInterval.getRateAndCosts());
            }
            for (AbstractBudgetCalculatedAmount calculatedAmount : lineItemCalcAmts) {
                rateClassCode = calculatedAmount.getRateClassCode();
                rateTypeCode = calculatedAmount.getRateTypeCode();
                Equals equalsRC = new Equals("rateClassCode", (Comparable)((Object)rateClassCode));
                Equals equalsRT = new Equals("rateTypeCode", (Comparable)((Object)rateTypeCode));
                RCandRT = new And(equalsRC, equalsRT);
                totalCalculatedCost = cvCombinedAmtDetails.sumObjects("calculatedCost", RCandRT);
                calculatedAmount.setCalculatedCost(totalCalculatedCost);
                totalCalculatedCostSharing = cvCombinedAmtDetails.sumObjects("calculatedCostSharing", RCandRT);
                calculatedAmount.setCalculatedCostSharing(totalCalculatedCostSharing);
            }
            totalUnderRecovery = new QueryList<BreakUpInterval>(cvLIBreakupIntervals).sumObjects("underRecovery");
            this.budgetLineItem.setUnderrecoveryAmount(totalUnderRecovery);
            NotEquals notEqualsOH = new NotEquals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
            boolean directCostRolledUp = false;
            boolean resetTotalUnderRecovery = false;
            BudgetDecimal newTotalUrAmount = BudgetDecimal.ZERO;
            BudgetDecimal newTotalCostSharing = BudgetDecimal.ZERO;
            if (this.budgetLineItem instanceof BudgetLineItem && CollectionUtils.isNotEmpty(((BudgetLineItem)this.budgetLineItem).getBudgetPersonnelDetailsList())) {
                for (BudgetPersonnelDetails budgetPersonnelDetail : ((BudgetLineItem)this.budgetLineItem).getBudgetPersonnelDetailsList()) {
                    List personnelCalAmts = budgetPersonnelDetail.getBudgetCalculatedAmounts();
                    newTotalUrAmount = (BudgetDecimal)newTotalUrAmount.add(budgetPersonnelDetail.getUnderrecoveryAmount());
                    resetTotalUnderRecovery = true;
                    if (!CollectionUtils.isNotEmpty((Collection)personnelCalAmts)) continue;
                    for (BudgetPersonnelCalculatedAmount personnelCalAmt : personnelCalAmts) {
                        if (personnelCalAmt.getRateClass() == null) {
                            personnelCalAmt.refreshReferenceObject("rateClass");
                        }
                        if (!personnelCalAmt.getRateClass().getRateClassType().equals("O")) {
                            directCost = (BudgetDecimal)directCost.add(personnelCalAmt.getCalculatedCost());
                        } else {
                            indirectCost = (BudgetDecimal)indirectCost.add(personnelCalAmt.getCalculatedCost());
                        }
                        newTotalCostSharing = (BudgetDecimal)newTotalCostSharing.add(personnelCalAmt.getCalculatedCostSharing());
                        directCostRolledUp = true;
                    }
                }
            }
            if (resetTotalUnderRecovery) {
                this.budgetLineItem.setUnderrecoveryAmount(newTotalUrAmount);
            }
            if (!directCostRolledUp) {
                directCost = cvCombinedAmtDetails.sumObjects("calculatedCost", notEqualsOH);
            }
            this.budgetLineItem.setDirectCost((BudgetDecimal)directCost.add(this.budgetLineItem.getLineItemCost()));
            Equals equalsOH = new Equals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
            if (!directCostRolledUp) {
                indirectCost = cvCombinedAmtDetails.sumObjects("calculatedCost", equalsOH);
            }
            this.budgetLineItem.setIndirectCost(indirectCost);
            totalCalculatedCostSharing = !directCostRolledUp ? cvCombinedAmtDetails.sumObjects("calculatedCostSharing") : newTotalCostSharing;
            this.budgetLineItem.setTotalCostSharingAmount(this.budgetLineItem.getCostSharingAmount() == null ? totalCalculatedCostSharing : (BudgetDecimal)this.budgetLineItem.getCostSharingAmount().add(totalCalculatedCostSharing));
        } else if (lineItemCalcAmts != null && lineItemCalcAmts.size() > 0 && (this.budgetLineItem.getLineItemCost().equals((Object)BudgetDecimal.ZERO) || CollectionUtils.isEmpty(cvLIBreakupIntervals))) {
            for (AbstractBudgetCalculatedAmount calculatedAmount : lineItemCalcAmts) {
                calculatedAmount.setCalculatedCost(BudgetDecimal.ZERO);
                calculatedAmount.setCalculatedCostSharing(BudgetDecimal.ZERO);
            }
        }
    }

    protected void createAndCalculateBreakupIntervals() {
        this.populateCalculatedAmountLineItems();
        this.setQlLineItemPropLaRates(this.filterRates(this.budget.getBudgetLaRates()));
        this.setQlLineItemPropRates(this.filterRates(this.budget.getBudgetRates()));
        this.createBreakUpInterval();
        this.calculateBreakUpInterval();
    }

    protected void createBreakUpInterval() {
        String messageTemplate = "";
        String multipleRatesMesgTemplate = "";
        String message = "";
        if (this.breakupIntervals == null) {
            this.breakupIntervals = new ArrayList<BreakUpInterval>();
        }
        if (this.budgetLineItem.getOnOffCampusFlag().booleanValue()) {
            messageTemplate = "On-Campus rate information not available for Rate Class - '";
            multipleRatesMesgTemplate = "Multiple On-Campus rates found for the period ";
        } else {
            messageTemplate = "Off-Campus rate information not available for Rate Class - '";
            multipleRatesMesgTemplate = "Multiple Off-Campus rates found for the period ";
        }
        QueryList<BudgetLaRate> qlLineItemPropLaRates = this.getQlLineItemPropLaRates();
        QueryList<BudgetRate> qlLineItemPropRates = this.getQlLineItemPropRates();
        QueryList<AbstractBudgetRate> qlCombinedRates = new QueryList<AbstractBudgetRate>();
        qlCombinedRates.addAll(qlLineItemPropRates);
        qlCombinedRates.addAll(qlLineItemPropLaRates);
        qlCombinedRates.sort("startDate", true);
        Date liStartDate = this.budgetLineItem.getStartDate();
        Date liEndDate = this.budgetLineItem.getEndDate();
        List<Boundary> boundaries = this.createBreakupBoundaries(qlCombinedRates, liStartDate, liEndDate);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM-dd-yyyy");
        if (boundaries != null && boundaries.size() > 0) {
            for (Boundary boundary : boundaries) {
                Equals equalsEndDate;
                LesserThan ltEndDate;
                Or ltEndDateOrEqEndDate;
                Equals equalsOnOff;
                Equals equalsRT;
                Equals equalsRC;
                And RCandRT;
                And RCRTandOnOff;
                QueryList<BudgetRate> qlUnderRecoveryRates;
                BreakUpInterval breakUpInterval = new BreakUpInterval();
                breakUpInterval.setBoundary(boundary);
                breakUpInterval.setBudgetId(this.budgetLineItem.getBudgetId());
                breakUpInterval.setBudgetPeriod(this.budgetLineItem.getBudgetPeriod());
                breakUpInterval.setLineItemNumber(this.budgetLineItem.getLineItemNumber());
                QueryList<RateAndCost> qlRateAndCosts = new QueryList<RateAndCost>();
                QueryList<BudgetRate> qlBreakupPropRates = new QueryList<BudgetRate>();
                QueryList<BudgetLaRate> qlBreakupPropLARates = new QueryList<BudgetLaRate>();
                QueryList<Object> qlTempRates = new QueryList();
                QueryList<Object> qlMultipleRates = new QueryList();
                this.populateApplicableCosts(boundary);
                breakUpInterval.setApplicableAmt(boundary.getApplicableCost());
                breakUpInterval.setApplicableAmtCostSharing(boundary.getApplicableCostSharing());
                List qlLineItemCalcAmts = this.budgetLineItem.getBudgetCalculatedAmounts();
                ArrayList<String> warningMessages = new ArrayList<String>();
                for (AbstractBudgetCalculatedAmount budgetLineItemCalculatedAmount : qlLineItemCalcAmts) {
                    budgetLineItemCalculatedAmount.refreshNonUpdateableReferences();
                    Boolean applyRateFlag = budgetLineItemCalculatedAmount.getApplyRateFlag();
                    String rateClassCode = budgetLineItemCalculatedAmount.getRateClassCode();
                    String rateTypeCode = budgetLineItemCalculatedAmount.getRateTypeCode();
                    budgetLineItemCalculatedAmount.refreshReferenceObject("rateClass");
                    String rateClassType = budgetLineItemCalculatedAmount.getRateClass().getRateClassType();
                    message = messageTemplate + budgetLineItemCalculatedAmount.getRateClass().getDescription() + "'  Rate Type - '" + budgetLineItemCalculatedAmount.getRateTypeDescription() + "' for Period - ";
                    if ((applyRateFlag == null || !applyRateFlag.booleanValue()) && !rateClassType.equals(RateClassType.OVERHEAD.getRateClassType())) continue;
                    RateAndCost rateCost = new RateAndCost();
                    rateCost.setApplyRateFlag(applyRateFlag);
                    rateCost.setRateClassType(rateClassType);
                    rateCost.setRateClassCode(rateClassCode);
                    rateCost.setRateTypeCode(rateTypeCode);
                    rateCost.setCalculatedCost(BudgetDecimal.ZERO);
                    rateCost.setCalculatedCostSharing(BudgetDecimal.ZERO);
                    qlRateAndCosts.add(rateCost);
                    Equals equalsRC2 = new Equals("rateClassCode", (Comparable)((Object)rateClassCode));
                    Equals equalsRT2 = new Equals("rateTypeCode", (Comparable)((Object)rateTypeCode));
                    LesserThan ltEndDate2 = new LesserThan("startDate", boundary.getEndDate());
                    Equals equalsEndDate2 = new Equals("startDate", boundary.getEndDate());
                    GreaterThan gtStartDate = new GreaterThan("startDate", boundary.getStartDate());
                    Equals equalsStartDate = new Equals("startDate", boundary.getStartDate());
                    Or gtStartDateOrEqStartDate = new Or(gtStartDate, equalsStartDate);
                    Or ltEndDateOrEqEndDate2 = new Or(ltEndDate2, equalsEndDate2);
                    And gtOrEqStartDateAndltOrEqEndDate = new And(gtStartDateOrEqStartDate, ltEndDateOrEqEndDate2);
                    And RCandRT2 = new And(equalsRC2, equalsRT2);
                    And RCRTandLtStartDate = new And(RCandRT2, ltEndDateOrEqEndDate2);
                    And RCRTandgtStartDateAndltEndDate = new And(RCandRT2, gtOrEqStartDateAndltOrEqEndDate);
                    if (rateClassType.equalsIgnoreCase(RateClassType.LAB_ALLOCATION.getRateClassType()) || rateClassType.equalsIgnoreCase(RateClassType.LA_SALARIES.getRateClassType())) {
                        qlTempRates = qlLineItemPropLaRates.filter(RCRTandLtStartDate);
                        if (qlTempRates != null && qlTempRates.size() > 0) {
                            QueryList<BudgetLaRate> cvMultipleRates = qlLineItemPropLaRates.filter(RCRTandgtStartDateAndltEndDate);
                            if (qlMultipleRates != null && qlMultipleRates.size() > 1) {
                                message = multipleRatesMesgTemplate + simpleDateFormat.format(boundary.getStartDate()) + " to " + simpleDateFormat.format(boundary.getEndDate()) + " for Rate Class - '" + budgetLineItemCalculatedAmount.getRateClass().getDescription() + "'  Rate Type - '" + budgetLineItemCalculatedAmount.getRateTypeDescription();
                                warningMessages.add(message);
                                continue;
                            }
                            qlTempRates.sort("startDate", false);
                            BudgetLaRate tempPropLaRate = (BudgetLaRate)qlTempRates.get(0);
                            qlBreakupPropLARates.add(tempPropLaRate);
                            continue;
                        }
                        message = message + simpleDateFormat.format(boundary.getStartDate()) + " to " + simpleDateFormat.format(boundary.getEndDate());
                        warningMessages.add(message);
                        continue;
                    }
                    qlTempRates = qlLineItemPropRates.filter(RCRTandLtStartDate);
                    if (qlTempRates != null && qlTempRates.size() > 0) {
                        qlMultipleRates = qlLineItemPropRates.filter(RCRTandgtStartDateAndltEndDate);
                        if (qlMultipleRates != null && qlMultipleRates.size() > 1) {
                            message = multipleRatesMesgTemplate + simpleDateFormat.format(boundary.getStartDate()) + " to " + simpleDateFormat.format(boundary.getEndDate()) + " for Rate Class - '" + budgetLineItemCalculatedAmount.getRateClass().getDescription() + "'  Rate Type - '" + budgetLineItemCalculatedAmount.getRateTypeDescription();
                            warningMessages.add(message);
                            continue;
                        }
                        qlTempRates.sort("startDate", false);
                        qlBreakupPropRates.add((BudgetRate)qlTempRates.get(0));
                        continue;
                    }
                    message = message + simpleDateFormat.format(boundary.getStartDate()) + " to " + simpleDateFormat.format(boundary.getEndDate());
                    warningMessages.add(message);
                }
                if (qlRateAndCosts != null && qlRateAndCosts.size() > 0) {
                    breakUpInterval.setRateAndCosts(qlRateAndCosts);
                    breakUpInterval.setBudgetProposalRates(qlBreakupPropRates);
                    breakUpInterval.setBudgetProposalLaRates(qlBreakupPropLARates);
                    this.breakupIntervals.add(breakUpInterval);
                }
                if (this.isUndercoveryMatchesOverhead() || !this.hasValidUnderRecoveryRate() || (qlUnderRecoveryRates = qlLineItemPropRates.filter(RCRTandOnOff = new And(RCandRT = new And(equalsRC = new Equals("rateClassCode", (Comparable)((Object)this.budget.getUrRateClassCode())), equalsRT = new Equals("rateTypeCode", (Comparable)((Object)UNDER_REECOVERY_RATE_TYPE_CODE))), equalsOnOff = new Equals("onOffCampusFlag", this.budgetLineItem.getOnOffCampusFlag())))) == null || qlUnderRecoveryRates.size() <= 0 || (qlTempRates = qlUnderRecoveryRates.filter(ltEndDateOrEqEndDate = new Or(ltEndDate = new LesserThan("startDate", boundary.getEndDate()), equalsEndDate = new Equals("startDate", boundary.getEndDate())))) == null || qlTempRates.size() <= 0) continue;
                qlTempRates.sort("startDate", false);
                breakUpInterval.setURRatesBean((BudgetRate)qlTempRates.get(0));
            }
        }
    }

    private boolean hasValidUnderRecoveryRate() {
        QueryList<ValidCeRateType> validCeRateTypes;
        Equals equalsRC = new Equals("rateClassCode", (Comparable)((Object)this.budget.getUrRateClassCode()));
        Equals equalsRT = new Equals("rateTypeCode", (Comparable)((Object)UNDER_REECOVERY_RATE_TYPE_CODE));
        Equals equalsRCT = new Equals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
        And RCandRT = new And(equalsRC, equalsRT);
        And RCRTandRCT = new And(RCandRT, equalsRCT);
        if (this.budgetLineItem.getCostElementBO() != null && this.budgetLineItem.getCostElementBO().getValidCeRateTypes().isEmpty()) {
            this.budgetLineItem.getCostElementBO().refreshReferenceObject("validCeRateTypes");
        }
        return !(validCeRateTypes = new QueryList<ValidCeRateType>(this.budgetLineItem.getCostElementBO().getValidCeRateTypes())).filter(RCRTandRCT).isEmpty();
    }

    public List<Boundary> createBreakupBoundaries(QueryList<AbstractBudgetRate> qlCombinedRates, Date liStartDate, Date liEndDate) {
        ArrayList<Boundary> boundaries = new ArrayList<Boundary>();
        if (qlCombinedRates != null && qlCombinedRates.size() > 0) {
            Boundary boundary;
            Date tempStartDate = liStartDate;
            Date tempEndDate = liEndDate;
            GreaterThan greaterThan = new GreaterThan("startDate", liStartDate);
            qlCombinedRates = qlCombinedRates.filter(greaterThan);
            qlCombinedRates.sort("startDate", true);
            for (AbstractBudgetRate laRate : qlCombinedRates) {
                Date rateChangeDate = laRate.getStartDate();
                if (!rateChangeDate.after(tempStartDate)) continue;
                Calendar temEndCal = this.dateTimeService.getCalendar((java.util.Date)rateChangeDate);
                temEndCal.add(5, -1);
                try {
                    tempEndDate = this.dateTimeService.convertToSqlDate(temEndCal.get(1) + "-" + (temEndCal.get(2) + 1) + "-" + temEndCal.get(5));
                }
                catch (ParseException e) {
                    tempEndDate = new Date(rateChangeDate.getTime() - 86400000L);
                }
                Boundary boundary2 = new Boundary(tempStartDate, tempEndDate);
                boundaries.add(boundary2);
                tempStartDate = rateChangeDate;
            }
            if (boundaries.size() > 0) {
                boundary = new Boundary(tempStartDate, liEndDate);
                boundaries.add(boundary);
            }
            if (boundaries.size() == 0) {
                boundary = new Boundary(liStartDate, liEndDate);
                boundaries.add(boundary);
            }
        }
        return boundaries;
    }

    protected void calculateBreakUpInterval() {
        int rateNumber = 0;
        List<BreakUpInterval> cvLIBreakupIntervals = this.getBreakupIntervals();
        for (BreakUpInterval breakUpInterval : cvLIBreakupIntervals) {
            breakUpInterval.setRateNumber(rateNumber);
            this.getBreakupIntervalService().calculate(breakUpInterval);
        }
    }

    private BreakupIntervalService getBreakupIntervalService() {
        return KraServiceLocator.getService(BreakupIntervalService.class);
    }

    protected List<ValidCalcType> getValidCalcTypes() {
        return (List)this.businessObjectService.findAll(ValidCalcType.class);
    }

    protected abstract void populateCalculatedAmountLineItems();

    private CostElement getCostElementForLineItem(BudgetLineItemBase lineItem) {
        HashMap<String, String> costElementQMap = new HashMap<String, String>();
        costElementQMap.put("costElement", lineItem.getCostElement());
        return (CostElement)this.businessObjectService.findByPrimaryKey(CostElement.class, costElementQMap);
    }

    private <T> QueryList<T> createQueryList(List<T> immutableList) {
        if (immutableList == null) {
            return new QueryList();
        }
        return new QueryList<T>(immutableList);
    }

    private void setInflationRateOnLineItem(BudgetLineItemBase lineItem) {
        QueryList<ValidCeRateType> qValidCeRateTypes = this.createQueryList(this.budgetLineItem.getCostElementBO().getValidCeRateTypes());
        QueryList<ValidCeRateType> inflationValidCeRates = qValidCeRateTypes.filter(new Equals("rateClassType", (Comparable)((Object)RateClassType.INFLATION.getRateClassType())));
        if (!inflationValidCeRates.isEmpty()) {
            if (lineItem.getApplyInRateFlag().booleanValue()) {
                this.setInfltionValidCalcCeRates(inflationValidCeRates);
            }
        } else {
            lineItem.setApplyInRateFlag(false);
        }
    }

    private Equals equalsOverHeadRateClassType() {
        return new Equals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
    }

    private NotEquals notEqualsInflationRateClassType() {
        return new NotEquals("rateClassType", (Comparable)((Object)RateClassType.INFLATION.getRateClassType()));
    }

    private Equals equalsOverHeadRateClassCode() {
        return new Equals("rateClassCode", (Comparable)((Object)("" + this.budget.getOhRateClassCode())));
    }

    private NotEquals notEqualsOverHeadRateClassType() {
        return new NotEquals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType()));
    }

    private And notEqualsLabAllocationRateClassType() {
        return new NotEquals("rateClassType", (Comparable)((Object)RateClassType.LAB_ALLOCATION.getRateClassType())).and(new NotEquals("rateClassType", (Comparable)((Object)RateClassType.LA_SALARIES.getRateClassType())));
    }

    private void setValidCeRateTypeCalculatedAmounts(BudgetLineItemBase lineItem) {
        QueryList<ValidCeRateType> qValidCeRateTypes = this.createQueryList(this.budgetLineItem.getCostElementBO().getValidCeRateTypes());
        qValidCeRateTypes = qValidCeRateTypes.filter(this.equalsOverHeadRateClassType().and(this.equalsOverHeadRateClassCode()).or(this.notEqualsOverHeadRateClassType()).and(this.notEqualsInflationRateClassType()));
        List<BudgetLaRate> budgetLaRates = this.budget.getBudgetLaRates();
        if (budgetLaRates == null || budgetLaRates.size() == 0) {
            qValidCeRateTypes = qValidCeRateTypes.filter(this.notEqualsLabAllocationRateClassType());
        }
        this.addBudgetLineItemCalculatedAmountsForRateTypes(qValidCeRateTypes);
    }

    private void addBudgetLineItemCalculatedAmountsForRateTypes(List<ValidCeRateType> rateTypes) {
        if (CollectionUtils.isEmpty(rateTypes)) {
            return;
        }
        for (ValidCeRateType validCeRateType : rateTypes) {
            validCeRateType.refreshNonUpdateableReferences();
            String rateClassType = validCeRateType.getRateClass().getRateClassType();
            if (rateClassType.equals(RateClassType.OVERHEAD.getRateClassType()) && !Boolean.valueOf(this.budget.getBudgetDocument().getProposalBudgetFlag()).booleanValue()) {
                this.addOHBudgetLineItemCalculatedAmountForAward(validCeRateType.getRateClassCode(), validCeRateType.getRateType(), validCeRateType.getRateClass().getRateClassType());
                continue;
            }
            this.addBudgetLineItemCalculatedAmount(validCeRateType.getRateClassCode(), validCeRateType.getRateType(), validCeRateType.getRateClass().getRateClassType());
        }
    }

    private void addOHBudgetLineItemCalculatedAmountForAward(String rateClassCode, RateType rateType, String rateClassType) {
        Equals eqOhRateClassOnCampusFlag;
        Equals eqOhRateClassType;
        And eqRateClassTypeAndOhCampusFlag;
        QueryList<BudgetRate> budgetRates = new QueryList<BudgetRate>(this.budget.getBudgetRates());
        QueryList<BudgetRate> filteredBudgetRates = budgetRates.filter(eqRateClassTypeAndOhCampusFlag = new And(eqOhRateClassType = new Equals("rateClassType", (Comparable)((Object)rateClassType)), eqOhRateClassOnCampusFlag = new Equals("onOffCampusFlag", this.budgetLineItem.getOnOffCampusFlag())));
        if (!filteredBudgetRates.isEmpty()) {
            BudgetRate awardBudgetRate = (BudgetRate)filteredBudgetRates.get(0);
            awardBudgetRate.setBudget(this.budget);
            if (awardBudgetRate.getNonEditableRateFlag()) {
                AbstractBudgetCalculatedAmount budgetCalculatedAmount = this.getNewCalculatedAmountInstance();
                budgetCalculatedAmount.setBudgetId(this.budgetLineItem.getBudgetId());
                budgetCalculatedAmount.setBudgetPeriod(this.budgetLineItem.getBudgetPeriod());
                budgetCalculatedAmount.setBudgetPeriodId(this.budgetLineItem.getBudgetPeriodId());
                budgetCalculatedAmount.setLineItemNumber(this.budgetLineItem.getLineItemNumber());
                budgetCalculatedAmount.setRateClassType(rateClassType);
                budgetCalculatedAmount.setRateClassCode(awardBudgetRate.getRateClassCode());
                budgetCalculatedAmount.setRateTypeCode(awardBudgetRate.getRateTypeCode());
                budgetCalculatedAmount.setApplyRateFlag(true);
                budgetCalculatedAmount.setRateTypeDescription(this.getAwardRateTypeDescription(awardBudgetRate.getRateTypeCode()));
                budgetCalculatedAmount.setRateClass(awardBudgetRate.getRateClass());
                this.addCalculatedAmount(budgetCalculatedAmount);
            } else {
                this.addBudgetLineItemCalculatedAmount(rateClassCode, rateType, rateClassType);
            }
        }
    }

    private String getAwardRateTypeDescription(String rateTypeCode) {
        return ((FandaRateType)this.getBusinessObjectService().findBySinglePrimaryKey(FandaRateType.class, (Object)rateTypeCode)).getDescription();
    }

    private Equals equalsEmployeeBenefitsRateClassType() {
        return new Equals("rateClassType", (Comparable)((Object)RateClassType.EMPLOYEE_BENEFITS.getRateClassType()));
    }

    private Equals equalsVacationRateClassType() {
        return new Equals("rateClassType", (Comparable)((Object)RateClassType.VACATION.getRateClassType()));
    }

    private Equals equalsLabAllocationSalariesRateClassType() {
        return new Equals("rateClassType", (Comparable)((Object)RateClassType.LA_SALARIES.getRateClassType()));
    }

    private void setLabAllocationSalariesCalculatedAmounts(BudgetLineItemBase lineItem) {
        QueryEngine queryEngine = new QueryEngine();
        queryEngine.addDataCollection(ValidCalcType.class, this.getValidCalcTypes());
        QueryList<ValidCeRateType> qValidCeRateTypes = this.createQueryList(this.budgetLineItem.getCostElementBO().getValidCeRateTypes());
        QueryList<ValidCeRateType> qLabAllocSalRates = qValidCeRateTypes.filter(this.equalsLabAllocationSalariesRateClassType());
        if (CollectionUtils.isNotEmpty(qLabAllocSalRates)) {
            ValidCalcType validCalcType;
            QueryList validCalCTypes = queryEngine.executeQuery(ValidCalcType.class, (Operator)this.equalsEmployeeBenefitsRateClassType());
            if (CollectionUtils.isNotEmpty((Collection)validCalCTypes) && (validCalcType = (ValidCalcType)((Object)validCalCTypes.get(0))).getDependentRateClassType().equals(RateClassType.LA_SALARIES.getRateClassType())) {
                this.addBudgetLineItemCalculatedAmount(validCalcType.getRateClassCode(), validCalcType.getRateType(), validCalcType.getRateClassType());
            }
            if (!(validCalCTypes = queryEngine.executeQuery(ValidCalcType.class, (Operator)this.equalsVacationRateClassType())).isEmpty() && (validCalcType = (ValidCalcType)((Object)validCalCTypes.get(0))).getDependentRateClassType().equals(RateClassType.LA_SALARIES.getRateClassType())) {
                this.addBudgetLineItemCalculatedAmount(validCalcType.getRateClassCode(), validCalcType.getRateType(), validCalcType.getRateClassType());
            }
        }
    }

    public final void setCalculatedAmounts(Budget budget, BudgetLineItemBase budgetLineItem) {
        QueryEngine queryEngine = new QueryEngine();
        Object budgetLineItemCalculatedAmt = null;
        budgetLineItem.setCostElementBO(this.getCostElementForLineItem(budgetLineItem));
        HashMap<String, String> validCeQMap = new HashMap<String, String>();
        validCeQMap.put("costElement", budgetLineItem.getCostElement());
        budgetLineItem.getCostElementBO().refreshReferenceObject("validCeRateTypes");
        QueryList<ValidCeRateType> qValidCeRateTypes = this.createQueryList(budgetLineItem.getCostElementBO().getValidCeRateTypes());
        this.setInflationRateOnLineItem(budgetLineItem);
        this.setValidCeRateTypeCalculatedAmounts(budgetLineItem);
        this.setLabAllocationSalariesCalculatedAmounts(budgetLineItem);
    }

    protected void setInfltionValidCalcCeRates(QueryList<ValidCeRateType> infltionValidCalcCeRates) {
        this.infltionValidCalcCeRates = infltionValidCalcCeRates;
    }

    private void addBudgetLineItemCalculatedAmount(String rateClassCode, RateType rateType, String rateClassType) {
        QueryList<BudgetRate> budgetRates = new QueryList<BudgetRate>(this.budget.getBudgetRates());
        QueryList<BudgetLaRate> qlBudgetLaRates = new QueryList<BudgetLaRate>(this.budget.getBudgetLaRates());
        Equals eqValidRateClassCode = new Equals("rateClassCode", (Comparable)((Object)rateClassCode));
        Equals eqValidRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)rateType.getRateTypeCode()));
        And eqRateClassCodeAndRateTypeCode = new And(eqValidRateClassCode, eqValidRateTypeCode);
        QueryList<BudgetRate> filteredBudgetRates = budgetRates.filter(eqRateClassCodeAndRateTypeCode);
        QueryList<BudgetLaRate> filteredBudgetLaRates = qlBudgetLaRates.filter(eqRateClassCodeAndRateTypeCode);
        if (filteredBudgetRates.isEmpty() && filteredBudgetLaRates.isEmpty()) {
            return;
        }
        AbstractBudgetCalculatedAmount budgetCalculatedAmount = this.getNewCalculatedAmountInstance();
        budgetCalculatedAmount.setBudgetId(this.budgetLineItem.getBudgetId());
        budgetCalculatedAmount.setBudgetPeriod(this.budgetLineItem.getBudgetPeriod());
        budgetCalculatedAmount.setBudgetPeriodId(this.budgetLineItem.getBudgetPeriodId());
        budgetCalculatedAmount.setLineItemNumber(this.budgetLineItem.getLineItemNumber());
        budgetCalculatedAmount.setRateClassType(rateClassType);
        budgetCalculatedAmount.setRateClassCode(rateClassCode);
        budgetCalculatedAmount.setRateTypeCode(rateType.getRateTypeCode());
        budgetCalculatedAmount.setApplyRateFlag(true);
        budgetCalculatedAmount.refreshReferenceObject("rateClass");
        budgetCalculatedAmount.setRateTypeDescription(rateType.getDescription());
        this.addCalculatedAmount(budgetCalculatedAmount);
    }

    protected abstract AbstractBudgetCalculatedAmount getNewCalculatedAmountInstance();

    protected abstract void addCalculatedAmount(AbstractBudgetCalculatedAmount var1);

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected List<BreakUpInterval> getBreakupIntervals() {
        return this.breakupIntervals;
    }

    protected void setBreakupIntervals(List<BreakUpInterval> breakupIntervals) {
        this.breakupIntervals = breakupIntervals;
    }

    protected DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public QueryList<BudgetRate> getUnderrecoveryRates() {
        return this.underrecoveryRates;
    }

    public void setUnderrecoveryRates(QueryList<BudgetRate> underrecoveryRates) {
        this.underrecoveryRates = underrecoveryRates;
    }

    public QueryList<BudgetRate> getInflationRates() {
        return this.inflationRates;
    }

    public void setInflationRates(QueryList<BudgetRate> inflationRates) {
        this.inflationRates = inflationRates;
    }

    public QueryList<BudgetLaRate> getQlLineItemPropLaRates() {
        return this.lineItemPropLaRates;
    }

    public void setQlLineItemPropLaRates(QueryList<BudgetLaRate> qlLineItemPropLaRates) {
        this.lineItemPropLaRates = qlLineItemPropLaRates;
    }

    public QueryList<BudgetRate> getQlLineItemPropRates() {
        return this.lineItemPropRates;
    }

    public void setQlLineItemPropRates(QueryList<BudgetRate> qlLineItemPropRates) {
        this.lineItemPropRates = qlLineItemPropRates;
    }

    protected BudgetForm getBudgetFormFromGlobalVariables() {
        return this.budgetCalcultionService.getBudgetFormFromGlobalVariables();
    }

    protected BudgetRatesService getBudgetRateService() {
        return KraServiceLocator.getService(BudgetRatesService.class);
    }
}

