/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.calculator;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.AbstractBudgetCalculator;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.calculator.query.And;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.calculator.query.GreaterThan;
import org.kuali.kra.budget.calculator.query.LesserThan;
import org.kuali.kra.budget.calculator.query.NotEquals;
import org.kuali.kra.budget.calculator.query.Or;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCommonService;
import org.kuali.kra.budget.core.BudgetCommonServiceFactory;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetRateAndBase;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.BudgetPersonnelRateAndBase;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.ValidCeRateType;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetPeriodCalculator {
    private BudgetCalculationService budgetCalculationService = KraServiceLocator.getService(BudgetCalculationService.class);
    private List<String> errorMessages = new ArrayList<String>();
    private static final Log LOG = LogFactory.getLog(AbstractBudgetCalculator.class);

    public void calculate(Budget budget, BudgetPeriod budgetPeriod) {
        List<BudgetLineItem> cvLineItemDetails = budgetPeriod.getBudgetLineItems();
        budgetPeriod.setTotalDirectCost(BudgetDecimal.ZERO);
        budgetPeriod.setTotalIndirectCost(BudgetDecimal.ZERO);
        budgetPeriod.setCostSharingAmount(BudgetDecimal.ZERO);
        budgetPeriod.setTotalCost(BudgetDecimal.ZERO);
        budgetPeriod.setUnderrecoveryAmount(BudgetDecimal.ZERO);
        for (BudgetLineItem budgetLineItem : cvLineItemDetails) {
            this.budgetCalculationService.calculateBudgetLineItem(budget, budgetLineItem);
            budgetPeriod.setTotalDirectCost((BudgetDecimal)budgetPeriod.getTotalDirectCost().add(budgetLineItem.getDirectCost()));
            budgetPeriod.setTotalIndirectCost((BudgetDecimal)budgetPeriod.getTotalIndirectCost().add(budgetLineItem.getIndirectCost()));
            budgetPeriod.setTotalCost((BudgetDecimal)budgetPeriod.getTotalCost().add(budgetLineItem.getDirectCost().add(budgetLineItem.getIndirectCost())));
            budgetPeriod.setUnderrecoveryAmount((BudgetDecimal)budgetPeriod.getUnderrecoveryAmount().add(budgetLineItem.getUnderrecoveryAmount()));
            budgetPeriod.setCostSharingAmount((BudgetDecimal)budgetPeriod.getCostSharingAmount().add(budgetLineItem.getTotalCostSharingAmount()));
        }
        if (budget.getOhRateClassCode() != null && this.budgetCalculationService.getBudgetFormFromGlobalVariables() != null) {
            this.budgetCalculationService.getBudgetFormFromGlobalVariables().setOhRateClassCodePrevValue(budget.getOhRateClassCode());
        }
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(BudgetParentDocument parentBudgetDocument) {
        return BudgetCommonServiceFactory.createInstance(parentBudgetDocument);
    }

    public void applyToLaterPeriods(Budget budget, BudgetPeriod currentBudgetPeriod, BudgetLineItem currentBudgetLineItem) {
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        BudgetLineItem prevBudgetLineItem = currentBudgetLineItem;
        int periodDuration = KraServiceLocator.getService(DateTimeService.class).dateDiff((java.util.Date)currentBudgetPeriod.getStartDate(), (java.util.Date)currentBudgetPeriod.getEndDate(), false);
        this.budgetCalculationService.calculateBudgetLineItem(budget, currentBudgetLineItem);
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetPeriod() <= currentBudgetPeriod.getBudgetPeriod()) continue;
            QueryList<BudgetLineItem> currentBudgetPeriodLineItems = new QueryList<BudgetLineItem>(budgetPeriod.getBudgetLineItems());
            for (BudgetLineItem budgetLineItemToBeApplied : currentBudgetPeriodLineItems) {
                if (prevBudgetLineItem.getLineItemNumber().equals(budgetLineItemToBeApplied.getBasedOnLineItem())) {
                    budgetLineItemToBeApplied.setApplyInRateFlag(prevBudgetLineItem.getApplyInRateFlag());
                    if (prevBudgetLineItem.getApplyInRateFlag().booleanValue()) {
                        if (budgetLineItemToBeApplied.getBudgetCategory().getBudgetCategoryTypeCode() == "P" && !budgetLineItemToBeApplied.getBudgetPersonnelDetailsList().isEmpty()) {
                            this.errorMessages.add("This line item contains personnel budget details and there is already a line item on period " + budgetPeriod + " based on this line item." + "Cannot apply the changes to later periods.");
                            return;
                        }
                        BudgetDecimal lineItemCost = this.calculateInflation(budget, prevBudgetLineItem, budgetLineItemToBeApplied.getStartDate());
                        if (!budgetLineItemToBeApplied.getCostElement().equals(prevBudgetLineItem.getCostElement())) {
                            budgetLineItemToBeApplied.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                            budgetLineItemToBeApplied.setBudgetCategory(prevBudgetLineItem.getBudgetCategory());
                            budgetLineItemToBeApplied.setStartDate(budgetPeriod.getStartDate());
                            budgetLineItemToBeApplied.setEndDate(budgetPeriod.getEndDate());
                            budgetLineItemToBeApplied.setCostElement(prevBudgetLineItem.getCostElement());
                            budgetLineItemToBeApplied.refreshReferenceObject("costElementBO");
                            budgetLineItemToBeApplied.setBudgetCategoryCode(budgetLineItemToBeApplied.getCostElementBO().getBudgetCategoryCode());
                        }
                        budgetLineItemToBeApplied.setLineItemCost(lineItemCost);
                    } else {
                        budgetLineItemToBeApplied.setLineItemCost(prevBudgetLineItem.getLineItemCost());
                    }
                    budgetLineItemToBeApplied.setCostSharingAmount(prevBudgetLineItem.getCostSharingAmount());
                    budgetLineItemToBeApplied.setLineItemDescription(prevBudgetLineItem.getLineItemDescription());
                    budgetLineItemToBeApplied.setQuantity(prevBudgetLineItem.getQuantity());
                    budgetLineItemToBeApplied.setUnderrecoveryAmount(prevBudgetLineItem.getUnderrecoveryAmount());
                    budgetLineItemToBeApplied.setOnOffCampusFlag(prevBudgetLineItem.getOnOffCampusFlag());
                    this.budgetCalculationService.populateCalculatedAmount(budget, budgetLineItemToBeApplied);
                    for (BudgetLineItemCalculatedAmount prevCalAmts : prevBudgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                        for (BudgetLineItemCalculatedAmount CalAmts : budgetLineItemToBeApplied.getBudgetLineItemCalculatedAmounts()) {
                            if (!prevCalAmts.getRateClassCode().equals(CalAmts.getRateClassCode()) || !prevCalAmts.getRateTypeCode().equals(CalAmts.getRateTypeCode())) continue;
                            CalAmts.setApplyRateFlag(prevCalAmts.getApplyRateFlag());
                        }
                    }
                    this.budgetCalculationService.calculateBudgetLineItem(budget, budgetLineItemToBeApplied);
                    prevBudgetLineItem = budgetLineItemToBeApplied;
                    continue;
                }
                if (!StringUtils.equals((String)currentBudgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (String)"P") || !StringUtils.equals((String)currentBudgetLineItem.getCostElement(), (String)budgetLineItemToBeApplied.getCostElement()) || !StringUtils.equals((String)currentBudgetLineItem.getGroupName(), (String)budgetLineItemToBeApplied.getGroupName())) continue;
                this.errorMessages.add("This line item contains personnel budget details and there is already a line item on period " + budgetPeriod + " for this Object Code \\ Group combination. \n" + "Cannot apply the changes to later periods.");
                return;
            }
            if (prevBudgetLineItem.getBudgetPeriod() >= budgetPeriod.getBudgetPeriod()) continue;
            BudgetLineItem budgetLineItem = (BudgetLineItem)((Object)ObjectUtils.deepCopy((Serializable)((Object)prevBudgetLineItem)));
            budgetLineItem.setBudgetLineItemId(null);
            budgetLineItem.getBudgetCalculatedAmounts().clear();
            budgetLineItem.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
            budgetLineItem.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
            boolean isLeapDateInPeriod = KraServiceLocator.getService(BudgetSummaryService.class).isLeapDaysInPeriod(prevBudgetLineItem.getStartDate(), prevBudgetLineItem.getEndDate());
            int gap = KraServiceLocator.getService(DateTimeService.class).dateDiff((java.util.Date)currentBudgetPeriod.getStartDate(), (java.util.Date)currentBudgetLineItem.getStartDate(), false);
            boolean isLeapDayInGap = KraServiceLocator.getService(BudgetSummaryService.class).isLeapDaysInPeriod(currentBudgetPeriod.getStartDate(), currentBudgetLineItem.getStartDate());
            int lineDuration = KraServiceLocator.getService(DateTimeService.class).dateDiff((java.util.Date)budgetLineItem.getStartDate(), (java.util.Date)budgetLineItem.getEndDate(), false);
            int currentPeriodDuration = KraServiceLocator.getService(DateTimeService.class).dateDiff((java.util.Date)budgetPeriod.getStartDate(), (java.util.Date)budgetPeriod.getEndDate(), false);
            ArrayList<Date> startEndDates = new ArrayList<Date>();
            if (periodDuration == lineDuration || lineDuration > currentPeriodDuration) {
                budgetLineItem.setStartDate(budgetPeriod.getStartDate());
                budgetLineItem.setEndDate(budgetPeriod.getEndDate());
            } else {
                startEndDates.add(0, budgetPeriod.getStartDate());
                startEndDates.add(1, budgetPeriod.getEndDate());
                List<Date> dates = KraServiceLocator.getService(BudgetSummaryService.class).getNewStartEndDates(startEndDates, gap, lineDuration, budgetLineItem.getStartDate(), isLeapDateInPeriod, isLeapDayInGap);
                budgetLineItem.setStartDate(dates.get(0));
                budgetLineItem.setEndDate(dates.get(1));
            }
            budgetLineItem.setBasedOnLineItem(prevBudgetLineItem.getLineItemNumber());
            budgetLineItem.setVersionNumber(null);
            if (prevBudgetLineItem.getApplyInRateFlag().booleanValue()) {
                BudgetDecimal lineItemCost = this.calculateInflation(budget, prevBudgetLineItem, budgetLineItem.getStartDate());
                budgetLineItem.setLineItemCost(lineItemCost);
            }
            lineDuration = KraServiceLocator.getService(DateTimeService.class).dateDiff((java.util.Date)budgetLineItem.getStartDate(), (java.util.Date)budgetLineItem.getEndDate(), false);
            int personnelDuration = 0;
            List<BudgetPersonnelDetails> budgetPersonnelDetails = budgetLineItem.getBudgetPersonnelDetailsList();
            for (BudgetPersonnelDetails budgetPersonnelDetail : budgetPersonnelDetails) {
                isLeapDateInPeriod = KraServiceLocator.getService(BudgetSummaryService.class).isLeapDaysInPeriod(budgetPersonnelDetail.getStartDate(), budgetPersonnelDetail.getEndDate());
                budgetPersonnelDetail.setBudgetPersonnelLineItemId(null);
                budgetPersonnelDetail.getBudgetCalculatedAmounts().clear();
                budgetPersonnelDetail.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                budgetPersonnelDetail.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
                budgetPersonnelDetail.setLineItemSequence(this.getBudgetDocument(budget).getHackedDocumentNextValue("budget.budgetPersonnelDetails.sequenceNumber"));
                personnelDuration = KraServiceLocator.getService(DateTimeService.class).dateDiff((java.util.Date)budgetPersonnelDetail.getStartDate(), (java.util.Date)budgetPersonnelDetail.getEndDate(), false);
                gap = KraServiceLocator.getService(DateTimeService.class).dateDiff((java.util.Date)prevBudgetLineItem.getStartDate(), (java.util.Date)budgetPersonnelDetail.getStartDate(), false);
                isLeapDayInGap = KraServiceLocator.getService(BudgetSummaryService.class).isLeapDaysInPeriod(prevBudgetLineItem.getStartDate(), budgetPersonnelDetail.getStartDate());
                if (periodDuration == personnelDuration || personnelDuration >= lineDuration) {
                    budgetPersonnelDetail.setStartDate(budgetLineItem.getStartDate());
                    budgetPersonnelDetail.setEndDate(budgetLineItem.getEndDate());
                } else {
                    startEndDates.add(0, budgetLineItem.getStartDate());
                    startEndDates.add(1, budgetLineItem.getEndDate());
                    List<Date> dates = KraServiceLocator.getService(BudgetSummaryService.class).getNewStartEndDates(startEndDates, gap, personnelDuration, budgetPersonnelDetail.getStartDate(), isLeapDateInPeriod, isLeapDayInGap);
                    budgetPersonnelDetail.setStartDate(dates.get(0));
                    budgetPersonnelDetail.setEndDate(dates.get(1));
                }
                budgetPersonnelDetail.setVersionNumber(null);
                this.budgetCalculationService.populateCalculatedAmount(budget, budgetPersonnelDetail);
                List<BudgetPersonnelCalculatedAmount> persCalAmounts = budgetPersonnelDetail.getBudgetPersonnelCalculatedAmounts();
                for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : persCalAmounts) {
                    budgetPersonnelCalculatedAmount.setBudgetPersonnelCalculatedAmountId(null);
                    budgetPersonnelCalculatedAmount.setVersionNumber(null);
                }
                List<BudgetPersonnelRateAndBase> perBudgetRateAndBases = budgetPersonnelDetail.getBudgetPersonnelRateAndBaseList();
                for (BudgetPersonnelRateAndBase budgetPersonnelRateAndBase : perBudgetRateAndBases) {
                    budgetPersonnelRateAndBase.setBudgetPersonnelRateAndBaseId(null);
                    budgetPersonnelRateAndBase.setVersionNumber(null);
                }
            }
            List<BudgetRateAndBase> budgetRateAndBases = budgetLineItem.getBudgetRateAndBaseList();
            for (BudgetRateAndBase budgetRateAndBase : budgetRateAndBases) {
                budgetRateAndBase.setBudgetRateAndBaseId(null);
                budgetRateAndBase.setVersionNumber(null);
            }
            budgetPeriod.getBudgetLineItems().add(budgetLineItem);
            this.budgetCalculationService.populateCalculatedAmount(budget, budgetLineItem);
            for (BudgetLineItemCalculatedAmount prevCalAmts : prevBudgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                for (BudgetLineItemCalculatedAmount calAmts : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (!prevCalAmts.getRateClassCode().equals(calAmts.getRateClassCode()) || !prevCalAmts.getRateTypeCode().equals(calAmts.getRateTypeCode())) continue;
                    calAmts.setBudgetLineItemCalculatedAmountId(null);
                    calAmts.setApplyRateFlag(prevCalAmts.getApplyRateFlag());
                    calAmts.setVersionNumber(null);
                }
            }
            this.budgetCalculationService.calculateBudgetLineItem(budget, budgetLineItem);
            prevBudgetLineItem = budgetLineItem;
        }
    }

    private BudgetDocument getBudgetDocument(Budget budget) {
        return budget.getBudgetDocument();
    }

    private BudgetDecimal calculateInflation(Budget budget, BudgetLineItem budgetLineItem, java.util.Date endDate) {
        QueryList<ValidCeRateType> vecValidCERateTypes;
        QueryList<ValidCeRateType> vecCE;
        CostElement costElement = budgetLineItem.getCostElementBO();
        BudgetDecimal lineItemCost = budgetLineItem.getLineItemCost();
        Date startDate = budgetLineItem.getStartDate();
        Equals eqInflation = new Equals("rateClassType", (Comparable)((Object)RateClassType.INFLATION.getRateClassType()));
        if (costElement.getValidCeRateTypes().isEmpty()) {
            costElement.refreshReferenceObject("validCeRateTypes");
        }
        if ((vecCE = (vecValidCERateTypes = new QueryList<ValidCeRateType>(costElement.getValidCeRateTypes())).filter(eqInflation)) != null && vecCE.size() > 0) {
            ValidCeRateType validCERateTypesBean = vecCE.get(0);
            Equals eqRC = new Equals("rateClassCode", (Comparable)((Object)validCERateTypesBean.getRateClassCode()));
            Equals eqRT = new Equals("rateTypeCode", (Comparable)((Object)validCERateTypesBean.getRateTypeCode()));
            GreaterThan gtSD = new GreaterThan("startDate", startDate);
            LesserThan ltED = new LesserThan("startDate", endDate);
            Equals eqED = new Equals("startDate", endDate);
            Or ltEDOrEqED = new Or(ltED, eqED);
            And ltOrEqEDAndGtSD = new And(ltEDOrEqED, gtSD);
            And rcAndRt = new And(eqRC, eqRT);
            And rcAndRtAndLtOrEqEDAndGtSD = new And(rcAndRt, ltOrEqEDAndGtSD);
            QueryList<BudgetRate> vecPropInflationRates = new QueryList<BudgetRate>(budget.getBudgetRates()).filter(rcAndRtAndLtOrEqEDAndGtSD);
            if (!vecPropInflationRates.isEmpty()) {
                vecPropInflationRates.sort("startDate", false);
                BudgetRate proposalRatesBean = this.getCampusMatchedRateBean(budgetLineItem.getOnOffCampusFlag(), vecPropInflationRates);
                if (proposalRatesBean != null) {
                    BudgetDecimal applicableRate = proposalRatesBean.getApplicableRate();
                    lineItemCost = (BudgetDecimal)lineItemCost.add(lineItemCost.percentage(applicableRate));
                }
            }
        }
        return lineItemCost;
    }

    private BudgetRate getCampusMatchedRateBean(boolean onOffCampus, QueryList<BudgetRate> vecPropInflationRates) {
        BudgetRate proposalRatesBean = null;
        for (BudgetRate budgetRate : vecPropInflationRates) {
            if (budgetRate.getOnOffCampusFlag() != onOffCampus) continue;
            proposalRatesBean = budgetRate;
            break;
        }
        return proposalRatesBean;
    }

    private void resetRateClassTypeIfNeeded(List<BudgetLineItemCalculatedAmount> vecCalAmts) {
        for (BudgetLineItemCalculatedAmount calcAmt : vecCalAmts) {
            if (!StringUtils.isEmpty((String)calcAmt.getRateClassType())) continue;
            calcAmt.refreshReferenceObject("rateClass");
            if (calcAmt.getRateClass() == null) continue;
            calcAmt.setRateClassType(calcAmt.getRateClass().getRateClassType());
        }
    }

    public void syncToPeriodDirectCostLimit(Budget budget, BudgetPeriod budgetPeriodBean, BudgetLineItem budgetDetailBean) {
        BudgetDecimal multifactor;
        BudgetDecimal directCostLimit = budgetPeriodBean.getDirectCostLimit();
        if (!this.checkSyncToLimitErrors(budget, budgetDetailBean, directCostLimit)) {
            return;
        }
        this.calculate(budget, budgetPeriodBean);
        BudgetDecimal periodDirectTotal = budgetPeriodBean.getTotalDirectCost();
        directCostLimit = budgetPeriodBean.getDirectCostLimit();
        if (periodDirectTotal == directCostLimit) {
            this.errorMessages.add("total.direct.cost.already.sync");
            return;
        }
        BudgetDecimal difference = (BudgetDecimal)directCostLimit.subtract(periodDirectTotal);
        BudgetDecimal lineItemCost = budgetDetailBean.getLineItemCost();
        if (lineItemCost.equals((Object)BudgetDecimal.ZERO)) {
            budgetDetailBean.setLineItemCost(new BudgetDecimal(10000));
        }
        this.calculate(budget, budgetPeriodBean);
        QueryList<BudgetLineItemCalculatedAmount> vecCalAmts = new QueryList<BudgetLineItemCalculatedAmount>(budgetDetailBean.getBudgetLineItemCalculatedAmounts());
        this.resetRateClassTypeIfNeeded(vecCalAmts);
        BudgetDecimal totalNOHCalcAmount = vecCalAmts.sumObjects("calculatedCost", new NotEquals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType())));
        BudgetDecimal totalCost = (BudgetDecimal)budgetDetailBean.getLineItemCost().add(totalNOHCalcAmount);
        if (!lineItemCost.equals((Object)BudgetDecimal.ZERO)) {
            multifactor = totalCost.divide(lineItemCost);
        } else {
            multifactor = totalCost.divide(new BudgetDecimal(10000));
            budgetDetailBean.setLineItemCost(BudgetDecimal.ZERO);
            this.calculate(budget, budgetPeriodBean);
            totalCost = BudgetDecimal.ZERO;
        }
        if (this.isProposalBudget(budget) && ((BudgetDecimal)totalCost.add(difference)).isLessEqual(BudgetDecimal.ZERO)) {
            this.errorMessages.add("insufficient.amount.to.period.direct.cost.limit.sync");
            return;
        }
        BudgetDecimal newCost = (BudgetDecimal)lineItemCost.add(difference.divide(multifactor));
        budgetDetailBean.setLineItemCost(newCost);
        this.calculate(budget, budgetPeriodBean);
    }

    public void syncToPeriodCostLimit(Budget budget, BudgetPeriod budgetPeriodBean, BudgetLineItem budgetDetailBean) {
        BudgetDecimal multifactor;
        BudgetDecimal costLimit = budgetPeriodBean.getTotalCostLimit();
        if (!this.checkSyncToLimitErrors(budget, budgetDetailBean, costLimit)) {
            return;
        }
        this.calculate(budget, budgetPeriodBean);
        BudgetDecimal periodTotal = budgetPeriodBean.getTotalCost();
        costLimit = budgetPeriodBean.getTotalCostLimit();
        if (periodTotal == costLimit) {
            this.errorMessages.add("total.cost.already.sync");
            return;
        }
        BudgetDecimal difference = (BudgetDecimal)costLimit.subtract(periodTotal);
        BudgetDecimal lineItemCost = budgetDetailBean.getLineItemCost();
        if (lineItemCost.equals((Object)BudgetDecimal.ZERO)) {
            budgetDetailBean.setLineItemCost(new BudgetDecimal(10000));
        }
        this.calculate(budget, budgetPeriodBean);
        QueryList<BudgetLineItemCalculatedAmount> vecCalAmts = new QueryList<BudgetLineItemCalculatedAmount>(budgetDetailBean.getBudgetLineItemCalculatedAmounts());
        this.resetRateClassTypeIfNeeded(vecCalAmts);
        BudgetDecimal totalNOHCalcAmount = vecCalAmts.sumObjects("calculatedCost", new NotEquals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType())));
        BudgetDecimal totalOHCalcAmount = vecCalAmts.sumObjects("calculatedCost", new Equals("rateClassType", (Comparable)((Object)RateClassType.OVERHEAD.getRateClassType())));
        BudgetDecimal totalCost = (BudgetDecimal)((BudgetDecimal)budgetDetailBean.getLineItemCost().add(totalNOHCalcAmount)).add(totalOHCalcAmount);
        if (!lineItemCost.equals((Object)BudgetDecimal.ZERO)) {
            multifactor = totalCost.divide(lineItemCost);
        } else {
            multifactor = totalCost.divide(new BudgetDecimal(10000));
            budgetDetailBean.setLineItemCost(BudgetDecimal.ZERO);
            this.calculate(budget, budgetPeriodBean);
            totalCost = BudgetDecimal.ZERO;
        }
        if (this.isProposalBudget(budget) && ((BudgetDecimal)totalCost.add(difference)).isLessEqual(BudgetDecimal.ZERO)) {
            this.errorMessages.add("insufficient.amount.to.sync");
            return;
        }
        BudgetDecimal newCost = (BudgetDecimal)lineItemCost.add(difference.divide(multifactor));
        budgetDetailBean.setLineItemCost(newCost);
        this.calculate(budget, budgetPeriodBean);
    }

    private boolean checkSyncToLimitErrors(Budget budget, BudgetLineItem budgetDetailBean, BudgetDecimal costLimit) {
        if (budgetDetailBean.getBudgetCategory().getBudgetCategoryTypeCode().equals("P") && !budgetDetailBean.getBudgetPersonnelDetailsList().isEmpty()) {
            this.errorMessages.add("personnelLineItem.exists");
            return false;
        }
        if (this.isProposalBudget(budget) && costLimit.equals((Object)BudgetDecimal.ZERO)) {
            this.errorMessages.add("error.sync.to.zero.limit");
            return false;
        }
        return true;
    }

    private boolean isProposalBudget(Budget budget) {
        return budget.getBudgetDocument().getProposalBudgetFlag().equals("true");
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void setErrorMessages(List<String> errorMessages) {
        this.errorMessages = errorMessages;
    }
}

