/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.calculator;

import java.util.HashMap;
import java.util.List;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.calculator.ValidCalcType;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;

public class FormulaMaker {
    private QueryList<ValidCalcType> validCalcTypes;
    private String ebOnLaRateClassCode;
    private String ebOnLARateTypeCode;
    private String vaOnLARateClassCode;
    private String vaOnLARateTypeCode;
    private BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);

    public FormulaMaker() {
        this.initValidCalcTypes();
        this.sortCalcTypes();
        this.setEBAndVAonLAValues();
    }

    private void initValidCalcTypes() {
        HashMap searchValues = new HashMap();
        List validCalcTypesFromDB = (List)this.businessObjectService.findMatchingOrderBy(ValidCalcType.class, searchValues, "rateClassType", true);
        this.validCalcTypes = new QueryList(validCalcTypesFromDB);
    }

    public void sortCalcTypes() {
        if (this.validCalcTypes != null && this.validCalcTypes.size() > 0) {
            QueryList<Object> elTempCalcTypes = new QueryList<Object>();
            String depRateClassType = "";
            String rateClassType = "";
            for (ValidCalcType validCalcType : this.validCalcTypes) {
                QueryList<Object> filteredVector;
                rateClassType = validCalcType.getRateClassType();
                Equals equals = new Equals("rateClassType", (Comparable)((Object)rateClassType));
                if (elTempCalcTypes != null && elTempCalcTypes.size() > 0 && (filteredVector = elTempCalcTypes.filter(equals)) != null && filteredVector.size() > 0) continue;
                if (validCalcType.getDependentSeqNumber() == 0) {
                    elTempCalcTypes.add((Object)validCalcType);
                    continue;
                }
                depRateClassType = validCalcType.getDependentRateClassType();
                if (depRateClassType == null) continue;
                QueryList<ValidCalcType> matchedRateClassList = this.validCalcTypes.filter(equals);
                for (ValidCalcType matchedRateClass : matchedRateClassList) {
                    depRateClassType = matchedRateClass.getDependentRateClassType();
                    equals = new Equals("rateClassType", (Comparable)((Object)depRateClassType));
                    filteredVector = elTempCalcTypes.filter(equals);
                    if (filteredVector != null && filteredVector.size() > 0) continue;
                    filteredVector = this.validCalcTypes.filter(equals);
                    if (filteredVector != null && filteredVector.size() > 0) {
                        elTempCalcTypes.add(filteredVector.get(0));
                    }
                    elTempCalcTypes.addAll(matchedRateClassList);
                }
            }
            this.validCalcTypes = elTempCalcTypes;
        }
    }

    private void setEBAndVAonLAValues() {
        ValidCalcType validCalcType;
        Equals eqRCType = new Equals("rateClassType", (Comparable)((Object)RateClassType.EMPLOYEE_BENEFITS.getRateClassType()));
        QueryList<ValidCalcType> tempCalcTypes = this.validCalcTypes.filter(eqRCType);
        if (tempCalcTypes.size() > 0) {
            validCalcType = tempCalcTypes.get(0);
            this.ebOnLaRateClassCode = validCalcType.getRateClassCode();
            this.ebOnLARateTypeCode = validCalcType.getRateTypeCode();
        }
        if ((tempCalcTypes = this.validCalcTypes.filter(eqRCType = new Equals("rateClassType", (Comparable)((Object)RateClassType.VACATION.getRateClassType())))).size() > 0) {
            validCalcType = tempCalcTypes.get(0);
            this.vaOnLARateClassCode = validCalcType.getRateClassCode();
            this.vaOnLARateTypeCode = validCalcType.getRateTypeCode();
        }
    }

    public QueryList<ValidCalcType> getValidCalcTypes() {
        return this.validCalcTypes;
    }

    public void setValidCalcTypes(QueryList<ValidCalcType> validCalcTypes) {
        this.validCalcTypes = validCalcTypes;
    }

    public String getEBonLARateClassCode() {
        return this.ebOnLaRateClassCode;
    }

    public void setEBonLARateClassCode(String EBonLARateClassCode) {
        this.ebOnLaRateClassCode = EBonLARateClassCode;
    }

    public String getEBonLARateTypeCode() {
        return this.ebOnLARateTypeCode;
    }

    public void setEBonLARateTypeCode(String EBonLARateTypeCode) {
        this.ebOnLARateTypeCode = EBonLARateTypeCode;
    }

    public String getVAonLARateClassCode() {
        return this.vaOnLARateClassCode;
    }

    public void setVAonLARateClassCode(String VAonLARateClassCode) {
        this.vaOnLARateClassCode = VAonLARateClassCode;
    }

    public String getVAonLARateTypeCode() {
        return this.vaOnLARateTypeCode;
    }

    public void setVAonLARateTypeCode(String VAonLARateTypeCode) {
        this.vaOnLARateTypeCode = VAonLARateTypeCode;
    }
}

