/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.core;

import java.util.Map;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.accesslayer.RowReaderDefaultImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetVersionOverviewExt;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.versions.BudgetVersionOverview;

public class BudgetDocumentRowReaderImpl
extends RowReaderDefaultImpl {
    private static final long serialVersionUID = -633262608528458894L;
    private ClassDescriptor cld;

    public BudgetDocumentRowReaderImpl(ClassDescriptor cld) {
        super(cld);
        this.cld = cld;
    }

    public void readObjectArrayFrom(ResultSetAndStatement rs_stmt, Map row) {
        super.readObjectArrayFrom(rs_stmt, row);
        String parentDocumentTypeCode = (String)row.get("PARENT_DOCUMENT_TYPE_CODE");
        boolean isBudgetDocument = this.cld.getClassNameOfObject().equals(BudgetDocument.class.getName());
        String budgetCollectionName = isBudgetDocument ? "budgets" : "budgetVersionOverviews";
        CollectionDescriptor cd = this.cld.getCollectionDescriptorByName(budgetCollectionName);
        Class<Budget> classDescrClazz = Budget.class;
        if ("PRDV".equals(parentDocumentTypeCode)) {
            Class clazz = classDescrClazz = isBudgetDocument ? Budget.class : BudgetVersionOverview.class;
        }
        if ("AWRD".equals(parentDocumentTypeCode)) {
            classDescrClazz = isBudgetDocument ? AwardBudgetExt.class : AwardBudgetVersionOverviewExt.class;
        }
        cd.setItemClass(classDescrClazz);
    }
}

