/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.core;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCommonService;
import org.kuali.kra.budget.core.BudgetCommonServiceFactory;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.lookup.keyvalue.CostElementValuesFinder;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemBase;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonSalaryDetails;
import org.kuali.kra.budget.personnel.BudgetPersonService;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.ValidCeJobCode;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.rates.ValidCeRateType;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.budget.versions.AddBudgetVersionEvent;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.budget.versions.BudgetVersionRule;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardPeriodDetail;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.service.DeepCopyPostProcessor;
import org.kuali.kra.service.FiscalYearMonthService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentAuditEvent;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetServiceImpl<T extends BudgetParent>
implements BudgetService<T> {
    private static final Log LOG = LogFactory.getLog(BudgetServiceImpl.class);
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private BudgetPersonService budgetPersonService;
    private BudgetRatesService<T> budgetRatesService;
    private PessimisticLockService pessimisticLockService;
    private BudgetVersionRule budgetVersionRule;
    private DeepCopyPostProcessor deepCopyPostProcessor;
    private BudgetSummaryService budgetSummaryService;
    private FiscalYearMonthService fiscalYearMonthService;

    @Override
    public BudgetDocument<T> addBudgetVersion(BudgetParentDocument<T> document, String versionName) throws WorkflowException {
        if (!this.isBudgetVersionNameValid(document, versionName)) {
            BufferedLogger.debug("Buffered Version not Valid");
            return null;
        }
        BudgetDocument<T> newBudgetDoc = this.getNewBudgetVersion(document, versionName);
        if (newBudgetDoc == null) {
            return null;
        }
        return newBudgetDoc;
    }

    protected BudgetDocument<T> getNewBudgetVersion(BudgetParentDocument<T> parentDocument, String versionName) throws WorkflowException {
        BudgetCommonService budgetCommonService = BudgetCommonServiceFactory.createInstance(parentDocument);
        return budgetCommonService.getNewBudgetVersion(parentDocument, versionName);
    }

    @Override
    public boolean isBudgetVersionNameValid(BudgetParentDocument<T> document, String name) {
        BufferedLogger.debug("Invoking budgetrule getBudgetVersionRule()");
        return new AddBudgetVersionEvent((Document)document, name).invokeRuleMethod(this.getBudgetVersionRule());
    }

    public PessimisticLockService getPessimisticLockService() {
        return this.pessimisticLockService;
    }

    public void setPessimisticLockService(PessimisticLockService pessimisticLockService) {
        this.pessimisticLockService = pessimisticLockService;
    }

    public BudgetVersionRule getBudgetVersionRule() {
        return this.budgetVersionRule;
    }

    public void setBudgetVersionRule(BudgetVersionRule budgetVersionRule) {
        this.budgetVersionRule = budgetVersionRule;
    }

    protected void saveBudgetDocument(BudgetDocument<T> budgetDocument) throws WorkflowException {
        Budget budget = budgetDocument.getBudget();
        BudgetParentDocument<T> parentDocument = budgetDocument.getParentDocument();
        boolean isProposalBudget = new Boolean(parentDocument.getProposalBudgetFlag());
        if (!isProposalBudget) {
            AwardBudgetExt budgetExt = (AwardBudgetExt)budget;
            budgetExt.setAwardBudgetStatusCode(this.parameterService.getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetStatusInProgress"));
            budgetExt.setAwardBudgetTypeCode(this.parameterService.getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetTypeNew"));
            this.documentService.saveDocument(budgetDocument);
        } else {
            this.documentService.saveDocument(budgetDocument);
            this.documentService.routeDocument(budgetDocument, "Route to Final", new ArrayList());
        }
    }

    @Override
    public void updateDocumentDescription(BudgetVersionOverview budgetVersion) {
        BusinessObjectService boService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("documentNumber", budgetVersion.getDocumentNumber());
        DocumentHeader docHeader = (DocumentHeader)boService.findByPrimaryKey(DocumentHeader.class, keyMap);
        if (!docHeader.getDocumentDescription().equals(budgetVersion.getDocumentDescription())) {
            docHeader.setDocumentDescription(budgetVersion.getDocumentDescription());
            boService.save((PersistableBusinessObject)docHeader);
        }
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setBudgetPersonService(BudgetPersonService budgetPersonService) {
        this.budgetPersonService = budgetPersonService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected void fixProperty(Object object, String methodName, Class clazz, Object propertyValue, Map<String, Object> objectMap) {
        if (ObjectUtils.isNotNull((Object)object) && object instanceof PersistableBusinessObject) {
            Method[] methods;
            PersistableBusinessObject objectWId = (PersistableBusinessObject)object;
            if (objectMap.get(objectWId.getObjectId()) != null) {
                return;
            }
            objectMap.put(((PersistableBusinessObject)object).getObjectId(), object);
            for (Method method : methods = object.getClass().getMethods()) {
                if (method.getName().equals(methodName)) {
                    if (object instanceof BudgetDocument) continue;
                    try {
                        if (clazz.equals(Long.class)) {
                            method.invoke(object, (Long)propertyValue);
                            continue;
                        }
                        method.invoke(object, (Integer)propertyValue);
                    }
                    catch (Throwable e) {}
                    continue;
                }
                if (!this.isPropertyGetterMethod(method, methods)) continue;
                Object value = null;
                try {
                    value = method.invoke(object, new Object[0]);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (value == null) continue;
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    for (Object entry : c) {
                        this.fixProperty(entry, methodName, clazz, propertyValue, objectMap);
                    }
                    continue;
                }
                this.fixProperty(value, methodName, clazz, propertyValue, objectMap);
            }
        }
    }

    protected boolean isPropertyGetterMethod(Method method, Method[] methods) {
        if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
            String setterName = method.getName().replaceFirst("get", "set");
            for (Method m : methods) {
                if (!m.getName().equals(setterName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<BudgetRate> getSavedBudgetRates(Budget budget) {
        HashMap<String, Long> qMap = new HashMap<String, Long>();
        qMap.put("budgetId", budget.getBudgetId());
        Collection rates = this.businessObjectService.findMatching(BudgetRate.class, qMap);
        for (BudgetRate rate : rates) {
            GregorianCalendar startDate = new GregorianCalendar();
            startDate.setTime(rate.getStartDate());
            Integer newFY = this.getFiscalYearMonthService().getFiscalYearFromDate(startDate);
            rate.setFiscalYear(newFY.toString());
        }
        return rates;
    }

    @Override
    public boolean checkActivityTypeChange(Collection<BudgetRate> allPropRates, String activityTypeCode) {
        Equals equalsActivityType;
        QueryList<BudgetRate> matchActivityTypePropRates;
        return CollectionUtils.isNotEmpty(allPropRates) && (CollectionUtils.isEmpty(matchActivityTypePropRates = new QueryList<BudgetRate>(allPropRates).filter(equalsActivityType = new Equals("activityTypeCode", (Comparable)((Object)activityTypeCode)))) || allPropRates.size() != matchActivityTypePropRates.size());
    }

    @Override
    public boolean checkActivityTypeChange(BudgetParentDocument<T> budgetParentDoc, Budget budget) {
        return this.checkActivityTypeChange(this.getSavedBudgetRates(budget), budgetParentDoc.getBudgetParent().getActivityTypeCode());
    }

    @Override
    public boolean ValidInflationCeRate(BudgetLineItemBase budgetLineItem) {
        HashMap<String, String> costElementQMap = new HashMap<String, String>();
        costElementQMap.put("costElement", budgetLineItem.getCostElement());
        CostElement costElementBO = (CostElement)this.businessObjectService.findByPrimaryKey(CostElement.class, costElementQMap);
        budgetLineItem.setCostElementBO(costElementBO);
        HashMap<String, String> validCeQMap = new HashMap<String, String>();
        validCeQMap.put("costElement", budgetLineItem.getCostElement());
        costElementBO.refreshReferenceObject("validCeRateTypes");
        List<ValidCeRateType> validCeRateTypes = costElementBO.getValidCeRateTypes();
        QueryList qValidCeRateTypes = validCeRateTypes == null ? new QueryList() : new QueryList<ValidCeRateType>(validCeRateTypes);
        Equals eqInflation = new Equals("rateClassType", (Comparable)((Object)RateClassType.INFLATION.getRateClassType()));
        QueryList inflationValidCeRates = qValidCeRateTypes.filter(eqInflation);
        return !inflationValidCeRates.isEmpty();
    }

    @Override
    public String getActivityTypeForBudget(BudgetDocument<T> budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        T budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        if (budgetParent == null) {
            budgetDocument.refreshReferenceObject("parentDocument");
        }
        HashMap<String, Object> qMap = new HashMap<String, Object>();
        qMap.put("budgetId", budget.getBudgetId());
        List allPropRates = (List)this.businessObjectService.findMatching(BudgetRate.class, qMap);
        if (CollectionUtils.isNotEmpty((Collection)allPropRates)) {
            qMap.put("activityTypeCode", budgetParent.getActivityTypeCode());
            Collection matchActivityTypePropRates = this.businessObjectService.findMatching(BudgetRate.class, qMap);
            if (CollectionUtils.isNotEmpty((Collection)matchActivityTypePropRates)) {
                for (BudgetRate budgetRate : allPropRates) {
                    if (budgetRate.getActivityTypeCode().equals(budgetParent.getActivityTypeCode())) continue;
                    return budgetRate.getActivityTypeCode();
                }
                return budgetParent.getActivityTypeCode();
            }
            return ((BudgetRate)allPropRates.get(0)).getActivityTypeCode();
        }
        return "x";
    }

    @Override
    public List<ValidCeJobCode> getApplicableCostElements(Long budgetId, String personSequenceNumber) {
        List validCostElements = null;
        String jobCodeValidationEnabledInd = this.parameterService.getParameterValueAsString(BudgetDocument.class, "JOBCODE_VALIDATION_ENABLED");
        if (StringUtils.isNotEmpty((String)jobCodeValidationEnabledInd) && jobCodeValidationEnabledInd.equals("Y")) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("budgetId", budgetId);
            fieldValues.put("personSequenceNumber", personSequenceNumber);
            BudgetPerson budgetPerson = (BudgetPerson)this.businessObjectService.findByPrimaryKey(BudgetPerson.class, fieldValues);
            fieldValues.clear();
            if (budgetPerson != null && StringUtils.isNotEmpty((String)budgetPerson.getJobCode())) {
                fieldValues.put("jobCode", budgetPerson.getJobCode().toUpperCase());
                validCostElements = (List)this.businessObjectService.findMatching(ValidCeJobCode.class, fieldValues);
            }
        }
        return validCostElements;
    }

    @Override
    public String getApplicableCostElementsForAjaxCall(Long budgetId, String personSequenceNumber, String budgetCategoryTypeCode) {
        String resultStr = "";
        if (this.isAuthorizedToAccess(budgetCategoryTypeCode)) {
            List<ValidCeJobCode> validCostElements;
            if (StringUtils.isNotBlank((String)budgetCategoryTypeCode) && budgetCategoryTypeCode.contains(":")) {
                budgetCategoryTypeCode = StringUtils.split((String)budgetCategoryTypeCode, (String)":")[0];
            }
            if (CollectionUtils.isNotEmpty(validCostElements = this.getApplicableCostElements(budgetId, personSequenceNumber))) {
                for (ValidCeJobCode validCE : validCostElements) {
                    HashMap<String, String> fieldValues = new HashMap<String, String>();
                    fieldValues.put("costElement", validCE.getCostElement());
                    CostElement costElement = (CostElement)this.businessObjectService.findByPrimaryKey(CostElement.class, fieldValues);
                    resultStr = resultStr + "," + validCE.getCostElement() + ";" + costElement.getDescription();
                }
                resultStr = resultStr + ",ceLookup;false";
            } else {
                CostElementValuesFinder ceValuesFinder = new CostElementValuesFinder();
                ceValuesFinder.setBudgetCategoryTypeCode(budgetCategoryTypeCode);
                List<KeyValue> allPersonnelCostElements = ceValuesFinder.getKeyValues();
                for (KeyValue keyValue : allPersonnelCostElements) {
                    if (!StringUtils.isNotEmpty((String)keyValue.getKey().toString())) continue;
                    resultStr = resultStr + "," + keyValue.getKey() + ";" + keyValue.getValue();
                }
                resultStr = resultStr + ",ceLookup;true";
            }
        }
        return resultStr;
    }

    @Override
    public List<String> getExistingGroupNames(String budgetId, String budgetPeriod) {
        ArrayList<String> groupNames = new ArrayList<String>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("budgetId", budgetId);
        fieldValues.put("budgetPeriodId", budgetPeriod);
        List budgetLineItems = (List)this.businessObjectService.findByPrimaryKey(BudgetLineItem.class, fieldValues);
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!StringUtils.isNotEmpty((String)budgetLineItem.getGroupName())) continue;
            groupNames.add(budgetLineItem.getGroupName());
        }
        return groupNames;
    }

    @Override
    public String getExistingGroupNamesForAjaxCall(String budgetId, String budgetPeriod) {
        List<String> groupNames = this.getExistingGroupNames(budgetId, budgetPeriod);
        String resultStr = "";
        for (String groupName : groupNames) {
            resultStr = resultStr + "," + groupName;
        }
        return resultStr;
    }

    @Override
    public String getBudgetExpensePanelName(BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem) {
        StringBuffer panelName = new StringBuffer();
        if (budgetLineItem.getBudgetCategory() == null) {
            budgetLineItem.refreshReferenceObject("budgetCategory");
        }
        if (budgetLineItem.getBudgetCategory() != null && budgetLineItem.getBudgetCategory().getBudgetCategoryType() == null) {
            budgetLineItem.getBudgetCategory().refreshReferenceObject("budgetCategoryType");
        }
        if (budgetLineItem.getBudgetCategory() != null && budgetLineItem.getBudgetCategory().getBudgetCategoryType() != null) {
            panelName.append(budgetLineItem.getBudgetCategory().getBudgetCategoryType().getDescription());
        }
        return panelName.toString();
    }

    @Override
    public String getParticipantSupportCategoryCode() {
        return this.parameterService.getParameterValueAsString(BudgetDocument.class, "budgetCategoryType.participantSupport");
    }

    @Override
    public List<BudgetLineItem> getMatchingLineItems(List<BudgetLineItem> lineItems, List<String> budgetCategoryType) {
        ArrayList<BudgetLineItem> result = new ArrayList<BudgetLineItem>();
        for (BudgetLineItem lineItem : lineItems) {
            if (!budgetCategoryType.contains(lineItem.getBudgetCategory().getBudgetCategoryTypeCode())) continue;
            result.add(lineItem);
        }
        return result;
    }

    @Override
    public Collection<BudgetRate> getSavedProposalRates(BudgetVersionOverview budgetToOpen) {
        HashMap<String, Long> qMap = new HashMap<String, Long>();
        qMap.put("budgetId", budgetToOpen.getBudgetId());
        return this.businessObjectService.findMatching(BudgetRate.class, qMap);
    }

    @Override
    public boolean validateBudgetAuditRule(BudgetParentDocument<T> parentDocument) throws Exception {
        boolean valid = true;
        boolean finalAndCompleteBudgetVersionFound = false;
        boolean budgetVersionsExists = false;
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        String budgetStatusCompleteCode = this.parameterService.getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode");
        for (BudgetDocumentVersion budgetDocumentVersion : parentDocument.getBudgetDocumentVersions()) {
            BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
            budgetVersionsExists = true;
            if (!budgetVersion.isFinalVersionFlag()) continue;
            valid &= this.applyAuditRuleForBudgetDocument(budgetVersion);
            if (parentDocument.getBudgetParent().getBudgetStatus() != null && parentDocument.getBudgetParent().getBudgetStatus().equals(budgetStatusCompleteCode)) {
                finalAndCompleteBudgetVersionFound = true;
                continue;
            }
            finalAndCompleteBudgetVersionFound = false;
        }
        if (budgetVersionsExists && !finalAndCompleteBudgetVersionFound) {
            auditErrors.add(new AuditError("document.budgetDocumentVersion[0].budgetVersionOverview", "error.no.budgetVersion.completeAndFinal", "budgetVersions.BudgetVersions"));
            valid &= false;
        }
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("budgetVersionErrors", new AuditCluster("Budget Versions", auditErrors, "Validation Errors"));
        }
        return valid;
    }

    @Override
    public boolean validateBudgetAuditRuleBeforeSaveBudgetVersion(BudgetParentDocument<T> proposalDevelopmentDocument) throws Exception {
        boolean valid = true;
        for (BudgetDocumentVersion budgetDocumentVersion : proposalDevelopmentDocument.getBudgetDocumentVersions()) {
            BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
            String budgetStatusCompleteCode = this.parameterService.getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode");
            if (budgetVersion.isFinalVersionFlag() && budgetVersion.getBudgetStatus() != null && budgetVersion.getBudgetStatus().equals(budgetStatusCompleteCode)) {
                valid &= this.applyAuditRuleForBudgetDocument(budgetVersion);
            }
            if (valid) continue;
            break;
        }
        if (!valid) {
            valid = true;
            for (Object key : KNSGlobalVariables.getAuditErrorMap().keySet()) {
                AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key);
                if (!auditCluster.getCategory().equals("Validation Errors")) continue;
                valid = false;
                break;
            }
        }
        if (valid) {
            KNSGlobalVariables.getAuditErrorMap().clear();
        }
        return valid;
    }

    protected boolean applyAuditRuleForBudgetDocument(BudgetVersionOverview budgetVersion) throws Exception {
        DocumentService documentService = KraServiceLocator.getService(DocumentService.class);
        BudgetDocument budgetDocument = (BudgetDocument)documentService.getByDocumentHeaderId(budgetVersion.getDocumentNumber());
        return KraServiceLocator.getService(KualiRuleService.class).applyRules((KualiDocumentEvent)new DocumentAuditEvent((Document)budgetDocument));
    }

    @Override
    public BudgetDocument copyBudgetVersion(BudgetDocument budgetDocument, boolean onlyOnePeriod) throws WorkflowException {
        String parentDocumentNumber = budgetDocument.getParentDocument().getDocumentNumber();
        budgetDocument.toCopy();
        budgetDocument.getParentDocument().getDocumentHeader().setDocumentNumber(parentDocumentNumber);
        budgetDocument.getParentDocument().setDocumentNumber(parentDocumentNumber);
        if (budgetDocument.getBudgets().isEmpty()) {
            throw new RuntimeException("Not able to find any Budget Version associated with this document");
        }
        Budget budget = budgetDocument.getBudget();
        if (onlyOnePeriod) {
            List<BudgetPeriod> oldBudgetPeriods = budget.getBudgetPeriods();
            for (int i = 1; i < oldBudgetPeriods.size(); ++i) {
                BudgetPeriod period = oldBudgetPeriods.get(i);
                period.getBudgetLineItems().clear();
                period.setCostSharingAmount(new BudgetDecimal(0.0));
                period.setExpenseTotal(new BudgetDecimal(0.0));
                period.setTotalCost(new BudgetDecimal(0.0));
                period.setTotalCostLimit(new BudgetDecimal(0.0));
                period.setTotalDirectCost(new BudgetDecimal(0.0));
                period.setTotalIndirectCost(new BudgetDecimal(0.0));
                period.setUnderrecoveryAmount(new BudgetDecimal(0.0));
            }
            if (budget.getBudgetSubAwards() != null && budget.getBudgetSubAwards().size() > 0) {
                List<BudgetSubAwardPeriodDetail> budetSubawardPeriodDetail = budget.getBudgetSubAwards().get(0).getBudgetSubAwardPeriodDetails();
                for (int i = 1; i < budetSubawardPeriodDetail.size(); ++i) {
                    BudgetSubAwardPeriodDetail period = budetSubawardPeriodDetail.get(i);
                    period.setAmountsModified(true);
                    period.setCostShare(new BudgetDecimal(0.0));
                    period.setDirectCost(new BudgetDecimal(0.0));
                    period.setIndirectCost(new BudgetDecimal(0.0));
                    period.setTotalCost(new BudgetDecimal(0.0));
                }
            }
        }
        budget.setBudgetVersionNumber(budgetDocument.getParentDocument().getNextBudgetVersionNumber());
        try {
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            this.fixProperty(budgetDocument, "setBudgetId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budgetDocument, "setBudgetPeriodId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budgetDocument, "setBudgetLineItemId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budgetDocument, "setBudgetLineItemCalculatedAmountId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budgetDocument, "setBudgetPersonnelLineItemId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budgetDocument, "setBudgetPersonnelCalculatedAmountId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budgetDocument, "setBudgetPersonnelRateAndBaseId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budgetDocument, "setBudgetRateAndBaseId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budgetDocument, "setVersionNumber", Integer.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budgetDocument, "setAwardBudgetPeriodSummaryCalculatedAmountId", Long.class, null, objectMap);
            objectMap.clear();
            this.fixProperty(budgetDocument, "setFinalVersionFlag", Boolean.class, Boolean.FALSE, objectMap);
            objectMap.clear();
            ObjectUtils.materializeAllSubObjects((PersistableBusinessObject)budgetDocument);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        HashMap<String, BudgetModular> tmpBudgetModulars = new HashMap<String, BudgetModular>();
        for (BudgetPeriod budgetPeriod : budgetDocument.getBudget().getBudgetPeriods()) {
            BudgetModular tmpObject = null;
            if (budgetPeriod.getBudgetModular() != null) {
                tmpObject = (BudgetModular)((Object)ObjectUtils.deepCopy((Serializable)((Object)budgetPeriod.getBudgetModular())));
            }
            tmpBudgetModulars.put("" + budgetPeriod.getBudget().getVersionNumber() + budgetPeriod.getBudgetPeriod(), tmpObject);
            budgetPeriod.setBudgetModular(null);
        }
        this.copyLineItemToPersonnelDetails(budgetDocument);
        budgetDocument.setVersionNumber(null);
        budgetDocument.getBudget().setBudgetAdjustmentDocumentNumber(null);
        List<BudgetProjectIncome> projectIncomes = budgetDocument.getBudget().getBudgetProjectIncomes();
        budgetDocument.getBudget().setBudgetProjectIncomes(new ArrayList<BudgetProjectIncome>());
        this.documentService.saveDocument((Document)budgetDocument);
        if (projectIncomes != null && !projectIncomes.isEmpty()) {
            this.updateProjectIncomes(budgetDocument, projectIncomes);
        }
        this.getBudgetCommonService(budget.getBudgetDocument().getParentDocument()).calculateBudgetOnSave(budget);
        for (BudgetPeriod tmpBudgetPeriod : budgetDocument.getBudget().getBudgetPeriods()) {
            BudgetModular tmpBudgetModular = (BudgetModular)tmpBudgetModulars.get("" + tmpBudgetPeriod.getBudget().getVersionNumber() + tmpBudgetPeriod.getBudgetPeriod());
            if (tmpBudgetModular == null) continue;
            tmpBudgetModular.setBudgetPeriodId(tmpBudgetPeriod.getBudgetPeriodId());
            tmpBudgetPeriod.setBudgetModular(tmpBudgetModular);
        }
        this.saveBudgetDocument(budgetDocument);
        budgetDocument.getParentDocument().refreshBudgetDocumentVersions();
        return budgetDocument;
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(BudgetParentDocument parentBudgetDocument) {
        return BudgetCommonServiceFactory.createInstance(parentBudgetDocument);
    }

    protected void updateProjectIncomes(BudgetDocument budgetDocument, List<BudgetProjectIncome> projectIncomes) {
        ArrayList<BudgetProjectIncome> budgetProjectIncomes = new ArrayList<BudgetProjectIncome>();
        for (BudgetPeriod budgetPeriod : budgetDocument.getBudget().getBudgetPeriods()) {
            for (BudgetProjectIncome projectIncome : projectIncomes) {
                if (!budgetPeriod.getBudgetPeriod().equals(projectIncome.getBudgetPeriodNumber())) continue;
                projectIncome.setBudgetId(budgetDocument.getBudget().getBudgetId());
                projectIncome.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
                budgetProjectIncomes.add(projectIncome);
            }
        }
        this.businessObjectService.save(budgetProjectIncomes);
        budgetDocument.getBudget().refreshReferenceObject("budgetProjectIncomes");
    }

    protected void copyLineItemToPersonnelDetails(BudgetDocument budgetDocument) {
        for (BudgetPeriod budgetPeriod : budgetDocument.getBudget().getBudgetPeriods()) {
            if (budgetPeriod.getBudgetLineItems() == null || budgetPeriod.getBudgetLineItems().isEmpty()) continue;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (budgetLineItem.getBudgetPersonnelDetailsList() == null || budgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) continue;
                for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    budgetPersonnelDetails.setBudgetId(budgetLineItem.getBudgetId());
                    budgetPersonnelDetails.setBudgetPeriod(budgetLineItem.getBudgetPeriod());
                    budgetPersonnelDetails.setLineItemNumber(budgetLineItem.getLineItemNumber());
                    budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
                    budgetPersonnelDetails.setCostElementBO(budgetLineItem.getCostElementBO());
                }
            }
        }
    }

    public BudgetRatesService<T> getBudgetRatesService() {
        return this.budgetRatesService;
    }

    public void setBudgetRatesService(BudgetRatesService<T> budgetRatesService) {
        this.budgetRatesService = budgetRatesService;
    }

    public void setDeepCopyPostProcessor(DeepCopyPostProcessor deepCopyPostProcessor) {
        this.deepCopyPostProcessor = deepCopyPostProcessor;
    }

    public DeepCopyPostProcessor getDeepCopyPostProcessor() {
        return this.deepCopyPostProcessor;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }

    private boolean isAuthorizedToAccess(String budgetCategoryTypeCode) {
        boolean isAuthorized = true;
        if (budgetCategoryTypeCode.contains(":")) {
            if (GlobalVariables.getUserSession() != null) {
                Map editModes;
                Object formObj;
                String[] invalues = StringUtils.split((String)budgetCategoryTypeCode, (String)":");
                String docFormKey = invalues[1];
                isAuthorized = StringUtils.isBlank((String)docFormKey) ? false : ((formObj = GlobalVariables.getUserSession().retrieveObject(docFormKey)) == null || !(formObj instanceof BudgetForm) ? false : BooleanUtils.toBoolean((String)((String)(editModes = ((BudgetForm)formObj).getEditingMode()).get("fullEntry"))) || BooleanUtils.toBoolean((String)((String)editModes.get("viewOnly"))) || BooleanUtils.toBoolean((String)((String)editModes.get("modifyBudgtes"))) || BooleanUtils.toBoolean((String)((String)editModes.get("viewBudgets"))) || BooleanUtils.toBoolean((String)((String)editModes.get("addBudget"))));
            } else {
                LOG.info((Object)"dwr/ajax does not have session ");
            }
        }
        return isAuthorized;
    }

    public FiscalYearMonthService getFiscalYearMonthService() {
        return this.fiscalYearMonthService;
    }

    public void setFiscalYearMonthService(FiscalYearMonthService fiscalYearMonthService) {
        this.fiscalYearMonthService = fiscalYearMonthService;
    }

    @Override
    public BudgetDecimal getBaseSalaryByPeriod(Long budgetId, int budgetPeriod, KeyPersonInfo person) {
        BusinessObjectService boService = KraServiceLocator.getService(BusinessObjectService.class);
        Integer listIndex = 0;
        BudgetDecimal baseSalaryByPeriod = null;
        HashMap<String, Object> budgetPersonInPeriodsSalaryMap = new HashMap<String, Object>();
        budgetPersonInPeriodsSalaryMap.put("budgetId", budgetId);
        if (person.getPersonId() != null) {
            budgetPersonInPeriodsSalaryMap.put("personId", person.getPersonId());
        } else {
            budgetPersonInPeriodsSalaryMap.put("personId", person.getRolodexId());
        }
        budgetPersonInPeriodsSalaryMap.put("budgetPeriod", budgetPeriod);
        Collection personSalaryDetails = boService.findMatchingOrderBy(BudgetPersonSalaryDetails.class, budgetPersonInPeriodsSalaryMap, "personSequenceNumber", true);
        List budgetPersonSalaryDetails = (List)personSalaryDetails;
        if (budgetPersonSalaryDetails != null && budgetPersonSalaryDetails.size() > 0) {
            baseSalaryByPeriod = ((BudgetPersonSalaryDetails)((Object)budgetPersonSalaryDetails.get(listIndex))).getBaseSalary();
        }
        return baseSalaryByPeriod;
    }

    @Override
    public String populateBudgetPersonSalaryDetailsInPeriods(String budgetId, String personSequenceNumber, String personId) {
        String baseSalary = "";
        BusinessObjectService boService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> budgetPersonInPeriodsSalaryMap = new HashMap<String, String>();
        budgetPersonInPeriodsSalaryMap.put("personSequenceNumber", personSequenceNumber);
        budgetPersonInPeriodsSalaryMap.put("budgetId", budgetId);
        budgetPersonInPeriodsSalaryMap.put("personId", personId);
        Collection budgetPersonSalaryDetails = boService.findMatching(BudgetPersonSalaryDetails.class, budgetPersonInPeriodsSalaryMap);
        if (budgetPersonSalaryDetails != null && !budgetPersonSalaryDetails.isEmpty()) {
            for (BudgetPersonSalaryDetails salaryDetails : budgetPersonSalaryDetails) {
                baseSalary = baseSalary + (Object)((Object)salaryDetails.getBaseSalary()) + ",";
            }
            baseSalary = baseSalary.substring(0, baseSalary.lastIndexOf(","));
        }
        return baseSalary;
    }

    @Override
    public void populateNewBudgetLineItem(BudgetLineItem newBudgetLineItem, BudgetPeriod budgetPeriod) {
        List<String> formulatedCostElements;
        Budget budget = budgetPeriod.getBudget();
        newBudgetLineItem.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
        newBudgetLineItem.setBudgetPeriodId(budgetPeriod.getBudgetPeriodId());
        newBudgetLineItem.setStartDate(budgetPeriod.getStartDate());
        newBudgetLineItem.setEndDate(budgetPeriod.getEndDate());
        newBudgetLineItem.setBudgetId(budget.getBudgetId());
        newBudgetLineItem.setLineItemNumber(budget.getBudgetDocument().getHackedDocumentNextValue("budget.budgetLineItem.lineItemNumber"));
        newBudgetLineItem.setApplyInRateFlag(true);
        newBudgetLineItem.setSubmitCostSharingFlag(budget.getSubmitCostSharingFlag());
        newBudgetLineItem.refreshReferenceObject("costElementBO");
        String onOffCampusFlag = budget.getOnOffCampusFlag();
        if (onOffCampusFlag.equalsIgnoreCase("D")) {
            newBudgetLineItem.setOnOffCampusFlag(newBudgetLineItem.getCostElementBO().getOnOffCampusFlag());
        } else {
            newBudgetLineItem.setOnOffCampusFlag(onOffCampusFlag.equalsIgnoreCase("N"));
        }
        newBudgetLineItem.setBudgetCategoryCode(newBudgetLineItem.getCostElementBO().getBudgetCategoryCode());
        newBudgetLineItem.setLineItemSequence(newBudgetLineItem.getLineItemNumber());
        if (this.isBudgetFormulatedCostEnabled() && (formulatedCostElements = this.getFormulatedCostElements()).contains(newBudgetLineItem.getCostElement())) {
            newBudgetLineItem.setFormulatedCostElementFlag(true);
        }
    }

    protected boolean isBudgetFormulatedCostEnabled() {
        String formulatedCostEnabled = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "enableFormulatedCostCalculation");
        return formulatedCostEnabled != null && formulatedCostEnabled.equalsIgnoreCase("Y");
    }

    protected List<String> getFormulatedCostElements() {
        String formulatedCEsValue = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "formulatedCostElements");
        String[] formulatedCEs = formulatedCEsValue == null ? new String[]{} : formulatedCEsValue.split(",");
        return Arrays.asList(formulatedCEs);
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    protected BudgetPersonService getBudgetPersonService() {
        return this.budgetPersonService;
    }
}

