/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Section;

public class CostElementMaintainableImpl
extends KualiMaintainableImpl {
    private static final long serialVersionUID = -2403270541923494151L;
    private static final String KFS_ON_PARM_NMSPC_CD = "KC-AWARD";
    private static final String KFS_ON_PARM_DTL_TYP_CD = "Document";
    private static final String KFS_ON_PARM_NM = "FIN_SYSTEM_INTEGRATION_ON";
    private static final String KFS_ON_OFF_VALUE = "OFF";
    private static final String KFS_SECTION_NAME = "Edit Cost Element KFS Option List";

    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List oldSections = super.getSections(document, oldMaintainable);
        String kfsOnParameterValue = this.getParameterService().getParameterValueAsString(KFS_ON_PARM_NMSPC_CD, KFS_ON_PARM_DTL_TYP_CD, KFS_ON_PARM_NM);
        ArrayList<Section> sections = new ArrayList<Section>();
        if (!StringUtils.equals((String)kfsOnParameterValue, (String)KFS_ON_OFF_VALUE)) {
            sections.addAll(oldSections);
        } else {
            for (Section oldSection : oldSections) {
                if (StringUtils.equals((String)oldSection.getSectionTitle(), (String)KFS_SECTION_NAME)) continue;
                sections.add(oldSection);
            }
        }
        return sections;
    }

    private ParameterService getParameterService() {
        return KraServiceLocator.getService(ParameterService.class);
    }
}

