/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.distributionincome;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetCostShare;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.costshare.CostShareRuleResearchDocumentBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class BudgetCostShareAuditRule
extends CostShareRuleResearchDocumentBase
implements DocumentAuditRule {
    public static final String BUDGET_COST_SHARE_ERROR_KEY = "budgetCostShareAuditErrors";

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        Budget budget = ((BudgetDocument)document).getBudget();
        if (!budget.isCostSharingApplicable().booleanValue()) {
            return true;
        }
        List<BudgetCostShare> costShares = budget.getBudgetCostShares();
        boolean retval = true;
        String[] params = new String[]{"Cost Sharing"};
        if (budget.getUnallocatedCostSharing().isNonZero() && budget.isCostSharingEnforced().booleanValue()) {
            retval = false;
            if (costShares.size() == 0) {
                this.getAuditErrors().add(new AuditError("document.budget.budgetCostShare", "error.budget.distribution.unallocatedMustBeZero", "budgetDistributionAndIncome.budgetCostSharing", params));
            }
            for (int i = 0; i < costShares.size(); ++i) {
                this.getAuditErrors().add(new AuditError("document.budget.budgetCostShare[" + i + "].shareAmount", "error.budget.distribution.unallocatedMustBeZero", "budgetDistributionAndIncome.budgetCostSharing", params));
            }
        }
        String source = null;
        Integer fiscalYear = null;
        ArrayList<Integer> validFiscalYears = new ArrayList<Integer>();
        for (Budget.FiscalYearSummary fys : budget.getFiscalYearCostShareTotals()) {
            validFiscalYears.add(fys.getFiscalYear());
        }
        int i = 0;
        for (BudgetCostShare costShare : costShares) {
            source = costShare.getSourceAccount();
            fiscalYear = costShare.getProjectPeriod();
            if (null == source || source.length() == 0) {
                retval = false;
                this.getAuditErrors().add(new AuditError("document.budget.budgetCostShare[" + i + "].sourceAccount", "error.budget.distribution.sourceMissing", "budgetDistributionAndIncome.budgetCostSharing", params));
            }
            int numberOfProjectPeriods = -1;
            if (budget.getBudgetPeriods() != null) {
                numberOfProjectPeriods = budget.getBudgetPeriods().size();
            }
            this.validateProjectPeriod(fiscalYear, "document.budget.budgetCostShare[" + i + "].projectPeriod", numberOfProjectPeriods);
            if (this.getCostShareService().validateProjectPeriodAsProjectPeriod()) {
                ArrayList<AuditError> errors = new ArrayList<AuditError>();
                this.validatePeriodNumber(costShare, "document.budget.budgetCostShare[" + i + "].projectPeriod", numberOfProjectPeriods, errors);
                if (!errors.isEmpty()) {
                    this.getAuditErrors().addAll(errors);
                }
            }
            ++i;
        }
        return retval;
    }

    private List<AuditError> getAuditErrors() {
        return this.getAuditProblems("Validation Errors");
    }

    private List<AuditError> getAuditWarnings() {
        return this.getAuditProblems("Warnings");
    }

    private List<AuditError> getAuditProblems(String problemType) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(BUDGET_COST_SHARE_ERROR_KEY)) {
            KNSGlobalVariables.getAuditErrorMap().put(BUDGET_COST_SHARE_ERROR_KEY, new AuditCluster("Budget Cost Sharing", auditErrors, problemType));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(BUDGET_COST_SHARE_ERROR_KEY)).getAuditErrorList();
        }
        return auditErrors;
    }
}

