/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.distributionincome;

import java.util.Iterator;
import org.kuali.kra.budget.distributionincome.AddBudgetCostShareEvent;
import org.kuali.kra.budget.distributionincome.AddBudgetCostShareRule;
import org.kuali.kra.budget.distributionincome.BudgetCostShare;
import org.kuali.kra.budget.distributionincome.BudgetCostShareAllocationEvent;
import org.kuali.kra.budget.distributionincome.BudgetCostShareAllocationRule;
import org.kuali.kra.budget.distributionincome.BudgetDistributionAndIncomeComponent;
import org.kuali.kra.budget.distributionincome.BudgetValidationCostShareEvent;
import org.kuali.kra.budget.distributionincome.BudgetValidationCostShareRule;
import org.kuali.kra.budget.distributionincome.ValidationHelper;
import org.kuali.kra.budget.document.BudgetDocumentContainer;
import org.kuali.kra.costshare.CostShareRuleResearchDocumentBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetCostShareRuleImpl
extends CostShareRuleResearchDocumentBase
implements AddBudgetCostShareRule,
BudgetValidationCostShareRule,
BudgetCostShareAllocationRule {
    private static final String ADD_ERROR_KEY = "error.custom";
    private ValidationHelper validationHelper = new ValidationHelper();

    @Override
    public boolean processAddBudgetCostShareBusinessRules(AddBudgetCostShareEvent budgetCostShareEvent) {
        boolean retVal = !this.areDuplicatesPresent(budgetCostShareEvent.getBudgetCostShare());
        return retVal &= this.validateProjectPeriod(budgetCostShareEvent);
    }

    @Override
    public boolean processBudgetValidationCostShareBusinessRules(BudgetValidationCostShareEvent budgetCostShareEvent) {
        boolean retVal = this.areRequiredRulesSatisfied(budgetCostShareEvent.getBudgetCostShare());
        return retVal;
    }

    private boolean areDuplicatesPresent(BudgetDistributionAndIncomeComponent testBudgetCostShare) {
        boolean duplicate;
        block2: {
            BudgetDistributionAndIncomeComponent budgetCostShare;
            duplicate = false;
            if (testBudgetCostShare == null) {
                return duplicate;
            }
            KualiForm form = KNSGlobalVariables.getKualiForm();
            if (!(form instanceof BudgetDocumentContainer)) break block2;
            BudgetDocumentContainer budgetContainerForm = (BudgetDocumentContainer)form;
            Iterator<BudgetCostShare> i$ = budgetContainerForm.getBudgetDocument().getBudget().getBudgetCostShares().iterator();
            while (i$.hasNext() && !(duplicate = this.checkForDuplicateFields(testBudgetCostShare, budgetCostShare = (BudgetDistributionAndIncomeComponent)i$.next()))) {
            }
        }
        return duplicate;
    }

    private boolean areRequiredRulesSatisfied(BudgetCostShare budgetCostShare) {
        boolean valid = this.validationHelper.checkRequiredField(budgetCostShare.getProjectPeriod(), "budgetCostShare.fiscalYear", "Fiscal Year");
        valid &= this.validationHelper.checkRequiredField((Object)budgetCostShare.getShareAmount(), "budgetCostShare.shareAmount", "Amount");
        return valid &= this.validationHelper.checkRequiredField(budgetCostShare.getSourceAccount(), "budgetCostShare.sourceAccount", "Source Account");
    }

    private boolean checkForDuplicateFields(BudgetDistributionAndIncomeComponent testBudgetCostShare, BudgetDistributionAndIncomeComponent budgetCostShare) {
        boolean duplicate = testBudgetCostShare.equals(budgetCostShare);
        if (duplicate) {
            GlobalVariables.getMessageMap().putError("newCostShare.*", ADD_ERROR_KEY, new String[]{"A Cost Share with the same Fiscal Year, Source Account and Amount exists in the table"});
        }
        return duplicate;
    }

    @Override
    public boolean processBudgetCostShareAllocationBusinessRules(BudgetCostShareAllocationEvent budgetCostShareEvent) {
        boolean unallocatedCostSharingExists = budgetCostShareEvent.getBudgetDocument().getBudget().getUnallocatedCostSharing().isNonZero();
        if (unallocatedCostSharingExists) {
            GlobalVariables.getMessageMap().putError("document.budgetCostShare*", ADD_ERROR_KEY, new String[]{"Cost share allocation doesn't total available cost sharing"});
        }
        return unallocatedCostSharingExists;
    }

    private boolean validateProjectPeriod(AddBudgetCostShareEvent budgetCostShareEvent) {
        String projectPeriodField = "newBudgetCostShare.projectPeriod";
        int numberOfProjectPeriods = budgetCostShareEvent.getBudgetDocument().getBudget().getBudgetPeriods().size();
        return this.validateProjectPeriod(budgetCostShareEvent.getBudgetCostShare().getProjectPeriod(), projectPeriodField, numberOfProjectPeriods);
    }
}

