/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.distributionincome;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetCostShare;
import org.kuali.kra.budget.distributionincome.BudgetDistributionAndIncomeService;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandA;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.rates.AbstractBudgetRate;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.costshare.CostShareService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class BudgetDistributionAndIncomeServiceImpl
implements BudgetDistributionAndIncomeService {
    private ParameterService parameterService;
    private CostShareService costShareService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setCostShareService(CostShareService costShareService) {
        this.costShareService = costShareService;
    }

    protected boolean isBudgetFinalAndComplete(Budget budget) {
        String budgetStatusCompleteValue = this.parameterService.getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode");
        return budget.getFinalVersionFlag() != false && budgetStatusCompleteValue.equals(budget.getBudgetStatus());
    }

    @Override
    public void initializeCollectionDefaults(Budget budget) {
        if (!this.isBudgetFinalAndComplete(budget)) {
            this.initializeCostSharingCollectionDefaults(budget);
            this.initializeUnrecoveredFandACollectionDefaults(budget);
        }
    }

    @Override
    public void initializeCostSharingCollectionDefaults(Budget budget) {
        block2: {
            block3: {
                if (!budget.isCostSharingApplicable().booleanValue() || !budget.isCostSharingAvailable() || budget.getBudgetCostShares().size() != 0 || this.isBudgetFinalAndComplete(budget)) break block2;
                if (!this.costShareService.validateProjectPeriodAsFiscalYear()) break block3;
                for (Budget.FiscalYearSummary fiscalYearSummary : budget.getFiscalYearCostShareTotals()) {
                    budget.add(this.createBudgetCostShare(fiscalYearSummary));
                }
                break block2;
            }
            if (!this.costShareService.validateProjectPeriodAsProjectPeriod()) break block2;
            int counter = 1;
            for (BudgetPeriod period : budget.getBudgetPeriods()) {
                budget.add(this.createBudgetCostShare(counter, period.getCostSharingAmount()));
                ++counter;
            }
        }
    }

    @Override
    public void initializeUnrecoveredFandACollectionDefaults(Budget budget) {
        if (budget.isUnrecoveredFandAApplicable().booleanValue() && budget.isUnrecoveredFandAAvailable() && budget.getBudgetUnrecoveredFandAs().size() == 0 && !this.isBudgetFinalAndComplete(budget)) {
            for (Budget.FiscalYearSummary fiscalYearSummary : budget.getFiscalYearUnrecoveredFandATotals()) {
                budget.add(this.createBudgetUnrecoveredFandA(fiscalYearSummary, this.findApplicableRatesForFiscalYearUFAndA(budget, fiscalYearSummary, true), "Y"));
                budget.add(this.createBudgetUnrecoveredFandA(fiscalYearSummary, this.findApplicableRatesForFiscalYearUFAndA(budget, fiscalYearSummary, false), "N"));
            }
        }
    }

    protected BudgetDecimal findApplicableRatesForFiscalYearUFAndA(Budget budget, Budget.FiscalYearSummary fiscalYearSummary, boolean onCampus) {
        String unrecoveredFandARateClassCode = budget.getOhRateClassCode();
        if (unrecoveredFandARateClassCode == null || unrecoveredFandARateClassCode.trim().length() == 0) {
            return BudgetDecimal.ZERO;
        }
        return this.findApplicableRateForRateClassCodeUFAndA(budget, fiscalYearSummary.getFiscalYear(), unrecoveredFandARateClassCode, onCampus);
    }

    protected BudgetDecimal findApplicableRateForRateClassCodeUFAndA(Budget budget, Integer fiscalYear, String unrecoveredFandARateClassCode, boolean findOnCampusRate) {
        BudgetDecimal applicableRate = BudgetDecimal.ZERO;
        AbstractBudgetRate appliedRate = null;
        for (BudgetRate budgetRate : budget.getBudgetRates()) {
            if (!StringUtils.equalsIgnoreCase((String)budgetRate.getRateClassCode(), (String)unrecoveredFandARateClassCode) || findOnCampusRate != budgetRate.getOnOffCampusFlag()) continue;
            if (appliedRate == null || Integer.valueOf(appliedRate.getFiscalYear()) < Integer.valueOf(budgetRate.getFiscalYear()) && Integer.valueOf(budgetRate.getFiscalYear()) <= Integer.valueOf(fiscalYear)) {
                appliedRate = budgetRate;
                continue;
            }
            if (!appliedRate.getFiscalYear().equals(budgetRate.getFiscalYear()) || Integer.valueOf(budgetRate.getFiscalYear()) > Integer.valueOf(fiscalYear)) continue;
            appliedRate = budgetRate;
            break;
        }
        if (appliedRate != null) {
            applicableRate = new BudgetDecimal(appliedRate.getApplicableRate().bigDecimalValue());
        }
        return applicableRate;
    }

    protected BudgetCostShare createBudgetCostShare(Budget.FiscalYearSummary fiscalYearSummary) {
        return new BudgetCostShare(fiscalYearSummary.getFiscalYear(), fiscalYearSummary.getCostShare(), new BudgetDecimal(0.0), null);
    }

    protected BudgetCostShare createBudgetCostShare(int projectPeriod, BudgetDecimal costShare) {
        return new BudgetCostShare(projectPeriod, costShare, new BudgetDecimal(0.0), null);
    }

    protected BudgetUnrecoveredFandA createBudgetUnrecoveredFandA(Budget.FiscalYearSummary fiscalYearSummary, BudgetDecimal applicableRate, String onCampusFlag) {
        return new BudgetUnrecoveredFandA(fiscalYearSummary.getFiscalYear(), BudgetDecimal.ZERO, applicableRate, onCampusFlag, null);
    }
}

