/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.document;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.document.BudgetDocumentTypeChecker;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.proposaldevelopment.budget.bo.ProposalDevelopmentBudgetExt;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

@ParameterConstants.NAMESPACE(namespace="KC-B")
@ParameterConstants.COMPONENT(component="Document")
public class BudgetDocument<T extends BudgetParent>
extends ResearchDocumentBase
implements Copyable,
SessionDocument,
Permissionable,
BudgetDocumentTypeChecker {
    private static final long serialVersionUID = 6716733800206633452L;
    private static final String DOCUMENT_TYPE_CODE = "BUDG";
    private String parentDocumentKey;
    private String parentDocumentTypeCode;
    private BudgetParentDocument<T> parentDocument;
    private List<Budget> budgets = new ArrayList<Budget>();
    private boolean budgetDeleted;

    @Override
    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        if (this.getParentDocumentKey() != null) {
            this.getParentDocument().processAfterRetrieveForBudget(this);
        }
        Long budgetId = this.getBudget().getBudgetId();
        try {
            List<BudgetPeriod> budgetPeriods = this.getBudget().getBudgetPeriods();
            for (BudgetPeriod budgetPeriod : budgetPeriods) {
                ObjectUtils.setObjectPropertyDeep((Object)budgetPeriod, (String)"budgetId", Long.class, (Object)budgetId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize() {
    }

    public Integer getHackedDocumentNextValue(String propertyName) {
        DocumentNextvalue documentNextvalue;
        Integer propNextValue = 1;
        for (DocumentNextvalue element : this.getDocumentNextvalues()) {
            documentNextvalue = element;
            if (!documentNextvalue.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            propNextValue = documentNextvalue.getNextValue();
            documentNextvalue.setNextValue(propNextValue + 1);
        }
        if (propNextValue == 1) {
            BusinessObjectService bos = this.getService(BusinessObjectService.class);
            HashMap<String, Object> pkMap = new HashMap<String, Object>();
            pkMap.put("documentKey", this.getBudget().getBudgetId());
            pkMap.put("propertyName", propertyName);
            documentNextvalue = (DocumentNextvalue)bos.findByPrimaryKey(DocumentNextvalue.class, pkMap);
            if (documentNextvalue != null) {
                propNextValue = documentNextvalue.getNextValue();
                documentNextvalue.setNextValue(propNextValue + 1);
                this.getDocumentNextvalues().add(documentNextvalue);
            }
        }
        if (propNextValue == 1) {
            DocumentNextvalue documentNextvalue2 = new DocumentNextvalue();
            documentNextvalue2.setNextValue(propNextValue + 1);
            documentNextvalue2.setPropertyName(propertyName);
            documentNextvalue2.setDocumentKey(this.getDocumentNumber());
            this.getDocumentNextvalues().add(documentNextvalue2);
        }
        this.setDocumentNextvalues(this.getDocumentNextvalues());
        return propNextValue;
    }

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        this.getParentDocument().saveBudgetFinalVersionStatus(this);
        if (this.getParentDocument() != null) {
            if (this.getParentDocument().getBudgetDocumentVersions() != null) {
                this.updateDocumentDescriptions(this.getParentDocument().getBudgetDocumentVersions());
            }
        } else {
            this.refreshReferenceObject("parentDocument");
        }
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
        this.getBudget().getRateClassTypes();
        this.getBudget().handlePeriodToProjectIncomeRelationship();
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.addAll(this.getBudget().buildListOfDeletionAwareLists());
        managedLists.add(this.budgets);
        return managedLists;
    }

    public BudgetParentDocument<T> getParentDocument() {
        return this.parentDocument;
    }

    public void setParentDocument(BudgetParentDocument<T> parentDocument) {
        this.parentDocument = parentDocument;
    }

    public List<Budget> getBudgets() {
        return this.budgets;
    }

    public void setBudgets(List<Budget> budgets) {
        this.budgets = budgets;
    }

    public Budget getBudget() {
        if (this.getBudgets().isEmpty() && !this.isBudgetDeleted()) {
            this.budgets.add(new ProposalDevelopmentBudgetExt());
        } else if (this.isBudgetDeleted()) {
            return new ProposalDevelopmentBudgetExt();
        }
        return this.budgets.get(0);
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public String getParentDocumentKey() {
        return this.parentDocumentKey;
    }

    public void setParentDocumentKey(String parentDocumentNumber) {
        this.parentDocumentKey = parentDocumentNumber;
    }

    public String getParentDocumentTypeCode() {
        return this.parentDocumentTypeCode;
    }

    public void setParentDocumentTypeCode(String parentDocumentTypeCode) {
        this.parentDocumentTypeCode = parentDocumentTypeCode;
    }

    public boolean useCustomLockDescriptors() {
        return true;
    }

    public String getCustomLockDescriptor(Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        String updatedTimestamp = "";
        if (this.getUpdateTimestamp() != null) {
            updatedTimestamp = new SimpleDateFormat("MM/dd/yyyy KK:mm a").format(this.getUpdateTimestamp());
        }
        if (StringUtils.isNotEmpty((String)activeLockRegion)) {
            BudgetParentDocument<T> parent = this.getParentDocument();
            if (parent != null) {
                return this.getBudget().getBudgetId() + "-" + activeLockRegion + "-" + activeLockRegion + "-" + GlobalVariables.getUserSession().getPrincipalName() + "-" + updatedTimestamp;
            }
            return this.getBudget().getBudgetId() + "-" + activeLockRegion + "-" + activeLockRegion + "-" + GlobalVariables.getUserSession().getPrincipalName() + "-" + updatedTimestamp;
        }
        return null;
    }

    @Override
    public String getDocumentKey() {
        return this.getParentDocument().getBudgetPermissionable().getDocumentKey();
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.getDocumentNumber();
    }

    @Override
    public List<String> getRoleNames() {
        return this.getParentDocument().getBudgetPermissionable().getRoleNames();
    }

    @Override
    public String getNamespace() {
        return "KC-B";
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getParentDocument().getBudgetPermissionable().getLeadUnitNumber();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return "KC-PD";
    }

    @Override
    public String getProposalBudgetFlag() {
        return this.getParentDocument().getProposalBudgetFlag();
    }

    public List<String> getLockClearningMethodNames() {
        List methodToCalls = super.getLockClearningMethodNames();
        methodToCalls.add("returnToProposal");
        methodToCalls.add("returnToAward");
        return methodToCalls;
    }

    public void documentHasBeenRejected(String reason) {
    }

    public boolean isBudgetDeleted() {
        return this.budgetDeleted;
    }

    public void setBudgetDeleted(boolean budgetDeleted) {
        this.budgetDeleted = budgetDeleted;
    }

    @Override
    public boolean isProcessComplete() {
        return true;
    }

    public Date getBudgetStartDate() {
        if (StringUtils.equalsIgnoreCase((String)"true", (String)this.getProposalBudgetFlag())) {
            ProposalDevelopmentDocument pdd = (ProposalDevelopmentDocument)this.getParentDocument();
            return pdd.getDevelopmentProposal().getRequestedStartDateInitial();
        }
        AwardDocument ad = (AwardDocument)this.getParentDocument();
        return ad.getAward().getAwardAmountInfos().get(ad.getAward().getAwardAmountInfos().size() - 1).getCurrentFundEffectiveDate();
    }

    public Date getBudgetEndDate() {
        if (StringUtils.equalsIgnoreCase((String)"true", (String)this.getProposalBudgetFlag())) {
            ProposalDevelopmentDocument pdd = (ProposalDevelopmentDocument)this.getParentDocument();
            return pdd.getDevelopmentProposal().getRequestedEndDateInitial();
        }
        AwardDocument ad = (AwardDocument)this.getParentDocument();
        return ad.getAward().getAwardAmountInfos().get(ad.getAward().getAwardAmountInfos().size() - 1).getObligationExpirationDate();
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return new ArrayList();
    }
}

