/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.budget.AwardBudgeCostTotalAuditRule;
import org.kuali.kra.award.budget.AwardBudgetBudgetTypeAuditRule;
import org.kuali.kra.award.budget.AwardBudgetCostLimitAuditRule;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.distributionincome.AddBudgetCostShareEvent;
import org.kuali.kra.budget.distributionincome.AddBudgetCostShareRule;
import org.kuali.kra.budget.distributionincome.AddBudgetProjectIncomeEvent;
import org.kuali.kra.budget.distributionincome.AddBudgetProjectIncomeRule;
import org.kuali.kra.budget.distributionincome.BudgetCostShare;
import org.kuali.kra.budget.distributionincome.BudgetCostShareAuditRule;
import org.kuali.kra.budget.distributionincome.BudgetCostShareRuleImpl;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncomeRuleImpl;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandAAuditRule;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetExpensesAuditRule;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.AddBudgetPeriodEvent;
import org.kuali.kra.budget.parameters.AddBudgetPeriodRule;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.parameters.BudgetPeriodAuditRule;
import org.kuali.kra.budget.parameters.BudgetPeriodRule;
import org.kuali.kra.budget.parameters.DeleteBudgetPeriodEvent;
import org.kuali.kra.budget.parameters.DeleteBudgetPeriodRule;
import org.kuali.kra.budget.parameters.GenerateBudgetPeriodEvent;
import org.kuali.kra.budget.parameters.GenerateBudgetPeriodRule;
import org.kuali.kra.budget.parameters.SaveBudgetPeriodEvent;
import org.kuali.kra.budget.parameters.SaveBudgetPeriodRule;
import org.kuali.kra.budget.personnel.BudgetPersonnelAuditRule;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.BudgetPersonnelRule;
import org.kuali.kra.budget.rates.BudgetLaRate;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.BudgetRateAuditRule;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.costshare.CostShareRuleResearchDocumentBase;
import org.kuali.kra.proposaldevelopment.budget.modular.SyncModularBudgetRule;
import org.kuali.kra.rules.ActivityTypeAuditRule;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetDocumentRule
extends CostShareRuleResearchDocumentBase
implements AddBudgetPeriodRule,
AddBudgetCostShareRule,
AddBudgetProjectIncomeRule,
SaveBudgetPeriodRule,
DeleteBudgetPeriodRule,
GenerateBudgetPeriodRule,
DocumentAuditRule,
SyncModularBudgetRule {
    @Override
    public boolean processAddBudgetCostShareBusinessRules(AddBudgetCostShareEvent addBudgetCostShareEvent) {
        return new BudgetCostShareRuleImpl().processAddBudgetCostShareBusinessRules(addBudgetCostShareEvent);
    }

    @Override
    public boolean processAddBudgetPeriodBusinessRules(AddBudgetPeriodEvent addBudgetPeriodEvent) {
        return new BudgetPeriodRule().processAddBudgetPeriodBusinessRules(addBudgetPeriodEvent);
    }

    @Override
    public boolean processAddBudgetProjectIncomeBusinessRules(AddBudgetProjectIncomeEvent addBudgetIncomeEvent) {
        return new BudgetProjectIncomeRuleImpl().processAddBudgetProjectIncomeBusinessRules(addBudgetIncomeEvent);
    }

    @Override
    public boolean processSaveBudgetPeriodBusinessRules(SaveBudgetPeriodEvent saveBudgetPeriodEvent) {
        return new BudgetPeriodRule().processSaveBudgetPeriodBusinessRules(saveBudgetPeriodEvent);
    }

    @Override
    public boolean processDeleteBudgetPeriodBusinessRules(DeleteBudgetPeriodEvent deleteBudgetPeriodEvent) {
        return new BudgetPeriodRule().processDeleteBudgetPeriodBusinessRules(deleteBudgetPeriodEvent);
    }

    @Override
    public boolean processGenerateBudgetPeriodBusinessRules(GenerateBudgetPeriodEvent generateBudgetPeriodEvent) {
        return new BudgetPeriodRule().processGenerateBudgetPeriodBusinessRules(generateBudgetPeriodEvent);
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        if (!(document instanceof BudgetDocument)) {
            return false;
        }
        boolean valid = true;
        BudgetDocument budgetDocument = (BudgetDocument)document;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        this.getDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), true, false);
        GlobalVariables.getMessageMap().addToErrorPath("parentDocument");
        if (ObjectUtils.isNull(budgetDocument.getParentDocument())) {
            budgetDocument.refreshReferenceObject("parentDocument");
        }
        if (Boolean.valueOf(budgetDocument.getParentDocument().getProposalBudgetFlag()).booleanValue()) {
            valid &= this.processBudgetVersionsBusinessRule(budgetDocument.getParentDocument(), true);
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("parentDocument");
        GlobalVariables.getMessageMap().addToErrorPath("budget");
        valid &= this.processBudgetPersonnelBusinessRules(budgetDocument);
        valid &= this.processBudgetExpenseBusinessRules(budgetDocument);
        valid &= this.processBudgetPersonnelBudgetBusinessRules(budgetDocument);
        valid &= this.processBudgetRatesBusinessRule(budgetDocument);
        GlobalVariables.getMessageMap().removeFromErrorPath("budget");
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return valid &= this.processBudgetProjectIncomeBusinessRule(budgetDocument);
    }

    protected boolean processBudgetProjectIncomeBusinessRule(BudgetDocument budgetDocument) {
        String errorPath;
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int i = 0;
        for (BudgetCostShare budgetCostShare : budgetDocument.getBudget().getBudgetCostShares()) {
            errorPath = "budgetCostShare[" + i + "]";
            errorMap.addToErrorPath(errorPath);
            if (budgetCostShare.getSharePercentage() != null && (budgetCostShare.getSharePercentage().isLessThan(new BudgetDecimal(0)) || budgetCostShare.getSharePercentage().isGreaterThan(new BudgetDecimal(100)))) {
                errorMap.putError("sharePercentage", "error.costSharing.percentage", new String[0]);
                valid = false;
            }
            if (i < budgetDocument.getBudget().getBudgetCostShareCount()) {
                for (int j = i + 1; j < budgetDocument.getBudget().getBudgetCostShareCount(); ++j) {
                    int otherFiscalYear;
                    BudgetCostShare tmpCostShare = budgetDocument.getBudget().getBudgetCostShare(j);
                    int thisFiscalYear = budgetCostShare.getProjectPeriod() == null ? Integer.MIN_VALUE : budgetCostShare.getProjectPeriod();
                    int n = otherFiscalYear = tmpCostShare.getProjectPeriod() == null ? Integer.MIN_VALUE : tmpCostShare.getProjectPeriod();
                    if (thisFiscalYear != otherFiscalYear || !StringUtils.equalsIgnoreCase((String)budgetCostShare.getSourceAccount(), (String)tmpCostShare.getSourceAccount())) continue;
                    errorMap.putError("fiscalYear", "error.costSharing.duplicate", new String[]{thisFiscalYear == Integer.MIN_VALUE ? "" : thisFiscalYear + "", budgetCostShare.getSourceAccount() == null ? "\"\"" : budgetCostShare.getSourceAccount()});
                    valid = false;
                }
            }
            String currentField = "document.budget.budgetCostShare[" + i + "].projectPeriod";
            int numberOfProjectPeriods = budgetDocument.getBudget().getBudgetPeriods().size();
            boolean validationCheck = this.validateProjectPeriod(budgetCostShare.getProjectPeriod(), currentField, numberOfProjectPeriods);
            valid &= validationCheck;
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("budget");
        GlobalVariables.getMessageMap().addToErrorPath("budgets[0]");
        i = 0;
        for (BudgetProjectIncome budgetProjectIncome : budgetDocument.getBudget().getBudgetProjectIncomes()) {
            errorPath = "budgetProjectIncomes[" + i + "]";
            errorMap.addToErrorPath(errorPath);
            if (budgetProjectIncome.getProjectIncome() == null || !budgetProjectIncome.getProjectIncome().isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0.0))) {
                errorMap.putError("projectIncome", "error.projectIncome.negativeOrZero", new String[0]);
                valid = false;
            }
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("budgets[0]");
        GlobalVariables.getMessageMap().addToErrorPath("budget");
        return valid;
    }

    protected boolean processBudgetRatesBusinessRule(BudgetDocument budgetDocument) {
        String errorPath;
        String rateClassType;
        boolean valid = true;
        boolean APPLICABLE_RATE_LENGTH_EXCEEDED = true;
        int APPLICABLE_RATE_NEGATIVE = -1;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int i = 0;
        for (BudgetRate budgetRate : budgetDocument.getBudget().getBudgetRates()) {
            rateClassType = budgetRate.getRateClass().getRateClassTypeT().getDescription();
            errorPath = "budgetProposalRate[" + rateClassType + "][" + i + "]";
            errorMap.addToErrorPath(errorPath);
            if (budgetRate.isApplicableRateNull()) {
                valid = false;
                errorMap.putError("applicableRate", "error.required.applicableRate", new String[0]);
            } else if (!BudgetDecimal.isNumeric((String)budgetRate.getApplicableRate().toString())) {
                valid = false;
                errorMap.putError("applicableRate", "error.applicableRate.notNumeric", new String[0]);
            } else {
                switch (this.verifyApplicableRate(budgetRate.getApplicableRate())) {
                    case 1: {
                        valid = false;
                        errorMap.putError("applicableRate", "error.applicableRate.limit", new String[]{"999.99"});
                        break;
                    }
                    case -1: {
                        valid = false;
                        errorMap.putError("applicableRate", "error.applicableRate.negative", new String[0]);
                    }
                }
            }
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        i = 0;
        for (BudgetLaRate budgetLaRate : budgetDocument.getBudget().getBudgetLaRates()) {
            rateClassType = "";
            if (ObjectUtils.isNotNull((Object)((Object)budgetLaRate.getRateClass())) && ObjectUtils.isNotNull((Object)((Object)budgetLaRate.getRateClass().getRateClassTypeT()))) {
                rateClassType = budgetLaRate.getRateClass().getRateClassTypeT().getDescription();
            }
            errorPath = "budgetRate[" + rateClassType + "][" + i + "]";
            errorMap.addToErrorPath(errorPath);
            if (budgetLaRate.isApplicableRateNull()) {
                valid = false;
                errorMap.putError("applicableRate", "error.required.applicableRate", new String[0]);
            } else if (!BudgetDecimal.isNumeric((String)budgetLaRate.getApplicableRate().toString())) {
                valid = false;
                errorMap.putError("applicableRate", "error.applicableRate.notNumeric", new String[0]);
            } else {
                switch (this.verifyApplicableRate(budgetLaRate.getApplicableRate())) {
                    case 1: {
                        valid = false;
                        errorMap.putError("applicableRate", "error.applicableRate.limit", new String[]{"999.99"});
                        break;
                    }
                    case -1: {
                        valid = false;
                        errorMap.putError("applicableRate", "error.applicableRate.negative", new String[0]);
                    }
                }
            }
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        return valid;
    }

    private int verifyApplicableRate(BudgetDecimal applicableRate) {
        int rateValue = 0;
        if (applicableRate.isNegative()) {
            rateValue = -1;
        } else if (applicableRate.isGreaterThan(new BudgetDecimal("999.99"))) {
            rateValue = 1;
        }
        return rateValue;
    }

    protected boolean processBudgetPersonnelBusinessRules(BudgetDocument budgetDocument) {
        return new BudgetPersonnelRule().processBudgetPersonnelBusinessRules(budgetDocument);
    }

    protected boolean processBudgetExpenseBusinessRules(BudgetDocument budgetDocument) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        List<BudgetPeriod> budgetPeriods = budgetDocument.getBudget().getBudgetPeriods();
        int i = 0;
        int j = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            j = 0;
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                if (budgetLineItem != null && budgetLineItem.getStartDate() != null && budgetLineItem.getStartDate().before(budgetPeriod.getStartDate())) {
                    errorMap.putError("budgetCategoryTypes[" + budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode() + "].budgetPeriods[" + i + "].budgetLineItems[" + j + "].startDate", "error.lineItemStartDate.before.periodStartDate", new String[0]);
                    valid = false;
                }
                if (budgetLineItem != null && budgetLineItem.getEndDate() != null && budgetLineItem.getEndDate().after(budgetPeriod.getEndDate())) {
                    errorMap.putError("budgetCategoryTypes[" + budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode() + "].budgetPeriods[" + i + "].budgetLineItems[" + j + "].endDate", "error.lineItemEndDate.after.periodEndDate", new String[0]);
                    valid = false;
                }
                if (budgetLineItem != null && budgetLineItem.getQuantity() != null && budgetLineItem.getQuantity() < 0) {
                    errorMap.putError("budgetPeriod[" + i + "].budgetLineItem[" + j + "].quantity", "error.negativeAmount", new String[]{"Quantity"});
                    valid = false;
                }
                ++j;
            }
            ++i;
        }
        return valid;
    }

    protected boolean processBudgetPersonnelBudgetBusinessRules(BudgetDocument budgetDocument) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        List<BudgetPeriod> budgetPeriods = budgetDocument.getBudget().getBudgetPeriods();
        int i = 0;
        int j = 0;
        int k = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            j = 0;
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            k = 0;
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    if (budgetPersonnelDetails != null && budgetPersonnelDetails.getStartDate() != null && budgetPersonnelDetails.getStartDate().before(budgetLineItem.getStartDate())) {
                        errorMap.putError("budgetPeriod[" + i + "].budgetLineItems[" + j + "].budgetPersonnelDetailsList[" + k + "].startDate", "error.personnelBudgetLinelineItemStartDate.before.lineItemStartDate", new String[0]);
                        valid = false;
                    }
                    if (budgetPersonnelDetails != null && budgetPersonnelDetails.getEndDate() != null && budgetPersonnelDetails.getEndDate().after(budgetLineItem.getEndDate())) {
                        errorMap.putError("budgetPeriod[" + i + "].budgetLineItems[" + j + "].budgetPersonnelDetailsList[" + k + "].endDate", "error.personnelBudgetLineItemEndDate.after.lineItemEndDate", new String[0]);
                        valid = false;
                    }
                    if (budgetPersonnelDetails.getPercentEffort().isGreaterThan(new BudgetDecimal(100))) {
                        errorMap.putError("budgetPeriod[" + i + "].budgetLineItems[" + j + "].budgetPersonnelDetailsList[" + k + "].percentEffort", "error.percentage", new String[]{"Percent Effort"});
                    }
                    if (budgetPersonnelDetails.getPercentCharged().isGreaterThan(new BudgetDecimal(100))) {
                        errorMap.putError("budgetPeriod[" + i + "].budgetLineItems[" + j + "].budgetPersonnelDetailsList[" + k + "].percentCharged", "error.percentage", new String[]{"Percent Charged"});
                    }
                    if (budgetPersonnelDetails.getPercentCharged().isGreaterThan(budgetPersonnelDetails.getPercentEffort())) {
                        errorMap.putError("budgetPeriod[" + i + "].budgetLineItems[" + j + "].budgetPersonnelDetailsList[" + k + "].percentCharged", "error.percentEffort.lessThan.percentCharged", new String[0]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return valid;
    }

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = true;
        retval &= super.processRunAuditBusinessRules(document);
        retval &= new BudgetPeriodAuditRule().processRunAuditBusinessRules(document);
        retval &= new BudgetExpensesAuditRule().processRunAuditBusinessRules(document);
        retval &= new BudgetPersonnelAuditRule().processRunPersonnelAuditBusinessRules(document);
        retval &= new BudgetRateAuditRule().processRunAuditBusinessRules(document);
        if (!(document instanceof AwardBudgetDocument)) {
            retval &= new BudgetUnrecoveredFandAAuditRule().processRunAuditBusinessRules(document);
            retval &= new BudgetCostShareAuditRule().processRunAuditBusinessRules(document);
        }
        retval &= new ActivityTypeAuditRule().processRunAuditBusinessRules(document);
        if (!Boolean.valueOf(((BudgetDocument)document).getParentDocument().getProposalBudgetFlag()).booleanValue()) {
            retval &= new AwardBudgetBudgetTypeAuditRule().processRunAuditBusinessRules(document);
            retval &= new AwardBudgeCostTotalAuditRule().processRunAuditBusinessRules(document);
            retval &= new AwardBudgetCostLimitAuditRule().processRunAuditBusinessRules(document);
        }
        if (retval) {
            this.processRunAuditBudgetVersionRule(((BudgetDocument)document).getParentDocument());
        }
        return retval;
    }

    protected boolean processRunAuditBudgetVersionRule(BudgetParentDocument parentDocument) {
        boolean finalAndCompleteBudgetVersionFound = false;
        boolean budgetVersionsExists = false;
        boolean retval = true;
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        String budgetStatusCompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode");
        for (BudgetDocumentVersion budgetDocumentVersion : parentDocument.getBudgetDocumentVersions()) {
            Object budgetParent;
            BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
            budgetVersionsExists = true;
            if (!budgetVersion.isFinalVersionFlag() || (budgetParent = parentDocument.getBudgetParent()).getBudgetStatus() == null || !budgetParent.getBudgetStatus().equals(budgetStatusCompleteCode)) continue;
            finalAndCompleteBudgetVersionFound = true;
        }
        if (budgetVersionsExists && !finalAndCompleteBudgetVersionFound) {
            auditErrors.add(new AuditError("document.parentBudget.budgetVersionOverview", "error.no.budgetVersion.completeAndFinal", "budgetVersions.BudgetVersions"));
            retval = false;
        }
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("budgetVersionErrors", new AuditCluster("Budget Versions", auditErrors, "Validation Errors"));
        }
        return retval;
    }

    @Override
    public boolean processSyncModularBusinessRules(Document document) {
        if (!(document instanceof BudgetDocument)) {
            return false;
        }
        boolean valid = true;
        BudgetDocument budgetDocument = (BudgetDocument)document;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        List<BudgetPeriod> budgetPeriods = budgetDocument.getBudget().getBudgetPeriods();
        if (ObjectUtils.isNotNull(budgetPeriods) || budgetPeriods.size() >= 1) {
            BudgetPeriod period1 = budgetPeriods.get(0);
            if (ObjectUtils.isNull(period1.getBudgetLineItems()) || period1.getBudgetLineItems().isEmpty()) {
                valid = false;
            }
        } else {
            valid = false;
        }
        if (!valid) {
            GlobalVariables.getMessageMap().putError("modularBudget", "error.modular.noDetail", new String[0]);
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return valid;
    }

    private List<AuditError> getAuditErrors() {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey("budgetPersonnelAuditErrors")) {
            KNSGlobalVariables.getAuditErrorMap().put("budgetPersonnelAuditErrors", new AuditCluster("Budget Personnel Information", auditErrors, "Validation Errors"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get("budgetPersonnelAuditErrors")).getAuditErrorList();
        }
        return auditErrors;
    }
}

