/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.document;

import java.util.Collections;
import java.util.List;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetDocumentTypeChecker;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionCollection;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.datadictionary.KNSDocumentEntry;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.web.ui.ExtraButton;

public abstract class BudgetParentDocument<T extends BudgetParent>
extends ResearchDocumentBase
implements BudgetVersionCollection,
BudgetDocumentTypeChecker,
Permissionable {
    protected ParameterService getParameterService() {
        return KraServiceLocator.getService(ParameterService.class);
    }

    public BudgetDocumentVersion getFinalBudgetVersion() {
        for (BudgetDocumentVersion version : this.getBudgetDocumentVersions()) {
            if (!version.getBudgetVersionOverview().isFinalVersionFlag()) continue;
            return version;
        }
        return null;
    }

    public Integer getNextBudgetVersionNumber() {
        List versions = this.getBudgetDocumentVersions();
        if (versions.isEmpty()) {
            return 1;
        }
        Collections.sort(versions);
        BudgetDocumentVersion lastVersion = (BudgetDocumentVersion)versions.get(versions.size() - 1);
        return lastVersion.getBudgetVersionOverview().getBudgetVersionNumber() + 1;
    }

    public void addNewBudgetVersion(BudgetDocument budgetDocument, String name, boolean isDescriptionUpdatable) {
        Budget budget = budgetDocument.getBudget();
        BudgetDocumentVersion budgetDocumentVersion = new BudgetDocumentVersion();
        budgetDocumentVersion.setDocumentNumber(budgetDocument.getDocumentNumber());
        budgetDocumentVersion.setParentDocumentKey(this.getDocumentNumber());
        budgetDocumentVersion.setVersionNumber(budgetDocument.getVersionNumber());
        BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
        budgetVersion.setDocumentNumber(budgetDocument.getDocumentNumber());
        budgetVersion.setDocumentDescription(name);
        budgetVersion.setBudgetVersionNumber(budget.getBudgetVersionNumber());
        budgetVersion.setStartDate(budget.getStartDate());
        budgetVersion.setEndDate(budget.getEndDate());
        budgetVersion.setOhRateTypeCode(budget.getOhRateTypeCode());
        budgetVersion.setOhRateClassCode(budget.getOhRateClassCode());
        budgetVersion.setVersionNumber(budget.getVersionNumber());
        budgetVersion.setDescriptionUpdatable(isDescriptionUpdatable);
        String budgetStatusIncompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusIncompleteCode");
        budgetVersion.setBudgetStatus(budgetStatusIncompleteCode);
        budgetVersion.setFinalVersionFlag(false);
        this.getBudgetDocumentVersions().add(budgetDocumentVersion);
    }

    public BudgetDocumentVersion getBudgetDocumentVersion(int selectedLine) {
        return (BudgetDocumentVersion)this.getBudgetDocumentVersions().get(selectedLine);
    }

    public abstract Permissionable getBudgetPermissionable();

    public abstract boolean isComplete();

    public abstract void saveBudgetFinalVersionStatus(BudgetDocument var1);

    public abstract void processAfterRetrieveForBudget(BudgetDocument var1);

    public abstract String getTaskGroupName();

    public abstract Task getParentAuthZTask(String var1);

    public abstract ExtraButton configureReturnToParentTopButton();

    public List<HeaderNavigation> getBudgetHeaderNavigatorList() {
        DataDictionaryService dataDictionaryService = (DataDictionaryService)KraServiceLocator.getService("dataDictionaryService");
        KNSDocumentEntry docEntry = (KNSDocumentEntry)dataDictionaryService.getDataDictionary().getDocumentEntry(BudgetDocument.class.getName());
        return docEntry.getHeaderNavigationList();
    }

    public abstract T getBudgetParent();
}

