/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.document.authorizer;

import org.kuali.kra.authorization.Task;
import org.kuali.kra.authorization.TaskAuthorizerImpl;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.document.authorization.BudgetTask;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;

public abstract class BudgetAuthorizer
extends TaskAuthorizerImpl {
    private KraAuthorizationService kraAuthorizationService;
    private boolean requiresWritableDoc = false;

    @Override
    public boolean isAuthorized(String userId, Task task) {
        BudgetTask budgetTask = (BudgetTask)task;
        if (this.isRequiresWritableDoc() && budgetTask.getBudgetDocument().isViewOnly()) {
            return false;
        }
        return this.isAuthorized(userId, budgetTask);
    }

    public boolean isAuthorized(String userId, BudgetTask task) {
        return true;
    }

    public final void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    protected final boolean hasParentPermission(String userId, BudgetParentDocument doc, String permissionName) {
        return this.kraAuthorizationService.hasPermission(userId, doc, permissionName);
    }

    protected boolean hasParentPermission(String userId, BudgetParentDocument doc, String permissionNamespace, String permissionName) {
        return this.kraAuthorizationService.hasPermission(userId, doc, permissionName);
    }

    protected WorkflowDocument getWorkflowDocument(Document doc) {
        DocumentHeader header;
        WorkflowDocument workflowDocument = null;
        if (doc != null && (header = doc.getDocumentHeader()) != null) {
            try {
                workflowDocument = header.getWorkflowDocument();
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        return workflowDocument;
    }

    public boolean isRequiresWritableDoc() {
        return this.requiresWritableDoc;
    }

    public void setRequiresWritableDoc(boolean requiresWritableDoc) {
        this.requiresWritableDoc = requiresWritableDoc;
    }
}

