/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.KeyValueFinderService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

public class BudgetPeriodValuesFinder
extends KeyValuesBase {
    KeyValueFinderService keyValueFinderService = (KeyValueFinderService)KraServiceLocator.getService("keyValueFinderService");

    public List<KeyValue> getKeyValues() {
        List<BudgetPeriod> budgetPeriods;
        Document doc;
        List<KeyValue> KeyValues = null;
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form instanceof KualiDocumentFormBase && (doc = ((KualiDocumentFormBase)form).getDocument()) instanceof BudgetDocument && (budgetPeriods = ((BudgetDocument)doc).getBudget().getBudgetPeriods()).size() > 0) {
            KeyValues = this.buildKeyValues(budgetPeriods);
        }
        if (KeyValues == null) {
            KeyValues = this.keyValueFinderService.getKeyValues(BudgetPeriod.class, "budgetPeriod", "label");
        }
        return KeyValues;
    }

    private List<KeyValue> buildKeyValues(List<BudgetPeriod> budgetPeriods) {
        ArrayList<KeyValue> KeyValues = new ArrayList<KeyValue>();
        KeyValues.add((KeyValue)new ConcreteKeyValue(null, "Select"));
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            KeyValues.add((KeyValue)new ConcreteKeyValue(budgetPeriod.getBudgetPeriod().toString(), budgetPeriod.getLabel()));
        }
        return KeyValues;
    }
}

