/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.lookup.keyvalue;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.KeyValueFinderService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetPersonValuesFinder
extends KeyValuesBase {
    KeyValueFinderService keyValueFinderService = (KeyValueFinderService)KraServiceLocator.getService("keyValueFinderService");

    public List<KeyValue> getKeyValues() {
        Document doc;
        List<KeyValue> KeyValues = null;
        BusinessObjectService boService = KRADServiceLocator.getBusinessObjectService();
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form instanceof KualiDocumentFormBase && (doc = ((KualiDocumentFormBase)form).getDocument()) instanceof BudgetDocument) {
            BudgetDocument budgetDocument = (BudgetDocument)doc;
            Budget budget = budgetDocument.getBudget();
            HashMap<String, Long> queryMap = new HashMap<String, Long>();
            queryMap.put("budgetId", budget.getBudgetId());
            List budgetPersons = (List)boService.findMatching(BudgetPerson.class, queryMap);
            KeyValues = this.buildKeyValues(budgetPersons);
        }
        return KeyValues;
    }

    private List<KeyValue> buildKeyValues(List<BudgetPerson> budgetPersons) {
        ArrayList<KeyValue> KeyValues = new ArrayList<KeyValue>();
        KeyValues.add((KeyValue)new ConcreteKeyValue(null, "Select"));
        List dupBudgetPersons = (List)((Object)ObjectUtils.deepCopy((Serializable)((Serializable)((Object)budgetPersons))));
        for (BudgetPerson budgetPerson : budgetPersons) {
            if (!StringUtils.isNotBlank((String)budgetPerson.getJobCode()) || !StringUtils.isNotBlank((String)budgetPerson.getAppointmentTypeCode()) || !budgetPerson.getCalculationBase().isGreaterEqual(BudgetDecimal.ZERO) || budgetPerson.getEffectiveDate() == null) continue;
            boolean duplicatePerson = false;
            for (BudgetPerson dupBudgetPerson : dupBudgetPersons) {
                if ((dupBudgetPerson.getPersonId() == null || !dupBudgetPerson.getPersonId().equals(budgetPerson.getPersonId())) && (dupBudgetPerson.getRolodexId() == null || !dupBudgetPerson.getRolodexId().equals(budgetPerson.getRolodexId())) || !dupBudgetPerson.getEffectiveDate().before(budgetPerson.getEffectiveDate()) || !dupBudgetPerson.getJobCode().equals(budgetPerson.getJobCode())) continue;
                duplicatePerson = true;
            }
            if (duplicatePerson) continue;
            KeyValues.add((KeyValue)new ConcreteKeyValue(budgetPerson.getPersonSequenceNumber().toString(), budgetPerson.getPersonName() + " - " + budgetPerson.getJobCode()));
        }
        KeyValues.add((KeyValue)new ConcreteKeyValue("-1", "Summary"));
        return KeyValues;
    }
}

