/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.nonpersonnel;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class BudgetExpenseRule {
    private static final double MAX_BUDGET_DECIMAL_VALUE = 9.999999999E9;
    private static final String PERSONNEL_CATEGORY = "P";

    public boolean processCheckExistBudgetPersonnelDetailsBusinessRules(BudgetDocument budgetDocument, BudgetLineItem budgetLineItem, int lineItemToDelete) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (CollectionUtils.isNotEmpty(budgetLineItem.getBudgetPersonnelDetailsList())) {
            errorMap.putError("document.budgetPeriod[" + (budgetLineItem.getBudgetPeriod() - 1) + "].budgetLineItem[" + lineItemToDelete + "].costElement", "error.delete.lineitem", new String[0]);
            valid = false;
        }
        return valid;
    }

    public boolean processApplyToLaterPeriodsWithPersonnelDetails(BudgetDocument budgetDocument, BudgetPeriod currentBudgetPeriod, BudgetLineItem currentBudgetLineItem, int selectedLineItem) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        List<BudgetPeriod> budgetPeriods = budgetDocument.getBudget().getBudgetPeriods();
        BudgetLineItem prevBudgetLineItem = currentBudgetLineItem;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetPeriod() <= currentBudgetPeriod.getBudgetPeriod()) continue;
            QueryList<BudgetLineItem> currentBudgetPeriodLineItems = new QueryList<BudgetLineItem>(budgetPeriod.getBudgetLineItems());
            for (BudgetLineItem budgetLineItemToBeApplied : currentBudgetPeriodLineItems) {
                if (prevBudgetLineItem.getLineItemNumber().equals(budgetLineItemToBeApplied.getBasedOnLineItem())) {
                    if (!budgetLineItemToBeApplied.getBudgetCategory().getBudgetCategoryTypeCode().equals(PERSONNEL_CATEGORY) || budgetLineItemToBeApplied.getBudgetPersonnelDetailsList().isEmpty() && prevBudgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) continue;
                    errorMap.putError("document.budgetPeriod[" + (currentBudgetLineItem.getBudgetPeriod() - 1) + "].budgetLineItem[" + selectedLineItem + "].costElement", "error.applyTo.later.periods", new String[]{budgetLineItemToBeApplied.getBudgetPeriod().toString()});
                    return false;
                }
                if (!StringUtils.equals((String)currentBudgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (String)PERSONNEL_CATEGORY) || !StringUtils.equals((String)currentBudgetLineItem.getCostElement(), (String)budgetLineItemToBeApplied.getCostElement()) || !StringUtils.equals((String)currentBudgetLineItem.getGroupName(), (String)budgetLineItemToBeApplied.getGroupName())) continue;
                errorMap.putError("document.budgetPeriod[" + (currentBudgetLineItem.getBudgetPeriod() - 1) + "].budgetLineItem[" + selectedLineItem + "].costElement", "error.personnelLineItem.applyTo.later.periods", new String[]{budgetLineItemToBeApplied.getBudgetPeriod().toString()});
                return false;
            }
        }
        return true;
    }

    public boolean processCheckLineItemDates(BudgetDocument budgetDocument) {
        boolean valid = true;
        List<BudgetPeriod> budgetPeriods = budgetDocument.getBudget().getBudgetPeriods();
        int numLineItems = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            numLineItems = budgetPeriod.getBudgetLineItems().size();
            for (int i = 0; i < numLineItems; ++i) {
                valid &= this.processCheckLineItemDates(budgetPeriod, i);
            }
        }
        return valid;
    }

    public boolean processCheckLineItemDates(BudgetPeriod currentBudgetPeriod, int selectedLineItem) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        BudgetLineItem budgetLineItem = currentBudgetPeriod.getBudgetLineItems().get(selectedLineItem);
        if (budgetLineItem.getEndDate() == null) {
            errorMap.putError("document.budgetPeriod[" + (currentBudgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + selectedLineItem + "].endDate", "error.required", new String[]{"End Date"});
            valid = false;
        }
        if (budgetLineItem.getStartDate() == null) {
            errorMap.putError("document.budgetPeriod[" + (currentBudgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + selectedLineItem + "].startDate", "error.required", new String[]{"Start Date"});
            valid = false;
        }
        if (!valid) {
            return valid;
        }
        if (budgetLineItem.getEndDate().compareTo(budgetLineItem.getStartDate()) < 0) {
            errorMap.putError("document.budgetPeriod[" + (currentBudgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + selectedLineItem + "].endDate", "error.line.item.dates", new String[0]);
            valid = false;
        }
        if (currentBudgetPeriod.getEndDate().compareTo(budgetLineItem.getEndDate()) < 0) {
            errorMap.putError("document.budgetPeriod[" + (currentBudgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + selectedLineItem + "].endDate", "error.line.item.end.date", new String[]{"can not be after", "end date"});
            valid = false;
        }
        if (currentBudgetPeriod.getStartDate().compareTo(budgetLineItem.getEndDate()) > 0) {
            errorMap.putError("document.budgetPeriod[" + (currentBudgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + selectedLineItem + "].endDate", "error.line.item.end.date", new String[]{"can not be before", "start date"});
            valid = false;
        }
        if (currentBudgetPeriod.getStartDate().compareTo(budgetLineItem.getStartDate()) > 0) {
            errorMap.putError("document.budgetPeriod[" + (currentBudgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + selectedLineItem + "].startDate", "error.line.item.start.date", new String[]{"can not be before", "start date"});
            valid = false;
        }
        if (currentBudgetPeriod.getEndDate().compareTo(budgetLineItem.getStartDate()) < 0) {
            errorMap.putError("document.budgetPeriod[" + (currentBudgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + selectedLineItem + "].startDate", "error.line.item.start.date", new String[]{"can not be after", "end date"});
            valid = false;
        }
        return valid;
    }

    public boolean processBudgetFormulatedCostValidations(BudgetFormulatedCostDetail budgetFormulatedCost, int budgetPeriod, int lineItemNumber, String errorKey) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        BudgetDecimal unitCost = budgetFormulatedCost.getUnitCost();
        BudgetDecimal count = new BudgetDecimal(budgetFormulatedCost.getCount());
        BudgetDecimal frequency = new BudgetDecimal(budgetFormulatedCost.getFrequency());
        BudgetDecimal calculatedExpense = unitCost.multiply(count).multiply(frequency);
        if (unitCost.isGreaterThan(new BudgetDecimal(9.999999999E9))) {
            valid = false;
            errorMap.putError(errorKey + ".unitCost", "error.invalid.budget.formulated.unit.cost", new String[0]);
        }
        if (calculatedExpense.isGreaterThan(new BudgetDecimal(9.999999999E9))) {
            valid = false;
            errorMap.putError(errorKey + ".calculatedExpenses", "error.invalid.budget.formulated.calculated.expense", new String[0]);
        }
        return valid;
    }
}

