/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.nonpersonnel;

import java.sql.Date;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.BudgetException;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.nonpersonnel.BudgetJustificationService;
import org.kuali.kra.budget.nonpersonnel.BudgetJustificationWrapper;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetJustificationServiceImpl
implements BudgetJustificationService {
    @Override
    public void consolidateExpenseJustifications(Budget budget, BudgetJustificationWrapper budgetJustificationWrapper) throws BudgetException {
        if (!budget.areLineItemJustificationsPresent()) {
            throw new BudgetException();
        }
        this.addConsolidatedLineItemJustificationText(budget, budgetJustificationWrapper);
    }

    @Override
    public void preSave(Budget budget, BudgetJustificationWrapper budgetJustificationWrapper) {
        this.updateJustficationMetaData(budgetJustificationWrapper);
        budget.setBudgetJustification(budgetJustificationWrapper.toString());
    }

    protected String getLoggedInUserNetworkId() {
        return GlobalVariables.getUserSession().getPrincipalName();
    }

    protected Map<String, CostElement> loadCostElements() {
        Collection costElements = KraServiceLocator.getService(BusinessObjectService.class).findAll(CostElement.class);
        TreeMap<String, CostElement> costElementsMappedToCostElementCode = new TreeMap<String, CostElement>();
        for (CostElement costElement : costElements) {
            costElementsMappedToCostElementCode.put(costElement.getCostElement(), costElement);
        }
        return costElementsMappedToCostElementCode;
    }

    protected void addBudgetPeriodFooter(StringBuilder sb) {
        sb.append("\n");
    }

    protected void addBudgetPeriodHeader(StringBuilder sb, int budgetPeriodNumber) {
        sb.append("Period ");
        sb.append(budgetPeriodNumber);
        sb.append("\n");
    }

    protected void addConsolidatedLineItemJustificationText(Budget budget, BudgetJustificationWrapper budgetJustificationWrapper) {
        String existingJustificationText = budgetJustificationWrapper.getJustificationText();
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)existingJustificationText)) {
            sb.append(existingJustificationText);
            this.addLineItemJustificationTextSeparatorText(sb);
        }
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetLineItems().size() <= 0) continue;
            this.addJustificationTextByBudgetPeriod(budgetPeriod, sb);
        }
        budgetJustificationWrapper.setJustificationText(sb.toString());
    }

    protected void addJustificationTextByBudgetPeriod(BudgetPeriod budgetPeriod, StringBuilder sb) {
        Map<String, CostElement> costElementsMappedToCostElementCode = this.loadCostElements();
        boolean periodHeaderAdded = false;
        for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            periodHeaderAdded = this.addLineItemJustificationText(costElementsMappedToCostElementCode, sb, budgetPeriod.getBudgetPeriod(), periodHeaderAdded, lineItem);
        }
        if (periodHeaderAdded) {
            this.addBudgetPeriodFooter(sb);
        }
    }

    protected boolean addLineItemJustificationText(Map<String, CostElement> costElementsMappedToCostElementCode, StringBuilder sb, int budgetPeriodNumber, boolean periodHeaderAdded, BudgetLineItem lineItem) {
        String lineItemJustification = lineItem.getBudgetJustification();
        if (!StringUtils.isEmpty((String)lineItemJustification)) {
            if (!periodHeaderAdded) {
                this.addBudgetPeriodHeader(sb, budgetPeriodNumber);
                periodHeaderAdded = true;
            }
            this.addLineItemJustificationTextElements(costElementsMappedToCostElementCode, sb, lineItem, lineItemJustification);
        }
        return periodHeaderAdded;
    }

    protected void addLineItemJustificationTextElements(Map<String, CostElement> costElementsMappedToCostElementCode, StringBuilder sb, BudgetLineItem lineItem, String lineItemJustification) {
        sb.append(costElementsMappedToCostElementCode.get(lineItem.getCostElement()).getDescription());
        sb.append("\n");
        sb.append(lineItemJustification);
        sb.append("\n");
    }

    protected void addLineItemJustificationTextSeparatorText(StringBuilder sb) {
        sb.append("\n\n");
        sb.append("***************************");
        sb.append("\n\n");
    }

    protected void updateJustficationMetaData(BudgetJustificationWrapper budgetJustificationWrapper) {
        String updateUser = this.getLoggedInUserNetworkId();
        budgetJustificationWrapper.setLastUpdateUser(updateUser);
        budgetJustificationWrapper.setLastUpdateTime(new Date(System.currentTimeMillis()));
    }
}

