/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.nonpersonnel;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemBase;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetRateAndBase;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.proposaldevelopment.hierarchy.HierarchyMaintainable;

public class BudgetLineItem
extends BudgetLineItemBase
implements HierarchyMaintainable,
Comparable<BudgetLineItem> {
    private List<BudgetLineItemCalculatedAmount> budgetLineItemCalculatedAmounts;
    private List<BudgetPersonnelDetails> budgetPersonnelDetailsList = new ArrayList<BudgetPersonnelDetails>();
    private boolean budgetPersonnelLineItemDeleted;
    private List<BudgetRateAndBase> budgetRateAndBaseList;
    private Date oldStartDate;
    private Date oldEndDate;
    private Integer subAwardNumber;
    private String hierarchyProposalNumber;
    private boolean hiddenInHierarchy;
    private transient boolean displayTotalDetail = false;
    private transient BudgetDecimal objectTotal;

    public BudgetLineItem() {
        this.budgetLineItemCalculatedAmounts = new ArrayList<BudgetLineItemCalculatedAmount>();
        this.budgetRateAndBaseList = new ArrayList<BudgetRateAndBase>();
        this.objectTotal = new BudgetDecimal(0);
    }

    public List<BudgetPersonnelDetails> getBudgetPersonnelDetailsList() {
        return this.budgetPersonnelDetailsList;
    }

    public void setBudgetPersonnelDetailsList(List<BudgetPersonnelDetails> budgetPersonnelDetailsList) {
        this.budgetPersonnelDetailsList = budgetPersonnelDetailsList;
    }

    public BudgetPersonnelDetails getBudgetPersonnelDetails(int index) {
        while (this.getBudgetPersonnelDetailsList().size() <= index) {
            this.getBudgetPersonnelDetailsList().add(this.getNewBudgetPersonnelLineItem());
        }
        return this.getBudgetPersonnelDetailsList().get(index);
    }

    public BudgetPersonnelDetails getNewBudgetPersonnelLineItem() {
        return new BudgetPersonnelDetails();
    }

    public List<BudgetLineItemCalculatedAmount> getBudgetLineItemCalculatedAmounts() {
        return this.budgetLineItemCalculatedAmounts;
    }

    public void setBudgetLineItemCalculatedAmounts(List<BudgetLineItemCalculatedAmount> budgetLineItemCalculatedAmounts) {
        this.budgetLineItemCalculatedAmounts = budgetLineItemCalculatedAmounts;
    }

    @Override
    public List getBudgetCalculatedAmounts() {
        return this.getBudgetLineItemCalculatedAmounts();
    }

    public boolean isBudgetPersonnelLineItemDeleted() {
        return this.budgetPersonnelLineItemDeleted;
    }

    public void setBudgetPersonnelLineItemDeleted(boolean budgetPersonnelLineItemDeleted) {
        this.budgetPersonnelLineItemDeleted = budgetPersonnelLineItemDeleted;
    }

    public List<BudgetRateAndBase> getBudgetRateAndBaseList() {
        return this.budgetRateAndBaseList;
    }

    public void setBudgetRateAndBaseList(List<BudgetRateAndBase> budgetRateAndBaseList) {
        this.budgetRateAndBaseList = budgetRateAndBaseList;
    }

    public Date getOldStartDate() {
        return this.oldStartDate;
    }

    public void setOldStartDate(Date oldStartDate) {
        this.oldStartDate = oldStartDate;
    }

    public Date getOldEndDate() {
        return this.oldEndDate;
    }

    public void setOldEndDate(Date oldEndDate) {
        this.oldEndDate = oldEndDate;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    @Override
    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    @Override
    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public boolean isDisplayTotalDetail() {
        return this.displayTotalDetail;
    }

    public void setDisplayTotalDetail(boolean displayTotalDetail) {
        this.displayTotalDetail = displayTotalDetail;
    }

    public BudgetDecimal getObjectTotal() {
        return this.objectTotal;
    }

    public void setObjectTotal(BudgetDecimal objectTotal) {
        this.objectTotal = objectTotal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getBudgetPeriodId() == null ? 0 : this.getBudgetPeriodId().hashCode());
        result = 31 * result + (this.getLineItemNumber() == null ? 0 : this.getLineItemNumber().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BudgetLineItem other = (BudgetLineItem)obj;
        if (this.getBudgetPeriodId() == null ? other.getBudgetPeriodId() != null : !this.getBudgetPeriodId().equals(other.getBudgetPeriodId())) {
            return false;
        }
        return !(this.getLineItemNumber() == null ? other.getLineItemNumber() != null : !this.getLineItemNumber().equals(other.getLineItemNumber()));
    }

    public AbstractBudgetCalculatedAmount getNewBudgetLineItemCalculatedAmount() {
        return new BudgetLineItemCalculatedAmount();
    }

    @Override
    public int compareTo(BudgetLineItem o) {
        int compare = this.getCostElementName().compareTo(o.getCostElementName());
        if (compare == 0) {
            compare = this.getLineItemNumber().compareTo(o.getLineItemNumber());
        }
        return compare;
    }

    public boolean isSubAwardLineItem() {
        return this.subAwardNumber != null;
    }

    public Integer getSubAwardNumber() {
        return this.subAwardNumber;
    }

    public void setSubAwardNumber(Integer subAwardNumber) {
        this.subAwardNumber = subAwardNumber;
    }
}

