/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.nonpersonnel;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.BudgetAssociate;
import org.kuali.kra.budget.core.BudgetCategory;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.DeepCopyIgnore;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class BudgetLineItemBase
extends BudgetAssociate {
    private static final long serialVersionUID = 8356817148151906918L;
    @DeepCopyIgnore
    private Long budgetLineItemId;
    private Long budgetPeriodId;
    private Integer budgetPeriod;
    private Integer lineItemNumber;
    private Boolean applyInRateFlag;
    private String budgetJustification;
    private String costElement;
    private BudgetDecimal costSharingAmount = BudgetDecimal.ZERO;
    private Date endDate;
    private BudgetDecimal lineItemCost = BudgetDecimal.ZERO;
    private String lineItemDescription;
    private Boolean onOffCampusFlag;
    private Date startDate;
    private BudgetDecimal underrecoveryAmount = BudgetDecimal.ZERO;
    private String budgetCategoryCode;
    private Integer basedOnLineItem;
    private Integer quantity;
    private BudgetDecimal directCost;
    private BudgetDecimal indirectCost;
    private BudgetCategory budgetCategory;
    private Integer lineItemSequence;
    private Boolean submitCostSharingFlag = Boolean.TRUE;
    private CostElement costElementBO;
    private BudgetDecimal totalCostSharingAmount;
    private boolean validToApplyInRate;
    private String groupName;
    private Boolean formulatedCostElementFlag;
    private List<BudgetFormulatedCostDetail> budgetFormulatedCosts = new ArrayList<BudgetFormulatedCostDetail>();
    @DeepCopyIgnore
    private BudgetPeriod budgetPeriodBO;

    public String getGroupName() {
        return this.groupName;
    }

    public String getCostElementName() {
        if (this.costElementBO != null) {
            return this.costElementBO.getDescription();
        }
        return "";
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public abstract List getBudgetCalculatedAmounts();

    public BudgetDecimal getDirectCost() {
        return BudgetDecimal.returnZeroIfNull(this.directCost);
    }

    public void setDirectCost(BudgetDecimal directCost) {
        this.directCost = directCost;
    }

    public BudgetDecimal getIndirectCost() {
        return BudgetDecimal.returnZeroIfNull(this.indirectCost);
    }

    public void setIndirectCost(BudgetDecimal indirectCost) {
        this.indirectCost = indirectCost;
    }

    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public Integer getLineItemNumber() {
        return this.lineItemNumber;
    }

    public void setLineItemNumber(Integer lineItemNumber) {
        this.lineItemNumber = lineItemNumber;
    }

    public Boolean getApplyInRateFlag() {
        return this.applyInRateFlag;
    }

    public void setApplyInRateFlag(Boolean applyInRateFlag) {
        this.applyInRateFlag = applyInRateFlag;
    }

    public Integer getBasedOnLineItem() {
        return this.basedOnLineItem;
    }

    public void setBasedOnLineItem(Integer basedOnLineItem) {
        this.basedOnLineItem = basedOnLineItem;
    }

    public String getBudgetCategoryCode() {
        return this.budgetCategoryCode;
    }

    public void setBudgetCategoryCode(String budgetCategoryCode) {
        this.budgetCategoryCode = budgetCategoryCode;
    }

    public String getBudgetJustification() {
        return this.budgetJustification;
    }

    public void setBudgetJustification(String budgetJustification) {
        this.budgetJustification = budgetJustification;
    }

    public String getCostElement() {
        return this.costElement;
    }

    public void setCostElement(String costElement) {
        this.costElement = costElement;
    }

    public BudgetDecimal getCostSharingAmount() {
        return BudgetDecimal.returnZeroIfNull(this.costSharingAmount);
    }

    public void setCostSharingAmount(BudgetDecimal costSharingAmount) {
        this.costSharingAmount = costSharingAmount;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BudgetDecimal getLineItemCost() {
        return BudgetDecimal.returnZeroIfNull(this.lineItemCost);
    }

    public void setLineItemCost(BudgetDecimal lineItemCost) {
        this.lineItemCost = lineItemCost;
    }

    public String getLineItemDescription() {
        return this.lineItemDescription;
    }

    public void setLineItemDescription(String lineItemDescription) {
        this.lineItemDescription = lineItemDescription;
    }

    public Integer getLineItemSequence() {
        return this.lineItemSequence;
    }

    public void setLineItemSequence(Integer lineItemSequence) {
        this.lineItemSequence = lineItemSequence;
    }

    public Boolean getOnOffCampusFlag() {
        return this.onOffCampusFlag;
    }

    public void setOnOffCampusFlag(Boolean onOffCampusFlag) {
        this.onOffCampusFlag = onOffCampusFlag;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public BudgetDecimal getUnderrecoveryAmount() {
        return BudgetDecimal.returnZeroIfNull(this.underrecoveryAmount);
    }

    public void setUnderrecoveryAmount(BudgetDecimal underrecoveryAmount) {
        this.underrecoveryAmount = underrecoveryAmount;
    }

    public BudgetCategory getBudgetCategory() {
        return this.budgetCategory;
    }

    public void setBudgetCategory(BudgetCategory budgetCategory) {
        this.budgetCategory = budgetCategory;
    }

    public CostElement getCostElementBO() {
        return this.costElementBO;
    }

    public void setCostElementBO(CostElement costElementBO) {
        this.costElementBO = costElementBO;
    }

    public BudgetDecimal getTotalCostSharingAmount() {
        return BudgetDecimal.returnZeroIfNull(this.totalCostSharingAmount);
    }

    public void setTotalCostSharingAmount(BudgetDecimal totalCostSharingAmount) {
        this.totalCostSharingAmount = totalCostSharingAmount;
    }

    public Long getBudgetPeriodId() {
        return this.budgetPeriodId;
    }

    public void setBudgetPeriodId(Long budgetPeriodId) {
        this.budgetPeriodId = budgetPeriodId;
    }

    public boolean isValidToApplyInRate() {
        return KraServiceLocator.getService(BudgetService.class).ValidInflationCeRate(this);
    }

    public void setValidToApplyInRate(boolean validToApplyInRate) {
        this.validToApplyInRate = validToApplyInRate;
    }

    public Long getBudgetLineItemId() {
        return this.budgetLineItemId;
    }

    public void setBudgetLineItemId(Long budgetLineItemId) {
        this.budgetLineItemId = budgetLineItemId;
    }

    public void setSubmitCostSharingFlag(Boolean submitCostSharingFlag) {
        this.submitCostSharingFlag = submitCostSharingFlag;
    }

    public Boolean getSubmitCostSharingFlag() {
        if (ObjectUtils.isNull((Object)this.budgetPeriodBO)) {
            this.refreshReferenceObject("budgetPeriodBO");
        }
        return this.getBudgetPeriodBO() != null && this.getBudgetPeriodBO().getBudget().getSubmitCostSharingFlag() != false ? this.submitCostSharingFlag : false;
    }

    public BudgetPeriod getBudgetPeriodBO() {
        return this.budgetPeriodBO;
    }

    public void setBudgetPeriodBO(BudgetPeriod budgetPeriodBO) {
        this.budgetPeriodBO = budgetPeriodBO;
    }

    public Boolean getFormulatedCostElementFlag() {
        return this.formulatedCostElementFlag == null ? Boolean.FALSE : this.formulatedCostElementFlag;
    }

    public void setFormulatedCostElementFlag(Boolean formulatedCostElementFlag) {
        this.formulatedCostElementFlag = formulatedCostElementFlag;
    }

    public List<BudgetFormulatedCostDetail> getBudgetFormulatedCosts() {
        return this.budgetFormulatedCosts;
    }

    public void setBudgetFormulatedCosts(List<BudgetFormulatedCostDetail> budgetFormulatedCosts) {
        this.budgetFormulatedCosts = budgetFormulatedCosts;
    }
}

