/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.nonpersonnel;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.calculator.ValidCalcType;
import org.kuali.kra.budget.rates.RateClassType;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ValidCalcTypeMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    private final BusinessObjectService boService;

    public ValidCalcTypeMaintenanceDocumentRule() {
        this(KraServiceLocator.getService(BusinessObjectService.class));
    }

    ValidCalcTypeMaintenanceDocumentRule(BusinessObjectService boService) {
        this.boService = boService;
    }

    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkExistence(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkExistence(document);
    }

    private boolean checkExistence(MaintenanceDocument maintenanceDocument) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        ValidCalcType validCalcType = (ValidCalcType)((Object)maintenanceDocument.getNewMaintainableObject().getDataObject());
        boolean valid = this.validateRateTypeCode(validCalcType.getRateClassCode(), validCalcType.getRateTypeCode());
        valid &= this.validateRateClassType(validCalcType.getRateClassType());
        return valid &= this.validateDependantRateClassType(validCalcType.getDependentRateClassType());
    }

    private boolean validateRateClassType(String rateClassType) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("rateClassType", rateClassType);
        return this.checkExistenceFromTable(RateClassType.class, pkMap, "rateClassType", "Rate Class Type");
    }

    private boolean validateDependantRateClassType(String dependantRateClassType) {
        if (StringUtils.isNotBlank((String)dependantRateClassType)) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("rateClassType", dependantRateClassType);
            return this.checkExistenceFromTable(RateClassType.class, pkMap, "dependentRateClassType", "Dependent Rate Class Type");
        }
        return true;
    }

    private boolean validateRateTypeCode(String rateClassCode, String rateTypeCode) {
        boolean valid = true;
        if (StringUtils.isNotBlank((String)rateClassCode) && StringUtils.isNotBlank((String)rateTypeCode)) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("rateClassCode", rateClassCode);
            pkMap.put("rateTypeCode", rateTypeCode);
            RateType rateType = (RateType)this.boService.findByPrimaryKey(RateType.class, pkMap);
            if (rateType == null) {
                MessageMap errorMap = GlobalVariables.getMessageMap();
                errorMap.putError("document.newMaintainableObject.rateTypeCode", "error.rateType.not.exist", new String[]{rateClassCode, rateTypeCode});
                valid = false;
            }
        }
        return valid;
    }
}

