/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.nonpersonnel;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.budget.rates.ValidCeRateType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ValidCeRateTypeMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkRateTypeExist(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkRateTypeExist(document);
    }

    private boolean checkRateTypeExist(MaintenanceDocument maintenanceDocument) {
        HashMap<String, String> pkMap;
        ValidCeRateType validCeRateType;
        boolean valid = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        if (StringUtils.isNotBlank((String)(validCeRateType = (ValidCeRateType)((Object)maintenanceDocument.getNewMaintainableObject().getDataObject())).getRateClassCode()) && StringUtils.isNotBlank((String)validCeRateType.getRateTypeCode())) {
            pkMap = new HashMap();
            pkMap.put("rateClassCode", validCeRateType.getRateClassCode());
            pkMap.put("rateTypeCode", validCeRateType.getRateTypeCode());
            RateType rateType = (RateType)KraServiceLocator.getService(BusinessObjectService.class).findByPrimaryKey(RateType.class, pkMap);
            if (rateType == null) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.rateTypeCode", "error.rateType.not.exist", new String[]{validCeRateType.getRateClassCode(), validCeRateType.getRateTypeCode()});
                valid = false;
            }
        }
        pkMap = new HashMap<String, String>();
        pkMap.put("costElement", validCeRateType.getCostElement());
        return valid &= this.checkExistenceFromTable(CostElement.class, pkMap, "costElement", "Cost Element");
    }
}

