/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.parameters;

import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetAssociate;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.infrastructure.DeepCopyIgnore;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.kra.proposaldevelopment.budget.service.ProposalBudgetNumberOfMonthsService;
import org.kuali.kra.util.DateUtils;

public class BudgetPeriod
extends BudgetAssociate {
    private static final long serialVersionUID = -7318331486891820078L;
    @DeepCopyIgnore
    private Long budgetPeriodId;
    private Integer budgetPeriod;
    private String comments;
    private BudgetDecimal costSharingAmount;
    private Date endDate;
    private Date startDate;
    private BudgetDecimal totalCost;
    private BudgetDecimal totalCostLimit;
    private BudgetDecimal totalDirectCost;
    private BudgetDecimal totalIndirectCost;
    private BudgetDecimal underrecoveryAmount;
    private List<BudgetLineItem> budgetLineItems;
    private Integer numberOfParticipants;
    private BudgetDecimal expenseTotal;
    private Date oldEndDate;
    private Date oldStartDate;
    private BudgetModular budgetModular;
    private Budget budget;
    private String budgetParentId;
    private String institutionalProposalNumber;
    private Integer institutionalProposalVersion;
    private BudgetDecimal directCostLimit;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy");

    public BudgetPeriod() {
        this.budgetLineItems = new ArrayList<BudgetLineItem>();
    }

    public static Comparator<BudgetPeriod> getBudgetPeriodDateComparator() {
        return new BudgetPeriodDateComparator();
    }

    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public String getLabel() {
        return this.budgetPeriod + ": " + this.getDateRangeLabel();
    }

    public String getDateRangeLabel() {
        return this.dateFormatter.format(this.startDate) + " - " + this.dateFormatter.format(this.endDate);
    }

    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public BudgetDecimal getCostSharingAmount() {
        return this.costSharingAmount == null ? BudgetDecimal.ZERO : this.costSharingAmount;
    }

    public void setCostSharingAmount(BudgetDecimal costSharingAmount) {
        this.costSharingAmount = costSharingAmount;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public BudgetDecimal getTotalCost() {
        return this.totalCost == null ? new BudgetDecimal(0) : this.totalCost;
    }

    public void setTotalCost(BudgetDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public BudgetDecimal getTotalCostLimit() {
        return this.totalCostLimit == null ? new BudgetDecimal(0) : this.totalCostLimit;
    }

    public void setTotalCostLimit(BudgetDecimal totalCostLimit) {
        this.totalCostLimit = totalCostLimit;
    }

    public BudgetDecimal getTotalDirectCost() {
        return this.totalDirectCost == null ? new BudgetDecimal(0) : this.totalDirectCost;
    }

    public void setTotalDirectCost(BudgetDecimal totalDirectCost) {
        this.totalDirectCost = totalDirectCost;
    }

    public BudgetDecimal getTotalIndirectCost() {
        return this.totalIndirectCost == null ? new BudgetDecimal(0) : this.totalIndirectCost;
    }

    public void setTotalIndirectCost(BudgetDecimal totalIndirectCost) {
        this.totalIndirectCost = totalIndirectCost;
    }

    public BudgetDecimal getUnderrecoveryAmount() {
        return this.underrecoveryAmount == null ? new BudgetDecimal(0) : this.underrecoveryAmount;
    }

    public void setUnderrecoveryAmount(BudgetDecimal underrecoveryAmount) {
        this.underrecoveryAmount = underrecoveryAmount;
    }

    public BudgetLineItem getBudgetLineItem(int index) {
        List<BudgetLineItem> items = this.getBudgetLineItems();
        while (items.size() <= index) {
            items.add(this.getNewBudgetLineItem());
        }
        return items.get(index);
    }

    public BudgetLineItem getNewBudgetLineItem() {
        return new BudgetLineItem();
    }

    public BudgetModular getBudgetModular() {
        return this.budgetModular;
    }

    public void setBudgetModular(BudgetModular budgetModular) {
        this.budgetModular = budgetModular;
    }

    public List<BudgetLineItem> getBudgetLineItems() {
        Collections.sort(this.budgetLineItems);
        return this.budgetLineItems;
    }

    public void setBudgetLineItems(List<BudgetLineItem> budgetLineItems) {
        this.budgetLineItems = budgetLineItems;
    }

    public boolean isReadOnly() {
        return this.budgetLineItems != null && this.budgetLineItems.size() > 0;
    }

    public BudgetDecimal getExpenseTotal() {
        return this.expenseTotal;
    }

    public void setExpenseTotal(BudgetDecimal expenseTotal) {
        this.expenseTotal = expenseTotal;
    }

    public int calculateFiscalYear(Date fiscalYearStartDateTime) {
        if (this.startDate == null || fiscalYearStartDateTime == null) {
            return 0;
        }
        Date fiscalYearStartDate = DateUtils.clearTimeFields(fiscalYearStartDateTime);
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(this.startDate);
        int startDateYear = calendar.get(1);
        calendar.setTime(fiscalYearStartDate);
        calendar.set(1, startDateYear);
        Date startDateYearFiscalYearBeginning = new Date(calendar.getTimeInMillis());
        return this.startDate.compareTo(startDateYearFiscalYearBeginning) < 0 ? startDateYear : ++startDateYear;
    }

    public String getDateRange() {
        StringBuffer dateRange = new StringBuffer();
        if (this.getStartDate() != null && this.getEndDate() != null) {
            dateRange.append(this.getDateRangeLabel());
        }
        return dateRange.toString();
    }

    public Date getOldEndDate() {
        return this.oldEndDate;
    }

    public void setOldEndDate(Date oldEndDate) {
        this.oldEndDate = oldEndDate;
    }

    public Date getOldStartDate() {
        return this.oldStartDate;
    }

    public void setOldStartDate(Date oldStartDate) {
        this.oldStartDate = oldStartDate;
    }

    public Long getBudgetPeriodId() {
        return this.budgetPeriodId;
    }

    public void setBudgetPeriodId(Long budgetPeriodId) {
        this.budgetPeriodId = budgetPeriodId;
    }

    public final BudgetDecimal getSumUnderreoveryAmountFromLineItems() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetLineItem lineItem : this.getBudgetLineItems()) {
            amount = (BudgetDecimal)amount.add(lineItem.getUnderrecoveryAmount());
        }
        return amount;
    }

    public final BudgetDecimal getSumCostSharingAmountFromLineItems() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetLineItem lineItem : this.getBudgetLineItems()) {
            amount = (BudgetDecimal)amount.add(lineItem.getCostSharingAmount());
        }
        return amount;
    }

    public final BudgetDecimal getSumTotalCostSharingAmountFromLineItems() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetLineItem lineItem : this.getBudgetLineItems()) {
            amount = (BudgetDecimal)amount.add(lineItem.getTotalCostSharingAmount());
        }
        return amount;
    }

    public final BudgetDecimal getSumDirectCostAmountFromLineItems() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetLineItem lineItem : this.getBudgetLineItems()) {
            amount = (BudgetDecimal)amount.add(lineItem.getDirectCost());
        }
        return amount;
    }

    public final BudgetDecimal getSumIndirectCostAmountFromLineItems() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetLineItem lineItem : this.getBudgetLineItems()) {
            amount = (BudgetDecimal)amount.add(lineItem.getIndirectCost());
        }
        return amount;
    }

    public final BudgetDecimal getSumTotalCostAmountFromLineItems() {
        return (BudgetDecimal)this.getSumDirectCostAmountFromLineItems().add(this.getSumIndirectCostAmountFromLineItems());
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public void setBudgetParentId(String budgetParentId) {
        this.budgetParentId = budgetParentId;
    }

    public String getBudgetParentId() {
        return this.budgetParentId;
    }

    public String getInstitutionalProposalNumber() {
        return this.institutionalProposalNumber;
    }

    public void setInstitutionalProposalNumber(String institutionalProposalNumber) {
        this.institutionalProposalNumber = institutionalProposalNumber;
    }

    public Integer getInstitutionalProposalVersion() {
        return this.institutionalProposalVersion;
    }

    public void setInstitutionalProposalVersion(Integer institutionalProposalVersion) {
        this.institutionalProposalVersion = institutionalProposalVersion;
    }

    public BudgetDecimal getDirectCostLimit() {
        return this.directCostLimit == null ? BudgetDecimal.ZERO : this.directCostLimit;
    }

    public void setDirectCostLimit(BudgetDecimal directCostLimit) {
        this.directCostLimit = directCostLimit;
    }

    public void populateSummaryCalcAmounts() {
    }

    public String getNumberOfMonths() {
        return String.valueOf(this.getProposalBudgetNumberOfMonthsService().getNumberOfMonth(this.getStartDate(), this.getEndDate()));
    }

    protected ProposalBudgetNumberOfMonthsService getProposalBudgetNumberOfMonthsService() {
        return KraServiceLocator.getService(ProposalBudgetNumberOfMonthsService.class);
    }

    public Integer getNumberOfParticipants() {
        return this.numberOfParticipants;
    }

    public void setNumberOfParticipants(Integer numberOfParticipants) {
        this.numberOfParticipants = numberOfParticipants;
    }

    private static class BudgetPeriodDateComparator
    implements Comparator<BudgetPeriod>,
    Serializable {
        private static final long serialVersionUID = 201595688750841114L;
        private static final int FIRST_EQUALS_SECOND = 0;
        private static final int FIRST_LESS_THAN_SECOND = -1;

        private BudgetPeriodDateComparator() {
        }

        @Override
        public int compare(BudgetPeriod bp1, BudgetPeriod bp2) {
            int result = this.compareDates(bp1.getStartDate(), bp2.getStartDate());
            if (result == 0) {
                result = this.compareDates(bp1.getEndDate(), bp2.getEndDate());
            }
            return result;
        }

        private int compareDates(Date d1, Date d2) {
            if (d1 != null) {
                return d1.compareTo(d2);
            }
            return d2 != null ? -1 : 0;
        }
    }
}

