/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.parameters;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.parameters.BudgetPeriodEvent;
import org.kuali.kra.rule.event.KraDocumentEventBase;
import org.kuali.rice.krad.document.Document;

public abstract class BudgetPeriodEventBase
extends KraDocumentEventBase
implements BudgetPeriodEvent {
    private static final Log LOG = LogFactory.getLog(BudgetPeriodEventBase.class);
    private BudgetPeriod budgetPeriod;
    private int budgetPeriodNumber;

    protected BudgetPeriodEventBase(String description, String errorPathPrefix, BudgetDocument document, BudgetPeriod budgetPeriod) {
        super(description, errorPathPrefix, (Document)document);
        this.budgetPeriod = budgetPeriod;
        this.logEvent();
    }

    protected BudgetPeriodEventBase(String description, String errorPathPrefix, BudgetDocument document, int budgetPeriodNumber) {
        super(description, errorPathPrefix, (Document)document);
        this.budgetPeriodNumber = budgetPeriodNumber;
        this.logEvent();
    }

    protected BudgetPeriodEventBase(String description, String errorPathPrefix, BudgetDocument document) {
        super(description, errorPathPrefix, (Document)document);
        this.logEvent();
    }

    @Override
    public BudgetPeriod getBudgetPeriod() {
        return this.budgetPeriod;
    }

    @Override
    public int getBudgetPeriodNumber() {
        return this.budgetPeriodNumber;
    }

    public void validate() {
        super.validate();
    }

    @Override
    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.getBudgetPeriod() == null) {
            logMessage.append("null budgetPeriod");
        } else {
            logMessage.append(this.getBudgetPeriod().toString());
        }
        LOG.debug((Object)logMessage);
    }
}

