/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.parameters;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.AddBudgetPeriodEvent;
import org.kuali.kra.budget.parameters.AddBudgetPeriodRule;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.parameters.DeleteBudgetPeriodEvent;
import org.kuali.kra.budget.parameters.DeleteBudgetPeriodRule;
import org.kuali.kra.budget.parameters.GenerateBudgetPeriodEvent;
import org.kuali.kra.budget.parameters.SaveBudgetPeriodEvent;
import org.kuali.kra.budget.parameters.SaveBudgetPeriodRule;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.infrastructure.BudgetSummaryErrorConstants;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class BudgetPeriodRule
extends ResearchDocumentRuleBase
implements AddBudgetPeriodRule,
SaveBudgetPeriodRule,
DeleteBudgetPeriodRule {
    private static final Log LOG = LogFactory.getLog(BudgetPeriodRule.class);
    private static final String NEW_BUDGET_PERIOD = "newBudgetPeriod";
    private static final String BUDGET_SUMMARY = "budgetParameters";
    private Date projectStartDate;
    private Date projectEndDate;
    private Date previousPeriodEndDate;
    private String[] errorParameter;
    private BudgetDocument budgetDocument;

    @Override
    public boolean processAddBudgetPeriodBusinessRules(AddBudgetPeriodEvent addBudgetPeriodEvent) {
        this.budgetDocument = (BudgetDocument)addBudgetPeriodEvent.getDocument();
        Budget budget = this.budgetDocument.getBudget();
        BudgetPeriod newBudgetPeriod = addBudgetPeriodEvent.getBudgetPeriod();
        boolean rulePassed = true;
        if (!this.isValidBudgetPeriod(budget, newBudgetPeriod)) {
            rulePassed = false;
        }
        if (rulePassed) {
            rulePassed = this.isValidToInsert(budget, newBudgetPeriod);
        }
        return rulePassed;
    }

    @Override
    public boolean processSaveBudgetPeriodBusinessRules(SaveBudgetPeriodEvent saveBudgetPeriodEvent) {
        this.budgetDocument = (BudgetDocument)saveBudgetPeriodEvent.getDocument();
        Budget budget = this.budgetDocument.getBudget();
        BudgetPeriod newBudgetPeriod = saveBudgetPeriodEvent.getBudgetPeriod();
        boolean rulePassed = true;
        if (!this.isValidBudgetPeriod(budget, newBudgetPeriod)) {
            rulePassed = false;
        } else if (!this.isValidBudgetPeriodBoundaries(budget)) {
            rulePassed = false;
        } else if (!this.isBudgetStatusValid(budget)) {
            rulePassed = false;
        }
        if (!Boolean.valueOf(((BudgetDocument)saveBudgetPeriodEvent.getDocument()).getProposalBudgetFlag()).booleanValue()) {
            rulePassed &= this.isValidBudgetPeriodCostLimit(budget);
        }
        return rulePassed;
    }

    public boolean processGenerateBudgetPeriodBusinessRules(GenerateBudgetPeriodEvent generateBudgetPeriodEvent) {
        this.budgetDocument = (BudgetDocument)generateBudgetPeriodEvent.getDocument();
        Budget document = this.budgetDocument.getBudget();
        BudgetPeriod newBudgetPeriod = generateBudgetPeriodEvent.getBudgetPeriod();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        boolean rulePassed = true;
        int budgetPeriodNumber = 0;
        if (!this.isValidBudgetPeriod(document, newBudgetPeriod)) {
            rulePassed = false;
        } else if (!this.isValidBudgetPeriodBoundaries(document)) {
            rulePassed = false;
        } else if (!this.getBudgetSummaryService().budgetLineItemExists(document, budgetPeriodNumber)) {
            errorMap.addToErrorPath(NEW_BUDGET_PERIOD);
            rulePassed = false;
            this.saveErrors("ERROR_PERIOD_LINE_ITEM_DOESNOT_EXIST", errorMap);
        } else if (document.getBudgetPeriods().size() <= budgetPeriodNumber + 1) {
            errorMap.addToErrorPath(NEW_BUDGET_PERIOD);
            rulePassed = false;
            this.saveErrors("ERROR_NO_FUTURE_PERIOD_TO_GENERATE", errorMap);
        } else {
            String errorParam = "";
            for (int i = budgetPeriodNumber + 1; i < document.getBudgetPeriods().size(); ++i) {
                if (!this.getBudgetSummaryService().budgetLineItemExists(document, i)) continue;
                errorParam = errorParam + "" + (i + 1) + ", ";
            }
            if (errorParam.length() > 0) {
                errorMap.addToErrorPath(NEW_BUDGET_PERIOD);
                rulePassed = false;
                errorParam = errorParam.substring(0, errorParam.length() - 2);
                this.setErrorParameter(new String[]{errorParam});
                this.saveErrors("ERROR_GENERATE_PERIOD", errorMap);
            }
        }
        errorMap.removeFromErrorPath(NEW_BUDGET_PERIOD);
        return rulePassed;
    }

    @Override
    public boolean processDeleteBudgetPeriodBusinessRules(DeleteBudgetPeriodEvent deleteBudgetPeriodEvent) {
        this.budgetDocument = (BudgetDocument)deleteBudgetPeriodEvent.getDocument();
        Budget budget = this.budgetDocument.getBudget();
        int budgetPeriodNumber = deleteBudgetPeriodEvent.getBudgetPeriodNumber();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        boolean rulePassed = true;
        if (this.getBudgetSummaryService().budgetLineItemExists(budget, budgetPeriodNumber)) {
            errorMap.addToErrorPath("document.budgetPeriods[" + budgetPeriodNumber + "]");
            rulePassed = false;
            this.saveErrors("ERROR_LINE_ITEM_EXISTS", errorMap);
            errorMap.removeFromErrorPath("document.budgetPeriods[" + budgetPeriodNumber + "]");
        }
        return rulePassed;
    }

    private boolean isBudgetStatusValid(Budget budget) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        boolean statusValid = true;
        String budgetStatusCompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusCompleteCode");
        String budgetStatus = budget.getBudgetStatus();
        boolean finalVersionFlag = budget.getFinalVersionFlag();
        errorMap.addToErrorPath(BUDGET_SUMMARY);
        if (budgetStatus != null && budgetStatus.equals(budgetStatusCompleteCode) && !finalVersionFlag) {
            errorMap.putError("document.proposal.budgetStatus", "error.final.budget.required", new String[0]);
            finalVersionFlag = false;
        }
        errorMap.removeFromErrorPath(BUDGET_SUMMARY);
        return true;
    }

    private boolean isValidBudgetPeriodBoundaries(Budget budget) {
        boolean validBoundaries = true;
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            String[] dateParams = new String[]{budgetPeriod.getBudgetPeriod() + ""};
            this.setErrorParameter(dateParams);
            List<Object> periodLineItems = new ArrayList();
            List<Object> periodPersonnelDetails = new ArrayList();
            Integer budgetPeriodNumber = budgetPeriod.getBudgetPeriod();
            int index = budgetPeriodNumber - 1;
            errorMap.addToErrorPath("document.budgetPeriods[" + index + "]");
            periodLineItems = budgetPeriod.getBudgetLineItems();
            block1: for (BudgetLineItem budgetLineItem : periodLineItems) {
                if (budgetPeriod.getBudgetPeriod() == budgetLineItem.getBudgetPeriod() && (budgetLineItem.getStartDate().before(budgetPeriod.getStartDate()) || budgetLineItem.getStartDate().after(budgetPeriod.getEndDate()) || budgetLineItem.getEndDate().after(budgetPeriod.getEndDate()) || budgetLineItem.getEndDate().before(budgetPeriod.getStartDate()))) {
                    this.saveErrors("ERROR_LINE_ITEM_DATE_DOESNOTMATCH", errorMap);
                    validBoundaries = false;
                    break;
                }
                periodPersonnelDetails = budgetLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetails : periodPersonnelDetails) {
                    if (budgetPeriod.getBudgetPeriod() != budgetPersonnelDetails.getBudgetPeriod() || !budgetPersonnelDetails.getStartDate().before(budgetPeriod.getStartDate()) && !budgetPersonnelDetails.getStartDate().after(budgetPeriod.getEndDate()) && !budgetPersonnelDetails.getEndDate().after(budgetPeriod.getEndDate()) && !budgetPersonnelDetails.getEndDate().before(budgetPeriod.getStartDate())) continue;
                    this.saveErrors("ERROR_LINE_ITEM_DATE_DOESNOTMATCH", errorMap);
                    validBoundaries = false;
                    break block1;
                }
            }
            errorMap.removeFromErrorPath("document.budgetPeriods[" + index + "]");
        }
        return validBoundaries;
    }

    private boolean isValidBudgetPeriodCostLimit(Budget budget) {
        boolean valid = true;
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        int i = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getTotalCostLimit().isGreaterThan(((AwardBudgetExt)budget).getObligatedTotal())) {
                GlobalVariables.getMessageMap().putError("document.budget.budgetPeriods[" + i + "].totalCostLimit", "error.period.costlimit.exceed.obligatedtotal", new String[0]);
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    private boolean isValidNewBudgetPeriod(Budget budget, BudgetPeriod newBudgetPeriod) {
        MessageMap errorMap = GlobalVariables.getMessageMap();
        boolean validNewBudgetPeriod = true;
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        Date previousPeriodStartDate = null;
        Date previousPeriodEndDate = null;
        Date periodStartDate = null;
        Date periodEndDate = null;
        Date newPeriodStartDate = null;
        Date newPeriodEndDate = null;
        int index = 0;
        newPeriodStartDate = newBudgetPeriod.getStartDate();
        newPeriodEndDate = newBudgetPeriod.getEndDate();
        errorMap.addToErrorPath(NEW_BUDGET_PERIOD);
        if (newPeriodStartDate == null) {
            this.saveErrors("ERROR_PERIOD_START_REQUIRED", errorMap);
            validNewBudgetPeriod = false;
        }
        if (newPeriodEndDate == null) {
            this.saveErrors("ERROR_PERIOD_END_REQUIRED", errorMap);
            validNewBudgetPeriod = false;
        }
        errorMap.removeFromErrorPath(NEW_BUDGET_PERIOD);
        if (validNewBudgetPeriod) {
            int totalBudgetPeriods = budgetPeriods.size() - 1;
            errorMap.addToErrorPath(NEW_BUDGET_PERIOD);
            for (BudgetPeriod budgetPeriod : budgetPeriods) {
                periodStartDate = budgetPeriod.getStartDate();
                periodEndDate = budgetPeriod.getEndDate();
                String dateCompareValue = null;
                Date validDateBefore = previousPeriodStartDate == null ? this.projectStartDate : previousPeriodEndDate;
                int periodNum = index;
                String[] newPeriodDateParams = new String[]{periodNum + "", periodNum + 1 + ""};
                String invalidErrorMessage = null;
                this.setErrorParameter(newPeriodDateParams);
                invalidErrorMessage = index == 0 || index == totalBudgetPeriods ? "ERROR_NEW_PERIOD_INVALID" : "ERROR_NEW_PERIOD_VALID";
                if (newPeriodStartDate.compareTo(periodStartDate) == 0 || newPeriodEndDate.compareTo(periodEndDate) == 0) {
                    this.saveErrors(invalidErrorMessage, errorMap);
                    validNewBudgetPeriod = false;
                    break;
                }
                if (newPeriodStartDate.before(periodStartDate) || index == totalBudgetPeriods && newPeriodStartDate.after(periodEndDate)) {
                    boolean lastRecord = false;
                    if (index == totalBudgetPeriods) {
                        lastRecord = true;
                        if (newPeriodStartDate.after(periodEndDate)) {
                            periodNum = index + 1;
                        }
                    }
                    if (newPeriodStartDate.before(this.getProjectStartDate())) {
                        dateCompareValue = "ERROR_PERIOD_START_BEFORE_PROJECT_START";
                    } else if (newPeriodStartDate.after(this.getProjectEndDate())) {
                        dateCompareValue = "ERROR_NEW_PERIOD_START_AFTER_PROJECT_END";
                    } else if (newPeriodEndDate.after(this.getProjectEndDate())) {
                        dateCompareValue = "ERROR_NEW_PERIOD_END_DATE";
                    } else if (newPeriodStartDate.before(validDateBefore)) {
                        dateCompareValue = invalidErrorMessage;
                    } else if (index < totalBudgetPeriods && newPeriodEndDate.after(periodStartDate)) {
                        dateCompareValue = !lastRecord ? invalidErrorMessage : "ERROR_NEW_PERIOD_PROJECT_END";
                    }
                    if (dateCompareValue != null) {
                        this.saveErrors(dateCompareValue, errorMap);
                        validNewBudgetPeriod = false;
                        break;
                    }
                    newBudgetPeriod.setBudgetPeriod(periodNum + 1);
                    break;
                }
                previousPeriodStartDate = budgetPeriod.getStartDate();
                previousPeriodEndDate = budgetPeriod.getEndDate();
                ++index;
            }
            errorMap.removeFromErrorPath(NEW_BUDGET_PERIOD);
        }
        return validNewBudgetPeriod;
    }

    private boolean isValidBudgetPeriod(Budget budget, BudgetPeriod newBudgetPeriod) {
        this.setProjectStartDate(budget.getStartDate());
        this.setProjectEndDate(budget.getEndDate());
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        boolean validBudgetPeriod = true;
        Date previousPeriodStartDate = null;
        Date previousPeriodEndDate = null;
        Date periodStartDate = null;
        Date periodEndDate = null;
        int index = 0;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        boolean insertBudgetPeriod = false;
        int totalBudgetPeriods = budgetPeriods.size() - 1;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            errorMap.addToErrorPath("document.budgetPeriods[" + index + "]");
            periodStartDate = budgetPeriod.getStartDate();
            periodEndDate = budgetPeriod.getEndDate();
            boolean isDateNull = false;
            String[] dateParams = new String[]{index + 1 + ""};
            this.setErrorParameter(dateParams);
            if (periodStartDate == null) {
                this.saveErrors("ERROR_PERIOD_START_REQUIRED", errorMap);
                validBudgetPeriod = false;
                isDateNull = true;
            }
            if (periodEndDate == null) {
                this.saveErrors("ERROR_PERIOD_END_REQUIRED", errorMap);
                validBudgetPeriod = false;
                isDateNull = true;
            }
            if (!isDateNull) {
                Date validDateBefore = previousPeriodStartDate == null ? this.projectStartDate : previousPeriodEndDate;
                String dateCompareValue = this.compareDate(periodStartDate, periodEndDate, previousPeriodEndDate);
                if (dateCompareValue != null) {
                    this.saveErrors(dateCompareValue, errorMap);
                    validBudgetPeriod = false;
                }
                errorMap.removeFromErrorPath("document.budgetPeriods[" + index + "]");
            }
            previousPeriodStartDate = budgetPeriod.getStartDate();
            previousPeriodEndDate = budgetPeriod.getEndDate();
            ++index;
        }
        if (validBudgetPeriod && newBudgetPeriod != null) {
            validBudgetPeriod = this.isValidNewBudgetPeriod(budget, newBudgetPeriod);
        }
        return validBudgetPeriod;
    }

    private void saveErrors(String errorValue, MessageMap errorMap) {
        BudgetSummaryErrorConstants budgetSummaryErrorConstants = BudgetSummaryErrorConstants.valueOf(errorValue);
        String errorKey = budgetSummaryErrorConstants.errorKey();
        String errorProperty = budgetSummaryErrorConstants.errorProperty();
        errorMap.putError(errorProperty, errorKey, this.getErrorParameter());
    }

    private String compareDate(Date periodStartDate, Date periodEndDate, Date previousPeriodEndDate) {
        String returnErrorValue = null;
        LOG.info((Object)("prd st dt " + periodStartDate.getTime() + periodEndDate.getTime() + this.getProjectStartDate().getTime() + this.getProjectEndDate().getTime()));
        Date budgetEndDate = new Date(this.budgetDocument.getBudgetEndDate().getTime());
        Date budgetStartDate = new Date(this.budgetDocument.getBudgetStartDate().getTime());
        if (periodStartDate.after(budgetEndDate)) {
            LOG.info((Object)("ERROR_PERIOD_START_AFTER_PROJECT_END" + periodStartDate + this.getProjectEndDate()));
            returnErrorValue = "ERROR_PERIOD_START_AFTER_PROJECT_END";
        } else if (periodStartDate.before(budgetStartDate)) {
            LOG.info((Object)("ERROR_PERIOD_START_BEFORE_PROJECT_START" + periodStartDate + this.getProjectStartDate()));
            returnErrorValue = "ERROR_PERIOD_START_BEFORE_PROJECT_START";
        } else if (periodEndDate.before(this.getProjectStartDate())) {
            LOG.info((Object)("ERROR_PERIOD_END_BEFORE_PROJECT_START" + periodEndDate + this.getProjectStartDate()));
            returnErrorValue = "ERROR_PERIOD_END_BEFORE_PROJECT_START";
        } else if (periodEndDate.after(budgetEndDate)) {
            LOG.info((Object)("ERROR_PERIOD_END_AFTER_PROJECT_END" + periodEndDate + this.getProjectEndDate()));
            returnErrorValue = "ERROR_PERIOD_END_AFTER_PROJECT_END";
        } else if (periodStartDate.after(periodEndDate)) {
            LOG.info((Object)("ERROR_PERIOD_START_AFTER_PERIOD_END" + periodStartDate + periodEndDate));
            returnErrorValue = "ERROR_PERIOD_START_AFTER_PERIOD_END";
        } else if (previousPeriodEndDate != null && !periodStartDate.after(previousPeriodEndDate)) {
            LOG.info((Object)("ERROR_PERIOD_START_BEFORE_PREVIOUS_END" + previousPeriodEndDate + periodStartDate));
            returnErrorValue = "ERROR_PERIOD_START_BEFORE_PREVIOUS_END";
        } else if (previousPeriodEndDate != null && !periodEndDate.after(previousPeriodEndDate)) {
            LOG.info((Object)("ERROR_PERIOD_END_BEFORE_PREVIOUS_END" + previousPeriodEndDate + periodEndDate));
            returnErrorValue = "ERROR_PERIOD_END_BEFORE_PREVIOUS_END";
        }
        return returnErrorValue;
    }

    private BudgetSummaryService getBudgetSummaryService() {
        return KraServiceLocator.getService(BudgetSummaryService.class);
    }

    private void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    private Date getProjectStartDate() {
        return this.projectStartDate;
    }

    private Date getProjectEndDate() {
        return this.projectEndDate;
    }

    private void setProjectEndDate(Date projectEndDate) {
        this.projectEndDate = projectEndDate;
    }

    public String[] getErrorParameter() {
        return this.errorParameter;
    }

    public void setErrorParameter(String[] errorParameter) {
        this.errorParameter = errorParameter;
    }

    private boolean isValidToInsert(Budget budget, BudgetPeriod newBudgetPeriod) {
        int expenseExistStatus = this.checkExpenseInBudget(budget);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (newBudgetPeriod.getEndDate().before(budget.getBudgetPeriod(0).getStartDate())) {
            if (expenseExistStatus >= 1) {
                errorMap.putError("newBudgetPeriod.error", "error.insert.budget.period", new String[0]);
                return false;
            }
        } else if (newBudgetPeriod.getEndDate().before(budget.getBudgetPeriod(budget.getBudgetPeriods().size() - 1).getStartDate()) && expenseExistStatus > 1) {
            errorMap.putError("newBudgetPeriod.error", "error.insert.budget.period", new String[0]);
            return false;
        }
        return true;
    }

    private int checkExpenseInBudget(Budget budget) {
        int retVal = 0;
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (!CollectionUtils.isNotEmpty(budgetPeriod.getBudgetLineItems())) continue;
            retVal = budgetPeriod.getBudgetPeriod();
        }
        return retVal;
    }
}

