/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.personnel;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.PersonAppointment;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonService;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.PersonRolodex;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetPersonServiceImpl
implements BudgetPersonService {
    private static final Log LOG = LogFactory.getLog(BudgetPersonServiceImpl.class);
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;
    private KcPersonService kcPersonService;

    @Override
    public void addBudgetPerson(Budget budget, BudgetPerson budgetPerson) {
        if (budgetPerson.getPersonId() != null) {
            this.addBudgetEmployee(budget, budgetPerson);
        } else {
            this.populateBudgetPersonData(budget, budgetPerson);
            budget.addBudgetPerson(budgetPerson);
        }
    }

    @Override
    public void populateBudgetPersonData(Budget budget, BudgetPerson budgetPerson) {
        budgetPerson.setBudgetId(budget.getBudgetId());
        budgetPerson.setPersonSequenceNumber(budget.getHackedDocumentNextValue("personSequenceNumber"));
        this.populatePersonDefaultDataIfEmpty(budget, budgetPerson);
    }

    @Override
    public void populateBudgetPersonDefaultDataIfEmpty(Budget budget) {
        for (BudgetPerson budgetPerson : budget.getBudgetPersons()) {
            this.populatePersonDefaultDataIfEmpty(budget, budgetPerson);
        }
    }

    @Override
    public void synchBudgetPersonsToProposal(Budget budget) {
        budget.getBudgetDocument().refreshReferenceObject("documentNextvalues");
        Object budgetParent = budget.getBudgetDocument().getParentDocument().getBudgetParent();
        for (PersonRolodex proposalPerson : budgetParent.getPersonRolodexList()) {
            if (proposalPerson.isOtherSignificantContributorFlag()) continue;
            boolean present = false;
            for (BudgetPerson budgetPerson : budget.getBudgetPersons()) {
                if (proposalPerson.getPersonId() != null && proposalPerson.getPersonId().equals(budgetPerson.getPersonId())) {
                    present = true;
                    break;
                }
                if (proposalPerson.getRolodexId() == null || !proposalPerson.getRolodexId().equals(budgetPerson.getRolodexId())) continue;
                present = true;
                break;
            }
            if (present) continue;
            if (proposalPerson.getPersonId() != null) {
                this.addBudgetEmployee(budget, new BudgetPerson(proposalPerson));
                continue;
            }
            BudgetPerson newBudgetPerson = new BudgetPerson(proposalPerson);
            this.populateBudgetPersonData(budget, newBudgetPerson);
            budget.addBudgetPerson(newBudgetPerson);
        }
    }

    protected void addBudgetEmployee(Budget budget, BudgetPerson budgetPerson) {
        KcPerson kcPerson = this.getKcPersonService().getKcPersonByPersonId(budgetPerson.getPersonId());
        List<PersonAppointment> appointments = kcPerson.getExtendedAttributes().getPersonAppointments();
        boolean added = false;
        String defaultJobCode = this.parameterService.getParameterValueAsString("KC-B", "Document", "budgetPersonDefaultJobCode");
        for (PersonAppointment appointment : appointments) {
            if (!this.isAppointmentApplicableToBudget(budget, appointment)) continue;
            BudgetPerson newBudgetPerson = new BudgetPerson();
            newBudgetPerson.setPersonId(budgetPerson.getPersonId());
            newBudgetPerson.setPersonName(budgetPerson.getPersonName());
            newBudgetPerson.setNonEmployeeFlag(budgetPerson.getNonEmployeeFlag());
            if (StringUtils.isEmpty((String)appointment.getJobCode())) {
                newBudgetPerson.setJobCode(defaultJobCode);
            } else {
                newBudgetPerson.setJobCode(appointment.getJobCode());
            }
            newBudgetPerson.setJobTitle(appointment.getJobTitle());
            newBudgetPerson.setCalculationBase(appointment.getSalary());
            Object proposal = budget.getBudgetDocument().getParentDocument().getBudgetParent();
            budgetPerson.setEffectiveDate(proposal.getRequestedStartDateInitial());
            newBudgetPerson.setAppointmentType(appointment.getAppointmentType());
            newBudgetPerson.setAppointmentTypeCode(appointment.getTypeCode());
            newBudgetPerson.setSalaryAnniversaryDate(kcPerson.getExtendedAttributes().getSalaryAnniversaryDate());
            this.populateBudgetPersonData(budget, newBudgetPerson);
            budget.addBudgetPerson(newBudgetPerson);
            added = true;
        }
        if (!added) {
            this.populateBudgetPersonData(budget, budgetPerson);
            budgetPerson.setJobCode(defaultJobCode);
            budgetPerson.setSalaryAnniversaryDate(kcPerson.getExtendedAttributes().getSalaryAnniversaryDate());
            budget.addBudgetPerson(budgetPerson);
        }
    }

    protected boolean isAppointmentApplicableToBudget(Budget budget, PersonAppointment appointment) {
        Calendar budgetStart = Calendar.getInstance();
        Calendar budgetEnd = Calendar.getInstance();
        Calendar apptStart = Calendar.getInstance();
        Calendar apptEnd = Calendar.getInstance();
        budgetStart.setTime(budget.getStartDate());
        budgetEnd.setTime(budget.getEndDate());
        if (appointment.getStartDate() != null) {
            apptStart.setTime(appointment.getStartDate());
        } else {
            apptStart.setTime(budget.getStartDate());
        }
        if (appointment.getEndDate() != null) {
            apptEnd.setTime(appointment.getEndDate());
        } else {
            apptEnd.setTime(budget.getEndDate());
        }
        return budgetStart.before(apptEnd) && budgetEnd.after(apptStart);
    }

    protected void populatePersonDefaultDataIfEmpty(Budget budget, BudgetPerson budgetPerson) {
        Object proposal = budget.getBudgetDocument().getParentDocument().getBudgetParent();
        if (proposal != null && ObjectUtils.isNull((Object)budgetPerson.getEffectiveDate())) {
            budgetPerson.setEffectiveDate(proposal.getRequestedStartDateInitial());
        }
        if (ObjectUtils.isNull((Object)((Object)budgetPerson.getCalculationBase()))) {
            budgetPerson.setCalculationBase(new BudgetDecimal(this.parameterService.getParameterValueAsString(BudgetDocument.class, "budgetPersonDefaultCalculationBase")));
        }
        if (StringUtils.isBlank((String)budgetPerson.getAppointmentTypeCode())) {
            budgetPerson.setAppointmentTypeCode(this.parameterService.getParameterValueAsString(BudgetDocument.class, "budgetPersonDefaultAppointmentType"));
        }
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public BudgetPerson findBudgetPerson(BudgetPersonnelDetails budgetPersonnelDetails) {
        HashMap<String, Number> queryMap = new HashMap<String, Number>();
        queryMap.put("budgetId", budgetPersonnelDetails.getBudgetId());
        queryMap.put("personSequenceNumber", budgetPersonnelDetails.getPersonSequenceNumber());
        return (BudgetPerson)this.businessObjectService.findByPrimaryKey(BudgetPerson.class, queryMap);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

